/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.HibernateException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class OptimizerFactory {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, OptimizerFactory.class.getName());
    private static Class[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};
    @Deprecated
    public static final String NONE = StandardOptimizerDescriptor.NONE.getExternalName();
    @Deprecated
    public static final String HILO = StandardOptimizerDescriptor.HILO.getExternalName();
    @Deprecated
    public static final String LEGACY_HILO = "legacy-hilo";
    @Deprecated
    public static final String POOL = "pooled";
    @Deprecated
    public static final String POOL_LO = "pooled-lo";

    public static boolean isPooledOptimizer(String string) {
        StandardOptimizerDescriptor standardOptimizerDescriptor = StandardOptimizerDescriptor.fromExternalName(string);
        return standardOptimizerDescriptor != null && standardOptimizerDescriptor.isPooled();
    }

    @Deprecated
    public static Optimizer buildOptimizer(String string, Class clazz, int n) {
        Class clazz2;
        StandardOptimizerDescriptor standardOptimizerDescriptor = StandardOptimizerDescriptor.fromExternalName(string);
        if (standardOptimizerDescriptor != null) {
            clazz2 = standardOptimizerDescriptor.getOptimizerClass();
        } else {
            try {
                clazz2 = ReflectHelper.classForName(string);
            }
            catch (Throwable throwable) {
                LOG.unableToLocateCustomOptimizerClass(string);
                return OptimizerFactory.buildFallbackOptimizer(clazz, n);
            }
        }
        try {
            Constructor constructor = clazz2.getConstructor(CTOR_SIG);
            return (Optimizer)constructor.newInstance(clazz, n);
        }
        catch (Throwable throwable) {
            LOG.unableToInstantiateOptimizer(string);
            return OptimizerFactory.buildFallbackOptimizer(clazz, n);
        }
    }

    private static Optimizer buildFallbackOptimizer(Class clazz, int n) {
        return new NoopOptimizer(clazz, n);
    }

    public static Optimizer buildOptimizer(String string, Class clazz, int n, long l) {
        Optimizer optimizer = OptimizerFactory.buildOptimizer(string, clazz, n);
        if (InitialValueAwareOptimizer.class.isInstance(optimizer)) {
            ((InitialValueAwareOptimizer)((Object)optimizer)).injectInitialValue(l);
        }
        return optimizer;
    }

    public static class PooledLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        public PooledLoOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating pooled optimizer (lo) with [incrementSize={0}; returnClass=]", (Object)n, (Object)clazz.getName());
            }
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.lastSourceValue == null || !this.value.lt(this.lastSourceValue.copy().add(this.incrementSize))) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.value = this.lastSourceValue.copy();
                while (this.value.lt(1L)) {
                    this.value.increment();
                }
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }
    }

    public static class PooledOptimizer
    extends OptimizerSupport
    implements InitialValueAwareOptimizer {
        private IntegralDataTypeHolder hiValue;
        private IntegralDataTypeHolder value;
        private long initialValue = -1L;

        public PooledOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating pooled optimizer with [incrementSize={0}; returnClass={1}]", (Object)n, (Object)clazz.getName());
            }
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.hiValue == null) {
                this.value = accessCallback.getNextValue();
                if (this.value.lt(1L)) {
                    LOG.pooledOptimizerReportedInitialValue(this.value);
                }
                if (this.initialValue == -1L && this.value.lt(this.incrementSize) || this.value.eq(this.initialValue)) {
                    this.hiValue = accessCallback.getNextValue();
                } else {
                    this.hiValue = this.value;
                    this.value = this.hiValue.copy().subtract(this.incrementSize);
                }
            } else if (!this.hiValue.gt(this.value)) {
                this.hiValue = accessCallback.getNextValue();
                this.value = this.hiValue.copy().subtract(this.incrementSize);
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.hiValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        public void injectInitialValue(long l) {
            this.initialValue = l;
        }
    }

    public static class LegacyHiLoAlgorithmOptimizer
    extends OptimizerSupport {
        private long maxLo;
        private long lo;
        private IntegralDataTypeHolder hi;
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        public LegacyHiLoAlgorithmOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating hilo optimizer (legacy) with [incrementSize={0}; returnClass={1}]", (Object)n, (Object)clazz.getName());
            }
            this.maxLo = n;
            this.lo = this.maxLo + 1L;
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.lo > this.maxLo) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.lo = this.lastSourceValue.eq(0L) ? 1L : 0L;
                this.hi = this.lastSourceValue.copy().multiplyBy(this.maxLo + 1L);
            }
            this.value = this.hi.copy().add(this.lo++);
            return this.value.makeValue();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue.copy();
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value;
        }
    }

    public static class HiLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder upperLimit;
        private IntegralDataTypeHolder value;

        public HiLoOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating hilo optimizer with [incrementSize={0}; returnClass={1}]", (Object)n, (Object)clazz.getName());
            }
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.lastSourceValue == null) {
                this.lastSourceValue = accessCallback.getNextValue();
                while (this.lastSourceValue.lt(1L)) {
                    this.lastSourceValue = accessCallback.getNextValue();
                }
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
                this.value = this.upperLimit.copy().subtract(this.incrementSize);
            } else if (!this.upperLimit.gt(this.value)) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        public IntegralDataTypeHolder getHiValue() {
            return this.upperLimit;
        }
    }

    public static class NoopOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;

        public NoopOptimizer(Class clazz, int n) {
            super(clazz, n);
        }

        public Serializable generate(AccessCallback accessCallback) {
            IntegralDataTypeHolder integralDataTypeHolder = null;
            while (integralDataTypeHolder == null || integralDataTypeHolder.lt(1L)) {
                integralDataTypeHolder = accessCallback.getNextValue();
            }
            this.lastSourceValue = integralDataTypeHolder;
            return integralDataTypeHolder.makeValue();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }
    }

    public static abstract class OptimizerSupport
    implements Optimizer {
        protected final Class returnClass;
        protected final int incrementSize;

        protected OptimizerSupport(Class clazz, int n) {
            if (clazz == null) {
                throw new HibernateException("return class is required");
            }
            this.returnClass = clazz;
            this.incrementSize = n;
        }

        public final Class getReturnClass() {
            return this.returnClass;
        }

        public final int getIncrementSize() {
            return this.incrementSize;
        }
    }

    public static interface InitialValueAwareOptimizer {
        public void injectInitialValue(long var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardOptimizerDescriptor {
        NONE("none", NoopOptimizer.class),
        HILO("hilo", HiLoOptimizer.class),
        LEGACY_HILO("legacy-hilo", LegacyHiLoAlgorithmOptimizer.class),
        POOLED("pooled", PooledOptimizer.class, true),
        POOLED_LO("pooled-lo", PooledLoOptimizer.class, true);

        private final String externalName;
        private final Class<? extends Optimizer> optimizerClass;
        private final boolean isPooled;

        private StandardOptimizerDescriptor(String string2, Class<? extends Optimizer> clazz) {
            this(string2, clazz, false);
        }

        private StandardOptimizerDescriptor(String string2, Class<? extends Optimizer> clazz, boolean bl) {
            this.externalName = string2;
            this.optimizerClass = clazz;
            this.isPooled = bl;
        }

        public String getExternalName() {
            return this.externalName;
        }

        public Class<? extends Optimizer> getOptimizerClass() {
            return this.optimizerClass;
        }

        public boolean isPooled() {
            return this.isPooled;
        }

        public static StandardOptimizerDescriptor fromExternalName(String string) {
            if (StringHelper.isEmpty(string)) {
                LOG.debug("No optimizer specified, using NONE as default");
                return NONE;
            }
            if (StandardOptimizerDescriptor.NONE.externalName.equals(string)) {
                return NONE;
            }
            if (StandardOptimizerDescriptor.HILO.externalName.equals(string)) {
                return HILO;
            }
            if (StandardOptimizerDescriptor.LEGACY_HILO.externalName.equals(string)) {
                return LEGACY_HILO;
            }
            if (StandardOptimizerDescriptor.POOLED.externalName.equals(string)) {
                return POOLED;
            }
            if (StandardOptimizerDescriptor.POOLED_LO.externalName.equals(string)) {
                return POOLED_LO;
            }
            LOG.debugf("Unknown optimizer key [%s]; returning null assuming Optimizer impl class name", (Object)string);
            return null;
        }
    }
}

