/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.AbstractUUIDGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class UUIDHexGenerator
extends AbstractUUIDGenerator
implements Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, UUIDHexGenerator.class.getName());
    private static boolean warned = false;
    private String sep = "";

    public UUIDHexGenerator() {
        if (!warned) {
            warned = true;
            LOG.usingUuidHexGenerator(this.getClass().getName(), UUIDGenerator.class.getName());
        }
    }

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.sep = ConfigurationHelper.getString("separator", properties, "");
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return new StringBuilder(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    protected String format(int n) {
        String string = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder("00000000");
        stringBuilder.replace(8 - string.length(), 8, string);
        return stringBuilder.toString();
    }

    protected String format(short s) {
        String string = Integer.toHexString(s);
        StringBuilder stringBuilder = new StringBuilder("0000");
        stringBuilder.replace(4 - string.length(), 4, string);
        return stringBuilder.toString();
    }
}

