/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

@Deprecated
public class TableGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String DEFAULT_COLUMN_NAME = "next_hi";
    public static final String TABLE = "table";
    public static final String DEFAULT_TABLE_NAME = "hibernate_unique_key";
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableGenerator.class.getName());
    private Type identifierType;
    private String tableName;
    private String columnName;
    private String query;
    private String update;

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.identifierType = type;
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        this.tableName = ConfigurationHelper.getString(TABLE, properties, DEFAULT_TABLE_NAME);
        if (this.tableName.indexOf(46) < 0) {
            String string = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema"));
            String string2 = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog"));
            this.tableName = Table.qualify(dialect.quote(string2), dialect.quote(string), dialect.quote(this.tableName));
        }
        this.columnName = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(ConfigurationHelper.getString(COLUMN, properties, DEFAULT_COLUMN_NAME)));
        this.query = "select " + this.columnName + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableName) + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
    }

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return this.generateHolder(sessionImplementor).makeValue();
    }

    protected IntegralDataTypeHolder generateHolder(SessionImplementor sessionImplementor) {
        final SqlStatementLogger sqlStatementLogger = sessionImplementor.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
        return sessionImplementor.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

            @Override
            public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                int n;
                IntegralDataTypeHolder integralDataTypeHolder = TableGenerator.this.buildHolder();
                do {
                    AutoCloseable autoCloseable;
                    sqlStatementLogger.logStatement(TableGenerator.this.query, FormatStyle.BASIC.getFormatter());
                    PreparedStatement preparedStatement = connection.prepareStatement(TableGenerator.this.query);
                    try {
                        autoCloseable = preparedStatement.executeQuery();
                        if (!autoCloseable.next()) {
                            String string = "could not read a hi value - you need to populate the table: " + TableGenerator.this.tableName;
                            LOG.error(string);
                            throw new IdentifierGenerationException(string);
                        }
                        integralDataTypeHolder.initialize((ResultSet)autoCloseable, 1L);
                        autoCloseable.close();
                    }
                    catch (SQLException sQLException) {
                        LOG.error("Could not read a hi value", sQLException);
                        throw sQLException;
                    }
                    finally {
                        preparedStatement.close();
                    }
                    sqlStatementLogger.logStatement(TableGenerator.this.update, FormatStyle.BASIC.getFormatter());
                    autoCloseable = connection.prepareStatement(TableGenerator.this.update);
                    try {
                        integralDataTypeHolder.copy().increment().bind((PreparedStatement)autoCloseable, 1);
                        integralDataTypeHolder.bind((PreparedStatement)autoCloseable, 2);
                        n = autoCloseable.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        LOG.error(LOG.unableToUpdateHiValue(TableGenerator.this.tableName), sQLException);
                        throw sQLException;
                    }
                    finally {
                        autoCloseable.close();
                    }
                } while (n == 0);
                return integralDataTypeHolder;
            }
        }, true);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{dialect.getDropTableString(this.tableName)};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }
}

