/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.sql.Insert;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SequenceIdentityGenerator
extends SequenceGenerator
implements PostInsertIdentifierGenerator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SequenceIdentityGenerator.class.getName());

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return IdentifierGeneratorHelper.POST_INSERT_INDICATOR;
    }

    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect, boolean bl) throws HibernateException {
        return new Delegate(postInsertIdentityPersister, dialect, this.getSequenceName());
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        super.configure(type, properties, dialect);
    }

    public static class NoCommentsInsert
    extends IdentifierGeneratingInsert {
        public NoCommentsInsert(Dialect dialect) {
            super(dialect);
        }

        public Insert setComment(String string) {
            LOG.disallowingInsertStatementComment();
            return this;
        }
    }

    public static class Delegate
    extends AbstractReturningDelegate {
        private final Dialect dialect;
        private final String sequenceNextValFragment;
        private final String[] keyColumns;

        public Delegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect, String string) {
            super(postInsertIdentityPersister);
            this.dialect = dialect;
            this.sequenceNextValFragment = dialect.getSelectSequenceNextValString(string);
            this.keyColumns = this.getPersister().getRootTableKeyColumnNames();
            if (this.keyColumns.length > 1) {
                throw new HibernateException("sequence-identity generator cannot be used with with multi-column keys");
            }
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            NoCommentsInsert noCommentsInsert = new NoCommentsInsert(this.dialect);
            noCommentsInsert.addColumn(this.getPersister().getRootTableKeyColumnNames()[0], this.sequenceNextValFragment);
            return noCommentsInsert;
        }

        protected PreparedStatement prepare(String string, SessionImplementor sessionImplementor) throws SQLException {
            return sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, this.keyColumns);
        }

        protected Serializable executeAndExtract(PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws SQLException {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
            return IdentifierGeneratorHelper.getGeneratedIdentity(preparedStatement.getGeneratedKeys(), this.getPersister().getRootTableKeyColumnNames()[0], this.getPersister().getIdentifierType());
        }
    }
}

