/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
Configurable {
    private static final Logger LOG = Logger.getLogger(SequenceGenerator.class.getName());
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;

    protected Type getIdentifierType() {
        return this.identifierType;
    }

    public Object generatorKey() {
        return this.getSequenceName();
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        this.sequenceName = objectNameNormalizer.normalizeIdentifierQuoting(ConfigurationHelper.getString(SEQUENCE, properties, "hibernate_sequence"));
        this.parameters = properties.getProperty(PARAMETERS);
        if (this.sequenceName.indexOf(46) < 0) {
            String string = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema"));
            String string2 = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog"));
            this.sequenceName = Table.qualify(dialect.quote(string2), dialect.quote(string), dialect.quote(this.sequenceName));
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return this.generateHolder(sessionImplementor).makeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected IntegralDataTypeHolder generateHolder(SessionImplementor sessionImplementor) {
        try {
            PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
            try {
                ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
                try {
                    resultSet.next();
                    IntegralDataTypeHolder integralDataTypeHolder = this.buildHolder();
                    integralDataTypeHolder.initialize(resultSet, 1L);
                    LOG.debugf("Sequence identifier generated: %s", (Object)integralDataTypeHolder);
                    IntegralDataTypeHolder integralDataTypeHolder2 = integralDataTypeHolder;
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                    return integralDataTypeHolder2;
                }
                catch (Throwable throwable) {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                    throw throwable;
                }
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not get next sequence value", this.sql);
        }
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] stringArray = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = stringArray.length - 1;
            stringArray[n] = stringArray[n] + ' ' + this.parameters;
        }
        return stringArray;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public boolean supportsBulkInsertionIdentifierGeneration() {
        return true;
    }

    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        return dialect.getSelectSequenceNextValString(this.getSequenceName());
    }
}

