/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class MultipleHiLoPerTableGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, MultipleHiLoPerTableGenerator.class.getName());
    public static final String ID_TABLE = "table";
    public static final String PK_COLUMN_NAME = "primary_key_column";
    public static final String PK_VALUE_NAME = "primary_key_value";
    public static final String VALUE_COLUMN_NAME = "value_column";
    public static final String PK_LENGTH_NAME = "primary_key_length";
    private static final int DEFAULT_PK_LENGTH = 255;
    public static final String DEFAULT_TABLE = "hibernate_sequences";
    private static final String DEFAULT_PK_COLUMN = "sequence_name";
    private static final String DEFAULT_VALUE_COLUMN = "sequence_next_hi_value";
    private String tableName;
    private String pkColumnName;
    private String valueColumnName;
    private String query;
    private String insert;
    private String update;
    public static final String MAX_LO = "max_lo";
    private int maxLo;
    private OptimizerFactory.LegacyHiLoAlgorithmOptimizer hiloOptimizer;
    private Class returnClass;
    private int keySize;

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + ' ' + this.tableName + " ( " + this.pkColumnName + ' ' + dialect.getTypeName(12, this.keySize, 0, 0) + ",  " + this.valueColumnName + ' ' + dialect.getTypeName(4) + " ) "};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getDropTableString(this.tableName)};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    public synchronized Serializable generate(final SessionImplementor sessionImplementor, Object object) {
        final AbstractReturningWork<IntegralDataTypeHolder> abstractReturningWork = new AbstractReturningWork<IntegralDataTypeHolder>(){

            @Override
            public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                int n;
                IntegralDataTypeHolder integralDataTypeHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(MultipleHiLoPerTableGenerator.this.returnClass);
                SqlStatementLogger sqlStatementLogger = sessionImplementor.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
                do {
                    AutoCloseable autoCloseable;
                    sqlStatementLogger.logStatement(MultipleHiLoPerTableGenerator.this.query, FormatStyle.BASIC.getFormatter());
                    PreparedStatement preparedStatement = connection.prepareStatement(MultipleHiLoPerTableGenerator.this.query);
                    Statement statement = null;
                    try {
                        autoCloseable = preparedStatement.executeQuery();
                        boolean bl = autoCloseable.next();
                        if (!bl) {
                            integralDataTypeHolder.initialize(0L);
                            sqlStatementLogger.logStatement(MultipleHiLoPerTableGenerator.this.insert, FormatStyle.BASIC.getFormatter());
                            statement = connection.prepareStatement(MultipleHiLoPerTableGenerator.this.insert);
                            integralDataTypeHolder.bind((PreparedStatement)statement, 1);
                            statement.execute();
                        } else {
                            integralDataTypeHolder.initialize((ResultSet)autoCloseable, 0L);
                        }
                        autoCloseable.close();
                    }
                    catch (SQLException sQLException) {
                        LOG.unableToReadOrInitHiValue(sQLException);
                        throw sQLException;
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                        preparedStatement.close();
                    }
                    sqlStatementLogger.logStatement(MultipleHiLoPerTableGenerator.this.update, FormatStyle.BASIC.getFormatter());
                    autoCloseable = connection.prepareStatement(MultipleHiLoPerTableGenerator.this.update);
                    try {
                        integralDataTypeHolder.copy().increment().bind((PreparedStatement)autoCloseable, 1);
                        integralDataTypeHolder.bind((PreparedStatement)autoCloseable, 2);
                        n = autoCloseable.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        LOG.error(LOG.unableToUpdateHiValue(MultipleHiLoPerTableGenerator.this.tableName), sQLException);
                        throw sQLException;
                    }
                    finally {
                        autoCloseable.close();
                    }
                } while (n == 0);
                return integralDataTypeHolder;
            }
        };
        if (this.maxLo < 1) {
            IntegralDataTypeHolder integralDataTypeHolder = null;
            while (integralDataTypeHolder == null || integralDataTypeHolder.lt(1L)) {
                integralDataTypeHolder = sessionImplementor.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(abstractReturningWork, true);
            }
            return integralDataTypeHolder.makeValue();
        }
        return this.hiloOptimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)sessionImplementor.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(abstractReturningWork, true);
            }
        });
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        String string;
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        this.tableName = objectNameNormalizer.normalizeIdentifierQuoting(ConfigurationHelper.getString(ID_TABLE, properties, DEFAULT_TABLE));
        if (this.tableName.indexOf(46) < 0) {
            this.tableName = dialect.quote(this.tableName);
            string = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema")));
            String string2 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog")));
            this.tableName = Table.qualify(string2, string, this.tableName);
        }
        this.pkColumnName = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(ConfigurationHelper.getString(PK_COLUMN_NAME, properties, DEFAULT_PK_COLUMN)));
        this.valueColumnName = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(ConfigurationHelper.getString(VALUE_COLUMN_NAME, properties, DEFAULT_VALUE_COLUMN)));
        this.keySize = ConfigurationHelper.getInt(PK_LENGTH_NAME, properties, 255);
        string = ConfigurationHelper.getString(PK_VALUE_NAME, properties, properties.getProperty("target_table"));
        this.query = "select " + this.valueColumnName + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableName) + " where " + this.pkColumnName + " = '" + string + "'" + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.valueColumnName + " = ? where " + this.valueColumnName + " = ? and " + this.pkColumnName + " = '" + string + "'";
        this.insert = "insert into " + this.tableName + "(" + this.pkColumnName + ", " + this.valueColumnName + ") " + "values('" + string + "', ?)";
        this.maxLo = ConfigurationHelper.getInt(MAX_LO, properties, Short.MAX_VALUE);
        this.returnClass = type.getReturnedClass();
        if (this.maxLo >= 1) {
            this.hiloOptimizer = new OptimizerFactory.LegacyHiLoAlgorithmOptimizer(this.returnClass, this.maxLo);
        }
    }
}

