/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IncrementGenerator.class.getName());
    private Class returnClass;
    private String sql;
    private IntegralDataTypeHolder previousValueHolder;

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (this.sql != null) {
            this.initializePreviousValueHolder(sessionImplementor);
        }
        return this.previousValueHolder.makeValueThenIncrement();
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.returnClass = type.getReturnedClass();
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = properties.getProperty("column");
        if (string == null) {
            string = properties.getProperty("target_column");
        }
        string = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(string));
        String string2 = properties.getProperty("tables");
        if (string2 == null) {
            string2 = properties.getProperty("identity_tables");
        }
        String[] stringArray = StringHelper.split(", ", string2);
        String string3 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema")));
        String string4 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog")));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(stringArray[i]));
            if (stringArray.length > 1) {
                stringBuilder.append("select max(").append(string).append(") as mx from ");
            }
            stringBuilder.append(Table.qualify(string4, string3, string5));
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(" union ");
        }
        if (stringArray.length > 1) {
            stringBuilder.insert(0, "( ").append(" ) ids_");
            string = "ids_.mx";
        }
        this.sql = "select max(" + string + ") from " + stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePreviousValueHolder(SessionImplementor sessionImplementor) {
        this.previousValueHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass);
        boolean bl = LOG.isDebugEnabled();
        if (bl) {
            LOG.debugf("Fetching initial value: %s", (Object)this.sql);
        }
        try {
            PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
            try {
                ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
                try {
                    if (resultSet.next()) {
                        this.previousValueHolder.initialize(resultSet, 0L).increment();
                    } else {
                        this.previousValueHolder.initialize(1L);
                    }
                    this.sql = null;
                    if (bl) {
                        LOG.debugf("First free id: %s", (Object)this.previousValueHolder.makeValue());
                    }
                }
                finally {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                }
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

