/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.AbstractSelectingDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertSelectIdentityInsert;

public class IdentityGenerator
extends AbstractPostInsertGenerator {
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect, boolean bl) throws HibernateException {
        if (bl) {
            return new GetGeneratedKeysDelegate(postInsertIdentityPersister, dialect);
        }
        if (dialect.supportsInsertSelectIdentity()) {
            return new InsertSelectDelegate(postInsertIdentityPersister, dialect);
        }
        return new BasicDelegate(postInsertIdentityPersister, dialect);
    }

    public static class BasicDelegate
    extends AbstractSelectingDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public BasicDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect) {
            super(postInsertIdentityPersister);
            this.persister = postInsertIdentityPersister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            IdentifierGeneratingInsert identifierGeneratingInsert = new IdentifierGeneratingInsert(this.dialect);
            identifierGeneratingInsert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return identifierGeneratingInsert;
        }

        protected String getSelectSQL() {
            return this.persister.getIdentitySelectString();
        }

        protected Serializable getResult(SessionImplementor sessionImplementor, ResultSet resultSet, Object object) throws SQLException {
            return IdentifierGeneratorHelper.getGeneratedIdentity(resultSet, this.persister.getRootTableKeyColumnNames()[0], this.persister.getIdentifierType());
        }
    }

    public static class InsertSelectDelegate
    extends AbstractReturningDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public InsertSelectDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect) {
            super(postInsertIdentityPersister);
            this.persister = postInsertIdentityPersister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            InsertSelectIdentityInsert insertSelectIdentityInsert = new InsertSelectIdentityInsert(this.dialect);
            insertSelectIdentityInsert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return insertSelectIdentityInsert;
        }

        protected PreparedStatement prepare(String string, SessionImplementor sessionImplementor) throws SQLException {
            return sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable executeAndExtract(PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws SQLException {
            ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().execute(preparedStatement);
            try {
                Serializable serializable = IdentifierGeneratorHelper.getGeneratedIdentity(resultSet, this.persister.getRootTableKeyColumnNames()[0], this.persister.getIdentifierType());
                return serializable;
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
            }
        }

        public Serializable determineGeneratedIdentifier(SessionImplementor sessionImplementor, Object object) {
            throw new AssertionFailure("insert statement returns generated value");
        }
    }

    public static class GetGeneratedKeysDelegate
    extends AbstractReturningDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;

        public GetGeneratedKeysDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect) {
            super(postInsertIdentityPersister);
            this.persister = postInsertIdentityPersister;
            this.dialect = dialect;
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            IdentifierGeneratingInsert identifierGeneratingInsert = new IdentifierGeneratingInsert(this.dialect);
            identifierGeneratingInsert.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return identifierGeneratingInsert;
        }

        protected PreparedStatement prepare(String string, SessionImplementor sessionImplementor) throws SQLException {
            return sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable executeAndExtract(PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws SQLException {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.getGeneratedKeys();
                Serializable serializable = IdentifierGeneratorHelper.getGeneratedIdentity(resultSet, this.persister.getRootTableKeyColumnNames()[0], this.persister.getIdentifierType());
                return serializable;
            }
            finally {
                if (resultSet != null) {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                }
            }
        }
    }
}

