/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.ResultSetIdentifierConsumer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class IdentifierGeneratorHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IdentifierGeneratorHelper.class.getName());
    public static final Serializable SHORT_CIRCUIT_INDICATOR = new Serializable(){

        public String toString() {
            return "SHORT_CIRCUIT_INDICATOR";
        }
    };
    public static final Serializable POST_INSERT_INDICATOR = new Serializable(){

        public String toString() {
            return "POST_INSERT_INDICATOR";
        }
    };

    public static Serializable getGeneratedIdentity(ResultSet resultSet, String string, Type type) throws SQLException, HibernateException {
        if (!resultSet.next()) {
            throw new HibernateException("The database returned no natively generated identity value");
        }
        Serializable serializable = IdentifierGeneratorHelper.get(resultSet, string, type);
        LOG.debugf("Natively generated identity: %s", (Object)serializable);
        return serializable;
    }

    public static Serializable get(ResultSet resultSet, String string, Type type) throws SQLException, IdentifierGenerationException {
        Serializable serializable;
        if (ResultSetIdentifierConsumer.class.isInstance(type)) {
            return ((ResultSetIdentifierConsumer)((Object)type)).consumeIdentifier(resultSet);
        }
        if (CustomType.class.isInstance(type) && ResultSetIdentifierConsumer.class.isInstance(((CustomType)(serializable = (CustomType)type)).getUserType())) {
            return ((ResultSetIdentifierConsumer)((Object)((CustomType)serializable).getUserType())).consumeIdentifier(resultSet);
        }
        serializable = type.getReturnedClass();
        if (resultSet.getMetaData().getColumnCount() == 1) {
            if (serializable == Long.class) {
                return Long.valueOf(resultSet.getLong(1));
            }
            if (serializable == Integer.class) {
                return Integer.valueOf(resultSet.getInt(1));
            }
            if (serializable == Short.class) {
                return Short.valueOf(resultSet.getShort(1));
            }
            if (serializable == String.class) {
                return resultSet.getString(1);
            }
            if (serializable == BigInteger.class) {
                return resultSet.getBigDecimal(1).setScale(0, 7).toBigInteger();
            }
            if (serializable == BigDecimal.class) {
                return resultSet.getBigDecimal(1).setScale(0, 7);
            }
            throw new IdentifierGenerationException("unrecognized id type : " + type.getName() + " -> " + ((Class)serializable).getName());
        }
        if (serializable == Long.class) {
            return Long.valueOf(resultSet.getLong(string));
        }
        if (serializable == Integer.class) {
            return Integer.valueOf(resultSet.getInt(string));
        }
        if (serializable == Short.class) {
            return Short.valueOf(resultSet.getShort(string));
        }
        if (serializable == String.class) {
            return resultSet.getString(string);
        }
        if (serializable == BigInteger.class) {
            return resultSet.getBigDecimal(string).setScale(0, 7).toBigInteger();
        }
        if (serializable == BigDecimal.class) {
            return resultSet.getBigDecimal(string).setScale(0, 7);
        }
        throw new IdentifierGenerationException("unrecognized id type : " + type.getName() + " -> " + ((Class)serializable).getName());
    }

    @Deprecated
    public static Number createNumber(long l, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return l;
        }
        if (clazz == Integer.class) {
            return (int)l;
        }
        if (clazz == Short.class) {
            return (short)l;
        }
        throw new IdentifierGenerationException("unrecognized id type : " + clazz.getName());
    }

    public static IntegralDataTypeHolder getIntegralDataTypeHolder(Class clazz) {
        if (clazz == Long.class || clazz == Integer.class || clazz == Short.class) {
            return new BasicHolder(clazz);
        }
        if (clazz == BigInteger.class) {
            return new BigIntegerHolder();
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimalHolder();
        }
        throw new IdentifierGenerationException("Unknown integral data type for ids : " + clazz.getName());
    }

    public static long extractLong(IntegralDataTypeHolder integralDataTypeHolder) {
        if (integralDataTypeHolder.getClass() == BasicHolder.class) {
            ((BasicHolder)integralDataTypeHolder).checkInitialized();
            return ((BasicHolder)integralDataTypeHolder).value;
        }
        if (integralDataTypeHolder.getClass() == BigIntegerHolder.class) {
            ((BigIntegerHolder)integralDataTypeHolder).checkInitialized();
            return ((BigIntegerHolder)integralDataTypeHolder).value.longValue();
        }
        if (integralDataTypeHolder.getClass() == BigDecimalHolder.class) {
            ((BigDecimalHolder)integralDataTypeHolder).checkInitialized();
            return ((BigDecimalHolder)integralDataTypeHolder).value.longValue();
        }
        throw new IdentifierGenerationException("Unknown IntegralDataTypeHolder impl [" + integralDataTypeHolder + "]");
    }

    public static BigInteger extractBigInteger(IntegralDataTypeHolder integralDataTypeHolder) {
        if (integralDataTypeHolder.getClass() == BasicHolder.class) {
            ((BasicHolder)integralDataTypeHolder).checkInitialized();
            return BigInteger.valueOf(((BasicHolder)integralDataTypeHolder).value);
        }
        if (integralDataTypeHolder.getClass() == BigIntegerHolder.class) {
            ((BigIntegerHolder)integralDataTypeHolder).checkInitialized();
            return ((BigIntegerHolder)integralDataTypeHolder).value;
        }
        if (integralDataTypeHolder.getClass() == BigDecimalHolder.class) {
            ((BigDecimalHolder)integralDataTypeHolder).checkInitialized();
            return ((BigDecimalHolder)integralDataTypeHolder).value.toBigInteger();
        }
        throw new IdentifierGenerationException("Unknown IntegralDataTypeHolder impl [" + integralDataTypeHolder + "]");
    }

    public static BigDecimal extractBigDecimal(IntegralDataTypeHolder integralDataTypeHolder) {
        if (integralDataTypeHolder.getClass() == BasicHolder.class) {
            ((BasicHolder)integralDataTypeHolder).checkInitialized();
            return BigDecimal.valueOf(((BasicHolder)integralDataTypeHolder).value);
        }
        if (integralDataTypeHolder.getClass() == BigIntegerHolder.class) {
            ((BigIntegerHolder)integralDataTypeHolder).checkInitialized();
            return new BigDecimal(((BigIntegerHolder)integralDataTypeHolder).value);
        }
        if (integralDataTypeHolder.getClass() == BigDecimalHolder.class) {
            ((BigDecimalHolder)integralDataTypeHolder).checkInitialized();
            return ((BigDecimalHolder)integralDataTypeHolder).value;
        }
        throw new IdentifierGenerationException("Unknown IntegralDataTypeHolder impl [" + integralDataTypeHolder + "]");
    }

    private IdentifierGeneratorHelper() {
    }

    public static class BigDecimalHolder
    implements IntegralDataTypeHolder {
        private BigDecimal value;

        public IntegralDataTypeHolder initialize(long l) {
            this.value = BigDecimal.valueOf(l);
            return this;
        }

        public IntegralDataTypeHolder initialize(ResultSet resultSet, long l) throws SQLException {
            BigDecimal bigDecimal = resultSet.getBigDecimal(1);
            if (resultSet.wasNull()) {
                return this.initialize(l);
            }
            this.value = bigDecimal.setScale(0, 7);
            return this;
        }

        public void bind(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setBigDecimal(n, this.value);
        }

        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            this.value = this.value.add(BigDecimal.ONE);
            return this;
        }

        private void checkInitialized() {
            if (this.value == null) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        public IntegralDataTypeHolder add(long l) {
            this.checkInitialized();
            this.value = this.value.add(BigDecimal.valueOf(l));
            return this;
        }

        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            this.value = this.value.subtract(BigDecimal.ONE);
            return this;
        }

        public IntegralDataTypeHolder subtract(long l) {
            this.checkInitialized();
            this.value = this.value.subtract(BigDecimal.valueOf(l));
            return this;
        }

        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            this.value = this.value.multiply(IdentifierGeneratorHelper.extractBigDecimal(integralDataTypeHolder));
            return this;
        }

        public IntegralDataTypeHolder multiplyBy(long l) {
            this.checkInitialized();
            this.value = this.value.multiply(BigDecimal.valueOf(l));
            return this;
        }

        public boolean eq(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigDecimal(integralDataTypeHolder)) == 0;
        }

        public boolean eq(long l) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(l)) == 0;
        }

        public boolean lt(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigDecimal(integralDataTypeHolder)) < 0;
        }

        public boolean lt(long l) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(l)) < 0;
        }

        public boolean gt(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigDecimal(integralDataTypeHolder)) > 0;
        }

        public boolean gt(long l) {
            this.checkInitialized();
            return this.value.compareTo(BigDecimal.valueOf(l)) > 0;
        }

        public IntegralDataTypeHolder copy() {
            BigDecimalHolder bigDecimalHolder = new BigDecimalHolder();
            bigDecimalHolder.value = this.value;
            return bigDecimalHolder;
        }

        public Number makeValue() {
            this.checkInitialized();
            return this.value;
        }

        public Number makeValueThenIncrement() {
            Number number = this.makeValue();
            this.value = this.value.add(BigDecimal.ONE);
            return number;
        }

        public Number makeValueThenAdd(long l) {
            Number number = this.makeValue();
            this.value = this.value.add(BigDecimal.valueOf(l));
            return number;
        }

        public String toString() {
            return "BigDecimalHolder[" + this.value + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BigDecimalHolder bigDecimalHolder = (BigDecimalHolder)object;
            return this.value == null ? bigDecimalHolder.value == null : this.value.equals(bigDecimalHolder.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class BigIntegerHolder
    implements IntegralDataTypeHolder {
        private BigInteger value;

        public IntegralDataTypeHolder initialize(long l) {
            this.value = BigInteger.valueOf(l);
            return this;
        }

        public IntegralDataTypeHolder initialize(ResultSet resultSet, long l) throws SQLException {
            BigDecimal bigDecimal = resultSet.getBigDecimal(1);
            if (resultSet.wasNull()) {
                return this.initialize(l);
            }
            this.value = bigDecimal.setScale(0, 7).toBigInteger();
            return this;
        }

        public void bind(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setBigDecimal(n, new BigDecimal(this.value));
        }

        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            this.value = this.value.add(BigInteger.ONE);
            return this;
        }

        private void checkInitialized() {
            if (this.value == null) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        public IntegralDataTypeHolder add(long l) {
            this.checkInitialized();
            this.value = this.value.add(BigInteger.valueOf(l));
            return this;
        }

        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            this.value = this.value.subtract(BigInteger.ONE);
            return this;
        }

        public IntegralDataTypeHolder subtract(long l) {
            this.checkInitialized();
            this.value = this.value.subtract(BigInteger.valueOf(l));
            return this;
        }

        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            this.value = this.value.multiply(IdentifierGeneratorHelper.extractBigInteger(integralDataTypeHolder));
            return this;
        }

        public IntegralDataTypeHolder multiplyBy(long l) {
            this.checkInitialized();
            this.value = this.value.multiply(BigInteger.valueOf(l));
            return this;
        }

        public boolean eq(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigInteger(integralDataTypeHolder)) == 0;
        }

        public boolean eq(long l) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(l)) == 0;
        }

        public boolean lt(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigInteger(integralDataTypeHolder)) < 0;
        }

        public boolean lt(long l) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(l)) < 0;
        }

        public boolean gt(IntegralDataTypeHolder integralDataTypeHolder) {
            this.checkInitialized();
            return this.value.compareTo(IdentifierGeneratorHelper.extractBigInteger(integralDataTypeHolder)) > 0;
        }

        public boolean gt(long l) {
            this.checkInitialized();
            return this.value.compareTo(BigInteger.valueOf(l)) > 0;
        }

        public IntegralDataTypeHolder copy() {
            BigIntegerHolder bigIntegerHolder = new BigIntegerHolder();
            bigIntegerHolder.value = this.value;
            return bigIntegerHolder;
        }

        public Number makeValue() {
            this.checkInitialized();
            return this.value;
        }

        public Number makeValueThenIncrement() {
            Number number = this.makeValue();
            this.value = this.value.add(BigInteger.ONE);
            return number;
        }

        public Number makeValueThenAdd(long l) {
            Number number = this.makeValue();
            this.value = this.value.add(BigInteger.valueOf(l));
            return number;
        }

        public String toString() {
            return "BigIntegerHolder[" + this.value + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BigIntegerHolder bigIntegerHolder = (BigIntegerHolder)object;
            return this.value == null ? bigIntegerHolder.value == null : this.value.equals(bigIntegerHolder.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class BasicHolder
    implements IntegralDataTypeHolder {
        private final Class exactType;
        private long value = Long.MIN_VALUE;

        public BasicHolder(Class clazz) {
            this.exactType = clazz;
            if (clazz != Long.class && clazz != Integer.class && clazz != Short.class) {
                throw new IdentifierGenerationException("Invalid type for basic integral holder : " + clazz);
            }
        }

        public long getActualLongValue() {
            return this.value;
        }

        public IntegralDataTypeHolder initialize(long l) {
            this.value = l;
            return this;
        }

        public IntegralDataTypeHolder initialize(ResultSet resultSet, long l) throws SQLException {
            long l2 = resultSet.getLong(1);
            if (resultSet.wasNull()) {
                l2 = l;
            }
            return this.initialize(l2);
        }

        public void bind(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.value);
        }

        public IntegralDataTypeHolder increment() {
            this.checkInitialized();
            ++this.value;
            return this;
        }

        private void checkInitialized() {
            if (this.value == Long.MIN_VALUE) {
                throw new IdentifierGenerationException("integral holder was not initialized");
            }
        }

        public IntegralDataTypeHolder add(long l) {
            this.checkInitialized();
            this.value += l;
            return this;
        }

        public IntegralDataTypeHolder decrement() {
            this.checkInitialized();
            --this.value;
            return this;
        }

        public IntegralDataTypeHolder subtract(long l) {
            this.checkInitialized();
            this.value -= l;
            return this;
        }

        public IntegralDataTypeHolder multiplyBy(IntegralDataTypeHolder integralDataTypeHolder) {
            return this.multiplyBy(IdentifierGeneratorHelper.extractLong(integralDataTypeHolder));
        }

        public IntegralDataTypeHolder multiplyBy(long l) {
            this.checkInitialized();
            this.value *= l;
            return this;
        }

        public boolean eq(IntegralDataTypeHolder integralDataTypeHolder) {
            return this.eq(IdentifierGeneratorHelper.extractLong(integralDataTypeHolder));
        }

        public boolean eq(long l) {
            this.checkInitialized();
            return this.value == l;
        }

        public boolean lt(IntegralDataTypeHolder integralDataTypeHolder) {
            return this.lt(IdentifierGeneratorHelper.extractLong(integralDataTypeHolder));
        }

        public boolean lt(long l) {
            this.checkInitialized();
            return this.value < l;
        }

        public boolean gt(IntegralDataTypeHolder integralDataTypeHolder) {
            return this.gt(IdentifierGeneratorHelper.extractLong(integralDataTypeHolder));
        }

        public boolean gt(long l) {
            this.checkInitialized();
            return this.value > l;
        }

        public IntegralDataTypeHolder copy() {
            BasicHolder basicHolder = new BasicHolder(this.exactType);
            basicHolder.value = this.value;
            return basicHolder;
        }

        public Number makeValue() {
            this.checkInitialized();
            if (this.exactType == Long.class) {
                return this.value;
            }
            if (this.exactType == Integer.class) {
                return (int)this.value;
            }
            return (short)this.value;
        }

        public Number makeValueThenIncrement() {
            Number number = this.makeValue();
            ++this.value;
            return number;
        }

        public Number makeValueThenAdd(long l) {
            Number number = this.makeValue();
            this.value += l;
            return number;
        }

        public String toString() {
            return "BasicHolder[" + this.exactType.getName() + "[" + this.value + "]]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BasicHolder basicHolder = (BasicHolder)object;
            return this.value == basicHolder.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }
}

