/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, GUIDGenerator.class.getName());
    private static boolean warned = false;

    public GUIDGenerator() {
        if (!warned) {
            warned = true;
            LOG.deprecatedUuidGenerator(UUIDGenerator.class.getName(), UUIDGenerationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        String string = sessionImplementor.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string);
        try {
            String string2;
            ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
            try {
                resultSet.next();
                string2 = resultSet.getString(1);
            }
            finally {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
            }
            LOG.guidGenerated(string2);
            String string3 = string2;
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            return string3;
        }
        catch (Throwable throwable) {
            try {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not retrieve GUID", string);
            }
        }
    }
}

