/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.TableBasedDeleteHandlerImpl;
import org.hibernate.hql.spi.TableBasedUpdateHandlerImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractWork;
import org.hibernate.persister.entity.Queryable;
import org.jboss.logging.Logger;

public class TemporaryTableBulkIdStrategy
implements MultiTableBulkIdStrategy {
    public static final TemporaryTableBulkIdStrategy INSTANCE = new TemporaryTableBulkIdStrategy();
    public static final String SHORT_NAME = "temporary";
    private static final CoreMessageLogger log = Logger.getMessageLogger(CoreMessageLogger.class, TemporaryTableBulkIdStrategy.class.getName());
    private static SqlExceptionHelper.WarningHandler CREATION_WARNING_HANDLER = new SqlExceptionHelper.WarningHandlerLoggingSupport(){

        public boolean doProcess() {
            return log.isDebugEnabled();
        }

        public void prepare(SQLWarning sQLWarning) {
            log.warningsCreatingTempTable(sQLWarning);
        }

        protected void logWarning(String string, String string2) {
            log.debug(string);
            log.debug(string2);
        }
    };

    public void prepare(JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess, Mappings mappings, Mapping mapping, Map map) {
    }

    public void release(JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess) {
    }

    public MultiTableBulkIdStrategy.UpdateHandler buildUpdateHandler(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker) {
        return new TableBasedUpdateHandlerImpl(sessionFactoryImplementor, hqlSqlWalker){

            protected void prepareForUse(Queryable queryable, SessionImplementor sessionImplementor) {
                TemporaryTableBulkIdStrategy.this.createTempTable(queryable, sessionImplementor);
            }

            protected void releaseFromUse(Queryable queryable, SessionImplementor sessionImplementor) {
                TemporaryTableBulkIdStrategy.this.releaseTempTable(queryable, sessionImplementor);
            }
        };
    }

    public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker) {
        return new TableBasedDeleteHandlerImpl(sessionFactoryImplementor, hqlSqlWalker){

            protected void prepareForUse(Queryable queryable, SessionImplementor sessionImplementor) {
                TemporaryTableBulkIdStrategy.this.createTempTable(queryable, sessionImplementor);
            }

            protected void releaseFromUse(Queryable queryable, SessionImplementor sessionImplementor) {
                TemporaryTableBulkIdStrategy.this.releaseTempTable(queryable, sessionImplementor);
            }
        };
    }

    protected void createTempTable(Queryable queryable, SessionImplementor sessionImplementor) {
        TemporaryTableCreationWork temporaryTableCreationWork = new TemporaryTableCreationWork(queryable);
        if (this.shouldIsolateTemporaryTableDDL(sessionImplementor)) {
            sessionImplementor.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(temporaryTableCreationWork, this.shouldTransactIsolatedTemporaryTableDDL(sessionImplementor));
        } else {
            Connection connection = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getConnection();
            temporaryTableCreationWork.execute(connection);
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().afterStatementExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseTempTable(Queryable queryable, SessionImplementor sessionImplementor) {
        if (sessionImplementor.getFactory().getDialect().dropTemporaryTableAfterUse()) {
            TemporaryTableDropWork temporaryTableDropWork = new TemporaryTableDropWork(queryable, sessionImplementor);
            if (this.shouldIsolateTemporaryTableDDL(sessionImplementor)) {
                sessionImplementor.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(temporaryTableDropWork, this.shouldTransactIsolatedTemporaryTableDDL(sessionImplementor));
                return;
            }
            Connection connection = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getConnection();
            temporaryTableDropWork.execute(connection);
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().afterStatementExecution();
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            String string = "delete from " + queryable.getTemporaryIdTableName();
            preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, false);
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            try {
                log.unableToCleanupTemporaryIdTable(throwable);
                return;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
        try {
            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL(SessionImplementor sessionImplementor) {
        Boolean bl = sessionImplementor.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (bl != null) {
            return bl;
        }
        return sessionImplementor.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }

    protected boolean shouldTransactIsolatedTemporaryTableDDL(SessionImplementor sessionImplementor) {
        return false;
    }

    private static class TemporaryTableDropWork
    extends AbstractWork {
        private final Queryable persister;
        private final SessionImplementor session;

        private TemporaryTableDropWork(Queryable queryable, SessionImplementor sessionImplementor) {
            this.persister = queryable;
            this.session = sessionImplementor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) {
            String string = this.session.getFactory().getDialect().getDropTemporaryTableString() + ' ' + this.persister.getTemporaryIdTableName();
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(string);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception exception) {
                log.warn("unable to drop temporary id table after use [" + exception.getMessage() + "]");
            }
        }
    }

    private static class TemporaryTableCreationWork
    extends AbstractWork {
        private final Queryable persister;

        private TemporaryTableCreationWork(Queryable queryable) {
            this.persister = queryable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) {
            try {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(this.persister.getTemporaryIdTableDDL());
                    this.persister.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlExceptionHelper().handleAndClearWarnings(statement, CREATION_WARNING_HANDLER);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception exception) {
                log.debug("unable to create temporary id table [" + exception.getMessage() + "]");
            }
        }
    }
}

