/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AssignmentSpecification;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.hibernate.hql.spi.AbstractTableBasedBulkIdHandler;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Update;
import org.jboss.logging.Logger;

public class TableBasedUpdateHandlerImpl
extends AbstractTableBasedBulkIdHandler
implements MultiTableBulkIdStrategy.UpdateHandler {
    private static final Logger log = Logger.getLogger(TableBasedUpdateHandlerImpl.class);
    private final Queryable targetedPersister;
    private final String idInsertSelect;
    private final List<ParameterSpecification> idSelectParameterSpecifications;
    private final String[] updates;
    private final ParameterSpecification[][] assignmentParameterSpecifications;

    public TableBasedUpdateHandlerImpl(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker) {
        this(sessionFactoryImplementor, hqlSqlWalker, null, null);
    }

    public TableBasedUpdateHandlerImpl(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker, String string, String string2) {
        super(sessionFactoryImplementor, hqlSqlWalker, string, string2);
        UpdateStatement updateStatement = (UpdateStatement)hqlSqlWalker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        this.targetedPersister = fromElement.getQueryable();
        String string3 = fromElement.getTableAlias();
        AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(updateStatement.getWhereClause());
        this.idSelectParameterSpecifications = processedWhereClause.getIdSelectParameterSpecifications();
        this.idInsertSelect = this.generateIdInsertSelect(this.targetedPersister, string3, processedWhereClause);
        log.tracev("Generated ID-INSERT-SELECT SQL (multi-table update) : {0}", (Object)this.idInsertSelect);
        String[] stringArray = this.targetedPersister.getConstraintOrderedTableNameClosure();
        String[][] stringArray2 = this.targetedPersister.getContraintOrderedTableKeyColumnClosure();
        String string4 = this.generateIdSubselect(this.targetedPersister);
        this.updates = new String[stringArray.length];
        this.assignmentParameterSpecifications = new ParameterSpecification[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
            Update update = new Update(this.factory().getDialect()).setTableName(stringArray[i]).setWhere("(" + StringHelper.join(", ", stringArray2[i]) + ") IN (" + string4 + ")");
            if (this.factory().getSettings().isCommentsEnabled()) {
                update.setComment("bulk update");
            }
            ArrayList arrayList2 = hqlSqlWalker.getAssignmentSpecifications();
            for (AssignmentSpecification assignmentSpecification : arrayList2) {
                if (!assignmentSpecification.affectsTable(stringArray[i])) continue;
                bl = true;
                update.appendAssignmentFragment(assignmentSpecification.getSqlAssignmentFragment());
                if (assignmentSpecification.getParameters() == null) continue;
                for (int j = 0; j < assignmentSpecification.getParameters().length; ++j) {
                    arrayList.add(assignmentSpecification.getParameters()[j]);
                }
            }
            if (!bl) continue;
            this.updates[i] = update.toStatementString();
            this.assignmentParameterSpecifications[i] = arrayList.toArray(new ParameterSpecification[arrayList.size()]);
        }
    }

    public Queryable getTargetedQueryable() {
        return this.targetedPersister;
    }

    public String[] getSqlStatements() {
        return this.updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        this.prepareForUse(this.targetedPersister, sessionImplementor);
        try {
            int n;
            PreparedStatement preparedStatement = null;
            int n2 = 0;
            try {
                try {
                    preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    n = 1;
                    n += this.handlePrependedParametersOnIdSelection(preparedStatement, sessionImplementor, n);
                    for (ParameterSpecification parameterSpecification : this.idSelectParameterSpecifications) {
                        n += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n);
                    }
                    n2 = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
                }
                finally {
                    if (preparedStatement != null) {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw this.convert(sQLException, "could not insert/select ids for bulk update", this.idInsertSelect);
            }
            for (n = 0; n < this.updates.length; ++n) {
                if (this.updates[n] == null) continue;
                try {
                    try {
                        preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.updates[n], false);
                        if (this.assignmentParameterSpecifications[n] != null) {
                            int n3 = 1;
                            for (int i = 0; i < this.assignmentParameterSpecifications[n].length; ++i) {
                                n3 += this.assignmentParameterSpecifications[n][i].bind(preparedStatement, queryParameters, sessionImplementor, n3);
                            }
                            this.handleAddedParametersOnUpdate(preparedStatement, sessionImplementor, n3);
                        }
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
                        continue;
                    }
                    finally {
                        if (preparedStatement != null) {
                            sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw this.convert(sQLException, "error performing bulk update", this.updates[n]);
                }
            }
            n = n2;
            return n;
        }
        finally {
            this.releaseFromUse(this.targetedPersister, sessionImplementor);
        }
    }

    protected int handlePrependedParametersOnIdSelection(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
        return 0;
    }

    protected void handleAddedParametersOnUpdate(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
    }
}

