/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.spi.AbstractTableBasedBulkIdHandler;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class TableBasedDeleteHandlerImpl
extends AbstractTableBasedBulkIdHandler
implements MultiTableBulkIdStrategy.DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandlerImpl.class);
    private final Queryable targetedPersister;
    private final String idInsertSelect;
    private final List<ParameterSpecification> idSelectParameterSpecifications;
    private final List<String> deletes;

    public TableBasedDeleteHandlerImpl(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker) {
        this(sessionFactoryImplementor, hqlSqlWalker, null, null);
    }

    public TableBasedDeleteHandlerImpl(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker, String string, String string2) {
        super(sessionFactoryImplementor, hqlSqlWalker, string, string2);
        DeleteStatement deleteStatement = (DeleteStatement)hqlSqlWalker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        this.targetedPersister = fromElement.getQueryable();
        String string3 = fromElement.getTableAlias();
        AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(deleteStatement.getWhereClause());
        this.idSelectParameterSpecifications = processedWhereClause.getIdSelectParameterSpecifications();
        this.idInsertSelect = this.generateIdInsertSelect(this.targetedPersister, string3, processedWhereClause);
        log.tracev("Generated ID-INSERT-SELECT SQL (multi-table delete) : {0}", (Object)this.idInsertSelect);
        String string4 = this.generateIdSubselect(this.targetedPersister);
        this.deletes = new ArrayList<String>();
        for (Type type : this.targetedPersister.getPropertyTypes()) {
            CollectionType collectionType;
            AbstractCollectionPersister abstractCollectionPersister;
            if (!type.isCollectionType() || !(abstractCollectionPersister = (AbstractCollectionPersister)sessionFactoryImplementor.getCollectionPersister((collectionType = (CollectionType)type).getRole())).isManyToMany()) continue;
            this.deletes.add(this.generateDelete(abstractCollectionPersister.getTableName(), abstractCollectionPersister.getKeyColumnNames(), string4, "bulk delete - m2m join table cleanup"));
        }
        Object[] objectArray = this.targetedPersister.getConstraintOrderedTableNameClosure();
        String[][] stringArray = this.targetedPersister.getContraintOrderedTableKeyColumnClosure();
        for (int i = 0; i < objectArray.length; ++i) {
            this.deletes.add(this.generateDelete((String)objectArray[i], stringArray[i], string4, "bulk delete"));
        }
    }

    private String generateDelete(String string, String[] stringArray, String string2, String string3) {
        Delete delete = new Delete().setTableName(string).setWhere("(" + StringHelper.join(", ", stringArray) + ") IN (" + string2 + ")");
        if (this.factory().getSettings().isCommentsEnabled()) {
            delete.setComment(string3);
        }
        return delete.toStatementString();
    }

    public Queryable getTargetedQueryable() {
        return this.targetedPersister;
    }

    public String[] getSqlStatements() {
        return this.deletes.toArray(new String[this.deletes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(SessionImplementor sessionImplementor, QueryParameters queryParameters) {
        this.prepareForUse(this.targetedPersister, sessionImplementor);
        try {
            PreparedStatement preparedStatement = null;
            int n = 0;
            try {
                try {
                    preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    int n2 = 1;
                    n2 += this.handlePrependedParametersOnIdSelection(preparedStatement, sessionImplementor, n2);
                    for (ParameterSpecification parameterSpecification : this.idSelectParameterSpecifications) {
                        n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n2);
                    }
                    n = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
                }
                finally {
                    if (preparedStatement != null) {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw this.convert(sQLException, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (String string : this.deletes) {
                try {
                    try {
                        preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, false);
                        this.handleAddedParametersOnDelete(preparedStatement, sessionImplementor);
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                }
                catch (SQLException sQLException) {
                    throw this.convert(sQLException, "error performing bulk delete", string);
                }
            }
            int n3 = n;
            return n3;
        }
        finally {
            this.releaseFromUse(this.targetedPersister, sessionImplementor);
        }
    }

    protected int handlePrependedParametersOnIdSelection(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
        return 0;
    }

    protected void handleAddedParametersOnDelete(PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws SQLException {
    }
}

