/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.TableBasedDeleteHandlerImpl;
import org.hibernate.hql.spi.TableBasedUpdateHandlerImpl;
import org.hibernate.internal.AbstractSessionImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.SelectValues;
import org.hibernate.type.UUIDCharType;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentTableBulkIdStrategy
implements MultiTableBulkIdStrategy {
    private static final CoreMessageLogger log = Logger.getMessageLogger(CoreMessageLogger.class, PersistentTableBulkIdStrategy.class.getName());
    public static final String SHORT_NAME = "persistent";
    public static final String CLEAN_UP_ID_TABLES = "hibernate.hql.bulk_id_strategy.persistent.clean_up";
    public static final String SCHEMA = "hibernate.hql.bulk_id_strategy.persistent.schema";
    public static final String CATALOG = "hibernate.hql.bulk_id_strategy.persistent.catalog";
    private String catalog;
    private String schema;
    private boolean cleanUpTables;
    private List<String> tableCleanUpDdl;

    @Override
    public void prepare(JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess, Mappings mappings, Mapping mapping, Map map) {
        this.catalog = ConfigurationHelper.getString(CATALOG, map, ConfigurationHelper.getString("hibernate.default_catalog", map));
        this.schema = ConfigurationHelper.getString(SCHEMA, map, ConfigurationHelper.getString("hibernate.default_schema", map));
        this.cleanUpTables = ConfigurationHelper.getBoolean(CLEAN_UP_ID_TABLES, map, false);
        Iterator<PersistentClass> iterator = mappings.iterateClasses();
        ArrayList<Table> arrayList = new ArrayList<Table>();
        while (iterator.hasNext()) {
            PersistentClass persistentClass = iterator.next();
            Table table = this.generateIdTableDefinition(persistentClass);
            arrayList.add(table);
        }
        this.exportTableDefinitions(arrayList, jdbcServices, jdbcConnectionAccess, mappings, mapping);
    }

    protected Table generateIdTableDefinition(PersistentClass persistentClass) {
        Column column;
        Table table = new Table(persistentClass.getTemporaryIdTableName());
        if (this.catalog != null) {
            table.setCatalog(this.catalog);
        }
        if (this.schema != null) {
            table.setSchema(this.schema);
        }
        Iterator iterator = persistentClass.getTable().getPrimaryKey().getColumnIterator();
        while (iterator.hasNext()) {
            column = (Column)iterator.next();
            table.addColumn(column.clone());
        }
        column = new Column("hib_sess_id");
        column.setSqlType("CHAR(36)");
        column.setComment("Used to hold the Hibernate Session identifier");
        table.addColumn(column);
        table.setComment("Used to hold id values for the " + persistentClass.getEntityName() + " class");
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportTableDefinitions(List<Table> list, JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess, Mappings mappings, Mapping mapping) {
        try {
            Connection connection;
            try {
                connection = jdbcConnectionAccess.obtainConnection();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                log.debug("Unable to obtain JDBC connection; assuming ID tables already exist or wont be needed");
                return;
            }
            try {
                Statement statement = connection.createStatement();
                for (Table table : list) {
                    if (this.cleanUpTables) {
                        if (this.tableCleanUpDdl == null) {
                            this.tableCleanUpDdl = new ArrayList<String>();
                        }
                        this.tableCleanUpDdl.add(table.sqlDropString(jdbcServices.getDialect(), null, null));
                    }
                    try {
                        String string = table.sqlCreateString(jdbcServices.getDialect(), mapping, null, null);
                        jdbcServices.getSqlStatementLogger().logStatement(string);
                        statement.execute(string);
                    }
                    catch (SQLException sQLException) {
                        log.debugf("Error attempting to export id-table [%s] : %s", (Object)table.getName(), (Object)sQLException.getMessage());
                    }
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                log.error("Unable to use JDBC Connection to create Statement", sQLException);
            }
            finally {
                try {
                    jdbcConnectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sQLException) {
            log.error("Unable obtain JDBC Connection", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess) {
        if (!this.cleanUpTables || this.tableCleanUpDdl == null) {
            return;
        }
        try {
            Connection connection = jdbcConnectionAccess.obtainConnection();
            try {
                Statement statement = connection.createStatement();
                for (String string : this.tableCleanUpDdl) {
                    try {
                        jdbcServices.getSqlStatementLogger().logStatement(string);
                        statement.execute(string);
                    }
                    catch (SQLException sQLException) {
                        log.debugf("Error attempting to cleanup id-table : [%s]", (Object)sQLException.getMessage());
                    }
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                log.error("Unable to use JDBC Connection to create Statement", sQLException);
            }
            finally {
                try {
                    jdbcConnectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sQLException) {
            log.error("Unable obtain JDBC Connection", sQLException);
        }
    }

    @Override
    public MultiTableBulkIdStrategy.UpdateHandler buildUpdateHandler(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker) {
        return new TableBasedUpdateHandlerImpl(sessionFactoryImplementor, hqlSqlWalker, this.catalog, this.schema){

            protected void addAnyExtraIdSelectValues(SelectValues selectValues) {
                selectValues.addParameter(1, 36);
            }

            protected String generateIdSubselect(Queryable queryable) {
                return super.generateIdSubselect(queryable) + " where hib_sess_id=?";
            }

            protected int handlePrependedParametersOnIdSelection(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
                PersistentTableBulkIdStrategy.this.bindSessionIdentifier(preparedStatement, sessionImplementor, n);
                return 1;
            }

            protected void handleAddedParametersOnUpdate(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
                PersistentTableBulkIdStrategy.this.bindSessionIdentifier(preparedStatement, sessionImplementor, n);
            }

            protected void releaseFromUse(Queryable queryable, SessionImplementor sessionImplementor) {
                PersistentTableBulkIdStrategy.this.cleanUpRows(this.determineIdTableName(queryable), sessionImplementor);
            }
        };
    }

    private void bindSessionIdentifier(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
        if (!AbstractSessionImpl.class.isInstance(sessionImplementor)) {
            throw new HibernateException("Only available on SessionImpl instances");
        }
        UUIDCharType.INSTANCE.set(preparedStatement, ((AbstractSessionImpl)sessionImplementor).getSessionIdentifier(), n, sessionImplementor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpRows(String string, SessionImplementor sessionImplementor) {
        String string2 = "delete from " + string + " where hib_sess_id=?";
        try {
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string2, false);
                this.bindSessionIdentifier(preparedStatement, sessionImplementor, 1);
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.convert(sessionImplementor.getFactory(), sQLException, "Unable to clean up id table [" + string + "]", string2);
        }
    }

    protected JDBCException convert(SessionFactoryImplementor sessionFactoryImplementor, SQLException sQLException, String string, String string2) {
        throw sessionFactoryImplementor.getSQLExceptionHelper().convert(sQLException, string, string2);
    }

    @Override
    public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker) {
        return new TableBasedDeleteHandlerImpl(sessionFactoryImplementor, hqlSqlWalker, this.catalog, this.schema){

            protected void addAnyExtraIdSelectValues(SelectValues selectValues) {
                selectValues.addParameter(1, 36);
            }

            protected String generateIdSubselect(Queryable queryable) {
                return super.generateIdSubselect(queryable) + " where hib_sess_id=?";
            }

            protected int handlePrependedParametersOnIdSelection(PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n) throws SQLException {
                PersistentTableBulkIdStrategy.this.bindSessionIdentifier(preparedStatement, sessionImplementor, n);
                return 1;
            }

            protected void handleAddedParametersOnDelete(PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws SQLException {
                PersistentTableBulkIdStrategy.this.bindSessionIdentifier(preparedStatement, sessionImplementor, 1);
            }

            protected void releaseFromUse(Queryable queryable, SessionImplementor sessionImplementor) {
                PersistentTableBulkIdStrategy.this.cleanUpRows(this.determineIdTableName(queryable), sessionImplementor);
            }
        };
    }
}

