/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.SqlGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectValues;

public class AbstractTableBasedBulkIdHandler {
    private final SessionFactoryImplementor sessionFactory;
    private final HqlSqlWalker walker;
    private final String catalog;
    private final String schema;

    public AbstractTableBasedBulkIdHandler(SessionFactoryImplementor sessionFactoryImplementor, HqlSqlWalker hqlSqlWalker, String string, String string2) {
        this.sessionFactory = sessionFactoryImplementor;
        this.walker = hqlSqlWalker;
        this.catalog = string;
        this.schema = string2;
    }

    protected SessionFactoryImplementor factory() {
        return this.sessionFactory;
    }

    protected HqlSqlWalker walker() {
        return this.walker;
    }

    protected JDBCException convert(SQLException sQLException, String string, String string2) {
        throw this.factory().getSQLExceptionHelper().convert(sQLException, string, string2);
    }

    protected ProcessedWhereClause processWhereClause(AST aST) {
        if (aST.getNumberOfChildren() != 0) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.sessionFactory);
                sqlGenerator.whereClause(aST);
                String string = sqlGenerator.getSQL().substring(7);
                List<ParameterSpecification> list = sqlGenerator.getCollectedParameters();
                return new ProcessedWhereClause(string, list);
            }
            catch (RecognitionException recognitionException) {
                throw new HibernateException("Unable to generate id select for DML operation", recognitionException);
            }
        }
        return ProcessedWhereClause.NO_WHERE_CLAUSE;
    }

    protected String generateIdInsertSelect(Queryable queryable, String string, ProcessedWhereClause processedWhereClause) {
        Select select = new Select(this.sessionFactory.getDialect());
        SelectValues selectValues = new SelectValues(this.sessionFactory.getDialect()).addColumns(string, queryable.getIdentifierColumnNames(), queryable.getIdentifierColumnNames());
        this.addAnyExtraIdSelectValues(selectValues);
        select.setSelectClause(selectValues.render());
        String string2 = queryable.getTableName();
        String string3 = queryable.fromJoinFragment(string, true, false);
        String string4 = queryable.whereJoinFragment(string, true, false);
        select.setFromClause(string2 + ' ' + string + string3);
        if (string4 == null) {
            string4 = "";
        } else if ((string4 = string4.trim()).startsWith("and")) {
            string4 = string4.substring(4);
        }
        if (processedWhereClause.getUserWhereClauseFragment().length() > 0 && string4.length() > 0) {
            string4 = string4 + " and ";
        }
        select.setWhereClause(string4 + processedWhereClause.getUserWhereClauseFragment());
        InsertSelect insertSelect = new InsertSelect(this.sessionFactory.getDialect());
        if (this.sessionFactory.getSettings().isCommentsEnabled()) {
            insertSelect.setComment("insert-select for " + queryable.getEntityName() + " ids");
        }
        insertSelect.setTableName(this.determineIdTableName(queryable));
        insertSelect.setSelect(select);
        return insertSelect.toStatementString();
    }

    protected void addAnyExtraIdSelectValues(SelectValues selectValues) {
    }

    protected String determineIdTableName(Queryable queryable) {
        return Table.qualify(this.catalog, this.schema, queryable.getTemporaryIdTableName());
    }

    protected String generateIdSubselect(Queryable queryable) {
        return "select " + StringHelper.join(", ", queryable.getIdentifierColumnNames()) + " from " + this.determineIdTableName(queryable);
    }

    protected void prepareForUse(Queryable queryable, SessionImplementor sessionImplementor) {
    }

    protected void releaseFromUse(Queryable queryable, SessionImplementor sessionImplementor) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ProcessedWhereClause {
        public static final ProcessedWhereClause NO_WHERE_CLAUSE = new ProcessedWhereClause();
        private final String userWhereClauseFragment;
        private final List<ParameterSpecification> idSelectParameterSpecifications;

        private ProcessedWhereClause() {
            this("", Collections.emptyList());
        }

        public ProcessedWhereClause(String string, List<ParameterSpecification> list) {
            this.userWhereClauseFragment = string;
            this.idSelectParameterSpecifications = list;
        }

        public String getUserWhereClauseFragment() {
            return this.userWhereClauseFragment;
        }

        public List<ParameterSpecification> getIdSelectParameterSpecifications() {
            return this.idSelectParameterSpecifications;
        }
    }
}

