/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.classic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.hql.internal.classic.Parser;
import org.hibernate.hql.internal.classic.PathExpressionParser;
import org.hibernate.hql.internal.classic.QueryTranslatorImpl;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;

public class WhereParser
implements Parser {
    private final PathExpressionParser pathExpressionParser = new PathExpressionParser();
    private static final Set EXPRESSION_TERMINATORS = new HashSet();
    private static final Set EXPRESSION_OPENERS = new HashSet();
    private static final Set BOOLEAN_OPERATORS = new HashSet();
    private static final Map NEGATIONS = new HashMap();
    private boolean betweenSpecialCase;
    private boolean negated;
    private boolean inSubselect;
    private int bracketsSinceSelect;
    private StringBuilder subselect;
    private boolean expectingPathContinuation;
    private int expectingIndex;
    private LinkedList<Boolean> nots;
    private LinkedList joins;
    private LinkedList<Boolean> booleanTests;

    public WhereParser() {
        this.pathExpressionParser.setUseThetaStyleJoin(true);
        this.betweenSpecialCase = false;
        this.negated = false;
        this.inSubselect = false;
        this.bracketsSinceSelect = 0;
        this.expectingPathContinuation = false;
        this.expectingIndex = 0;
        this.nots = new LinkedList();
        this.joins = new LinkedList();
        this.booleanTests = new LinkedList();
    }

    private String getElementName(PathExpressionParser.CollectionElement collectionElement, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String string;
        if (collectionElement.isOneToMany) {
            string = collectionElement.alias;
        } else {
            Type type = collectionElement.elementType;
            if (type.isEntityType()) {
                String string2 = ((EntityType)type).getAssociatedEntityName();
                string = this.pathExpressionParser.continueFromManyToMany(string2, collectionElement.elementColumns, queryTranslatorImpl);
            } else {
                throw new QueryException("illegally dereferenced collection element");
            }
        }
        return string;
    }

    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        boolean bl;
        String string2 = string.toLowerCase();
        if (string.equals("[") && !this.expectingPathContinuation) {
            this.expectingPathContinuation = false;
            if (this.expectingIndex == 0) {
                throw new QueryException("unexpected [");
            }
            return;
        }
        if (string.equals("]")) {
            --this.expectingIndex;
            this.expectingPathContinuation = true;
            return;
        }
        if (this.expectingPathContinuation && (bl = this.continuePathExpression(string, queryTranslatorImpl))) {
            return;
        }
        if (!this.inSubselect && (string2.equals("select") || string2.equals("from"))) {
            this.inSubselect = true;
            this.subselect = new StringBuilder(20);
        }
        if (this.inSubselect && string.equals(")")) {
            --this.bracketsSinceSelect;
            if (this.bracketsSinceSelect == -1) {
                QueryTranslatorImpl queryTranslatorImpl2 = new QueryTranslatorImpl(this.subselect.toString(), queryTranslatorImpl.getEnabledFilters(), queryTranslatorImpl.getFactory());
                try {
                    queryTranslatorImpl2.compile(queryTranslatorImpl);
                }
                catch (MappingException mappingException) {
                    throw new QueryException("MappingException occurred compiling subquery", mappingException);
                }
                this.appendToken(queryTranslatorImpl, queryTranslatorImpl2.getSQLString());
                this.inSubselect = false;
                this.bracketsSinceSelect = 0;
            }
        }
        if (this.inSubselect) {
            if (string.equals("(")) {
                ++this.bracketsSinceSelect;
            }
            this.subselect.append(string).append(' ');
            return;
        }
        this.specialCasesBefore(string2);
        if (!this.betweenSpecialCase && EXPRESSION_TERMINATORS.contains(string2)) {
            this.closeExpression(queryTranslatorImpl, string2);
        }
        if (BOOLEAN_OPERATORS.contains(string2)) {
            this.booleanTests.removeLast();
            this.booleanTests.addLast(Boolean.TRUE);
        }
        if (string2.equals("not")) {
            this.nots.addLast(this.nots.removeLast() == false);
            this.negated = !this.negated;
            return;
        }
        this.doToken(string, queryTranslatorImpl);
        if (!this.betweenSpecialCase && EXPRESSION_OPENERS.contains(string2)) {
            this.openExpression(queryTranslatorImpl, string2);
        }
        this.specialCasesAfter(string2);
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.token("(", queryTranslatorImpl);
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        if (this.expectingPathContinuation) {
            this.expectingPathContinuation = false;
            PathExpressionParser.CollectionElement collectionElement = this.pathExpressionParser.lastCollectionElement();
            if (collectionElement.elementColumns.length != 1) {
                throw new QueryException("path expression ended in composite collection element");
            }
            this.appendToken(queryTranslatorImpl, collectionElement.elementColumns[0]);
            this.addToCurrentJoin(collectionElement);
        }
        this.token(")", queryTranslatorImpl);
    }

    private void closeExpression(QueryTranslatorImpl queryTranslatorImpl, String string) {
        if (this.booleanTests.removeLast().booleanValue()) {
            if (this.booleanTests.size() > 0) {
                this.booleanTests.removeLast();
                this.booleanTests.addLast(Boolean.TRUE);
            }
            this.appendToken(queryTranslatorImpl, this.joins.removeLast().toString());
        } else {
            StringBuilder stringBuilder = (StringBuilder)this.joins.removeLast();
            ((StringBuilder)this.joins.getLast()).append(stringBuilder.toString());
        }
        if (this.nots.removeLast().booleanValue()) {
            boolean bl = this.negated = !this.negated;
        }
        if (!")".equals(string)) {
            this.appendToken(queryTranslatorImpl, ")");
        }
    }

    private void openExpression(QueryTranslatorImpl queryTranslatorImpl, String string) {
        this.nots.addLast(Boolean.FALSE);
        this.booleanTests.addLast(Boolean.FALSE);
        this.joins.addLast(new StringBuilder());
        if (!"(".equals(string)) {
            this.appendToken(queryTranslatorImpl, "(");
        }
    }

    private void preprocess(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String[] stringArray = StringHelper.split(".", string, true);
        if (stringArray.length > 5 && ("elements".equals(stringArray[stringArray.length - 1]) || "indices".equals(stringArray[stringArray.length - 1]))) {
            this.pathExpressionParser.start(queryTranslatorImpl);
            for (int i = 0; i < stringArray.length - 3; ++i) {
                this.pathExpressionParser.token(stringArray[i], queryTranslatorImpl);
            }
            this.pathExpressionParser.token(null, queryTranslatorImpl);
            this.pathExpressionParser.end(queryTranslatorImpl);
            this.addJoin(this.pathExpressionParser.getWhereJoin(), queryTranslatorImpl);
            this.pathExpressionParser.ignoreInitialJoin();
        }
    }

    private void doPathExpression(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.preprocess(string, queryTranslatorImpl);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        this.pathExpressionParser.start(queryTranslatorImpl);
        while (stringTokenizer.hasMoreTokens()) {
            this.pathExpressionParser.token(stringTokenizer.nextToken(), queryTranslatorImpl);
        }
        this.pathExpressionParser.end(queryTranslatorImpl);
        if (this.pathExpressionParser.isCollectionValued()) {
            this.openExpression(queryTranslatorImpl, "");
            this.appendToken(queryTranslatorImpl, this.pathExpressionParser.getCollectionSubquery(queryTranslatorImpl.getEnabledFilters()));
            this.closeExpression(queryTranslatorImpl, "");
            queryTranslatorImpl.addQuerySpaces(queryTranslatorImpl.getCollectionPersister(this.pathExpressionParser.getCollectionRole()).getCollectionSpaces());
        } else if (this.pathExpressionParser.isExpectingCollectionIndex()) {
            ++this.expectingIndex;
        } else {
            this.addJoin(this.pathExpressionParser.getWhereJoin(), queryTranslatorImpl);
            this.appendToken(queryTranslatorImpl, this.pathExpressionParser.getWhereColumn());
        }
    }

    private void addJoin(JoinSequence joinSequence, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        queryTranslatorImpl.addFromJoinOnly(this.pathExpressionParser.getName(), joinSequence);
        try {
            this.addToCurrentJoin(joinSequence.toJoinFragment(queryTranslatorImpl.getEnabledFilters(), true).toWhereFragmentString());
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
    }

    private void doToken(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        if (queryTranslatorImpl.isName(StringHelper.root(string))) {
            this.doPathExpression(queryTranslatorImpl.unalias(string), queryTranslatorImpl);
        } else if (string.startsWith(":")) {
            queryTranslatorImpl.addNamedParameter(string.substring(1));
            this.appendToken(queryTranslatorImpl, "?");
        } else {
            Queryable queryable = queryTranslatorImpl.getEntityPersisterUsingImports(string);
            if (queryable != null) {
                String string2 = queryable.getDiscriminatorSQLValue();
                if ("null".equals(string2) || "not null".equals(string2)) {
                    throw new QueryException("subclass test not allowed for null or not null discriminator");
                }
                this.appendToken(queryTranslatorImpl, string2);
            } else {
                String string3;
                Object object;
                if (string.indexOf(46) > -1 && (object = ReflectHelper.getConstantValue(string)) != null) {
                    Type type;
                    try {
                        type = queryTranslatorImpl.getFactory().getTypeResolver().heuristicType(object.getClass().getName());
                    }
                    catch (MappingException mappingException) {
                        throw new QueryException(mappingException);
                    }
                    if (type == null) {
                        throw new QueryException("Could not determine type of: " + string);
                    }
                    try {
                        this.appendToken(queryTranslatorImpl, ((LiteralType)((Object)type)).objectToSQLString(object, queryTranslatorImpl.getFactory().getDialect()));
                    }
                    catch (Exception exception) {
                        throw new QueryException("Could not format constant value to SQL literal: " + string, exception);
                    }
                }
                String string4 = string3 = this.negated ? (String)NEGATIONS.get(string.toLowerCase()) : null;
                if (!(string3 == null || this.betweenSpecialCase && "or".equals(string3))) {
                    this.appendToken(queryTranslatorImpl, string3);
                } else {
                    this.appendToken(queryTranslatorImpl, string);
                }
            }
        }
    }

    private void addToCurrentJoin(String string) {
        ((StringBuilder)this.joins.getLast()).append(string);
    }

    private void addToCurrentJoin(PathExpressionParser.CollectionElement collectionElement) throws QueryException {
        try {
            this.addToCurrentJoin(collectionElement.joinSequence.toJoinFragment().toWhereFragmentString() + collectionElement.indexValue.toString());
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
    }

    private void specialCasesBefore(String string) {
        if (string.equals("between") || string.equals("not between")) {
            this.betweenSpecialCase = true;
        }
    }

    private void specialCasesAfter(String string) {
        if (this.betweenSpecialCase && string.equals("and")) {
            this.betweenSpecialCase = false;
        }
    }

    void appendToken(QueryTranslatorImpl queryTranslatorImpl, String string) {
        if (this.expectingIndex > 0) {
            this.pathExpressionParser.setLastCollectionElementIndexValue(string);
        } else {
            queryTranslatorImpl.appendWhereToken(string);
        }
    }

    private boolean continuePathExpression(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.expectingPathContinuation = false;
        PathExpressionParser.CollectionElement collectionElement = this.pathExpressionParser.lastCollectionElement();
        if (string.startsWith(".")) {
            this.doPathExpression(this.getElementName(collectionElement, queryTranslatorImpl) + string, queryTranslatorImpl);
            this.addToCurrentJoin(collectionElement);
            return true;
        }
        if (collectionElement.elementColumns.length != 1) {
            throw new QueryException("path expression ended in composite collection element");
        }
        this.appendToken(queryTranslatorImpl, collectionElement.elementColumns[0]);
        this.addToCurrentJoin(collectionElement);
        return false;
    }

    static {
        EXPRESSION_TERMINATORS.add("and");
        EXPRESSION_TERMINATORS.add("or");
        EXPRESSION_TERMINATORS.add(")");
        EXPRESSION_OPENERS.add("and");
        EXPRESSION_OPENERS.add("or");
        EXPRESSION_OPENERS.add("(");
        BOOLEAN_OPERATORS.add("<");
        BOOLEAN_OPERATORS.add("=");
        BOOLEAN_OPERATORS.add(">");
        BOOLEAN_OPERATORS.add("#");
        BOOLEAN_OPERATORS.add("~");
        BOOLEAN_OPERATORS.add("like");
        BOOLEAN_OPERATORS.add("ilike");
        BOOLEAN_OPERATORS.add("regexp");
        BOOLEAN_OPERATORS.add("rlike");
        BOOLEAN_OPERATORS.add("is");
        BOOLEAN_OPERATORS.add("in");
        BOOLEAN_OPERATORS.add("any");
        BOOLEAN_OPERATORS.add("some");
        BOOLEAN_OPERATORS.add("all");
        BOOLEAN_OPERATORS.add("exists");
        BOOLEAN_OPERATORS.add("between");
        BOOLEAN_OPERATORS.add("<=");
        BOOLEAN_OPERATORS.add(">=");
        BOOLEAN_OPERATORS.add("=>");
        BOOLEAN_OPERATORS.add("=<");
        BOOLEAN_OPERATORS.add("!=");
        BOOLEAN_OPERATORS.add("<>");
        BOOLEAN_OPERATORS.add("!#");
        BOOLEAN_OPERATORS.add("!~");
        BOOLEAN_OPERATORS.add("!<");
        BOOLEAN_OPERATORS.add("!>");
        BOOLEAN_OPERATORS.add("is not");
        BOOLEAN_OPERATORS.add("not like");
        BOOLEAN_OPERATORS.add("not ilike");
        BOOLEAN_OPERATORS.add("not regexp");
        BOOLEAN_OPERATORS.add("not rlike");
        BOOLEAN_OPERATORS.add("not in");
        BOOLEAN_OPERATORS.add("not between");
        BOOLEAN_OPERATORS.add("not exists");
        NEGATIONS.put("and", "or");
        NEGATIONS.put("or", "and");
        NEGATIONS.put("<", ">=");
        NEGATIONS.put("=", "<>");
        NEGATIONS.put(">", "<=");
        NEGATIONS.put("#", "!#");
        NEGATIONS.put("~", "!~");
        NEGATIONS.put("like", "not like");
        NEGATIONS.put("ilike", "not ilike");
        NEGATIONS.put("regexp", "not regexp");
        NEGATIONS.put("rlike", "not rlike");
        NEGATIONS.put("is", "is not");
        NEGATIONS.put("in", "not in");
        NEGATIONS.put("exists", "not exists");
        NEGATIONS.put("between", "not between");
        NEGATIONS.put("<=", ">");
        NEGATIONS.put(">=", "<");
        NEGATIONS.put("=>", "<");
        NEGATIONS.put("=<", ">");
        NEGATIONS.put("!=", "=");
        NEGATIONS.put("<>", "=");
        NEGATIONS.put("!#", "#");
        NEGATIONS.put("!~", "~");
        NEGATIONS.put("!<", "<");
        NEGATIONS.put("!>", ">");
        NEGATIONS.put("is not", "is");
        NEGATIONS.put("not like", "like");
        NEGATIONS.put("not ilike", "ilike");
        NEGATIONS.put("not regexp", "regexp");
        NEGATIONS.put("not rlike", "rlike");
        NEGATIONS.put("not in", "in");
        NEGATIONS.put("not between", "between");
        NEGATIONS.put("not exists", "exists");
    }
}

