/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.classic;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.hql.internal.QuerySplitter;
import org.hibernate.hql.internal.classic.Parser;
import org.hibernate.hql.internal.classic.ParserHelper;
import org.hibernate.hql.internal.classic.PathExpressionParser;
import org.hibernate.hql.internal.classic.QueryTranslatorImpl;
import org.hibernate.hql.internal.classic.SelectPathExpressionParser;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class SelectParser
implements Parser {
    private static final Set COUNT_MODIFIERS = new HashSet();
    private LinkedList aggregateFuncTokenList = new LinkedList();
    private boolean ready;
    private boolean aggregate;
    private boolean first;
    private boolean afterNew;
    private boolean insideNew;
    private boolean aggregateAddSelectScalar;
    private Class holderClass;
    private final SelectPathExpressionParser pathExpressionParser = new SelectPathExpressionParser();
    private final PathExpressionParser aggregatePathExpressionParser = new PathExpressionParser();

    public SelectParser() {
        this.pathExpressionParser.setUseThetaStyleJoin(true);
        this.aggregatePathExpressionParser.setUseThetaStyleJoin(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String string2 = string.toLowerCase();
        if (this.first) {
            this.first = false;
            if ("distinct".equals(string2)) {
                queryTranslatorImpl.setDistinct(true);
                return;
            }
            if ("all".equals(string2)) {
                queryTranslatorImpl.setDistinct(false);
                return;
            }
        }
        if (this.afterNew) {
            this.afterNew = false;
            try {
                this.holderClass = ReflectHelper.classForName(QuerySplitter.getImportedClass(string, queryTranslatorImpl.getFactory()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new QueryException(classNotFoundException);
            }
            if (this.holderClass == null) {
                throw new QueryException("class not found: " + string);
            }
            queryTranslatorImpl.setHolderClass(this.holderClass);
            this.insideNew = true;
            return;
        }
        if (string.equals(",")) {
            if (!this.aggregate && this.ready) {
                throw new QueryException("alias or expression expected in SELECT");
            }
            queryTranslatorImpl.appendScalarSelectToken(", ");
            this.ready = true;
            return;
        }
        if ("new".equals(string2)) {
            this.afterNew = true;
            this.ready = false;
            return;
        }
        if ("(".equals(string)) {
            if (this.insideNew && !this.aggregate && !this.ready) {
                this.ready = true;
            } else {
                if (!this.aggregate) throw new QueryException("aggregate function expected before ( in SELECT");
                queryTranslatorImpl.appendScalarSelectToken(string);
            }
            this.ready = true;
            return;
        }
        if (")".equals(string)) {
            if (this.insideNew && !this.aggregate && !this.ready) {
                this.insideNew = false;
                return;
            } else {
                if (!this.aggregate || !this.ready) throw new QueryException("( expected before ) in select");
                queryTranslatorImpl.appendScalarSelectToken(string);
                this.aggregateFuncTokenList.removeLast();
                if (this.aggregateFuncTokenList.size() >= 1) return;
                this.aggregate = false;
                this.ready = false;
            }
            return;
        }
        if (COUNT_MODIFIERS.contains(string2)) {
            if (!this.ready || !this.aggregate) {
                throw new QueryException(string + " only allowed inside aggregate function in SELECT");
            }
            queryTranslatorImpl.appendScalarSelectToken(string);
            if (!"*".equals(string)) return;
            queryTranslatorImpl.addSelectScalar(this.getFunction("count", queryTranslatorImpl).getReturnType(StandardBasicTypes.LONG, queryTranslatorImpl.getFactory()));
            return;
        }
        if (this.getFunction(string2, queryTranslatorImpl) != null && string.equals(queryTranslatorImpl.unalias(string))) {
            if (!this.ready) {
                throw new QueryException(", expected before aggregate function in SELECT: " + string);
            }
            this.aggregate = true;
            this.aggregateAddSelectScalar = true;
            this.aggregateFuncTokenList.add(string2);
            this.ready = false;
            queryTranslatorImpl.appendScalarSelectToken(string);
            if (this.aggregateHasArgs(string2, queryTranslatorImpl)) return;
            queryTranslatorImpl.addSelectScalar(this.aggregateType(this.aggregateFuncTokenList, null, queryTranslatorImpl));
            if (this.aggregateFuncNoArgsHasParenthesis(string2, queryTranslatorImpl)) return;
            this.aggregateFuncTokenList.removeLast();
            if (this.aggregateFuncTokenList.size() < 1) {
                this.aggregate = false;
                this.ready = false;
                return;
            } else {
                this.ready = true;
            }
            return;
        }
        if (this.aggregate) {
            boolean bl = false;
            if (!this.ready) {
                throw new QueryException("( expected after aggregate function in SELECT");
            }
            try {
                ParserHelper.parse(this.aggregatePathExpressionParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
            }
            catch (QueryException queryException) {
                bl = true;
            }
            if (bl) {
                queryTranslatorImpl.appendScalarSelectToken(string);
                return;
            } else {
                if (this.aggregatePathExpressionParser.isCollectionValued()) {
                    queryTranslatorImpl.addCollection(this.aggregatePathExpressionParser.getCollectionName(), this.aggregatePathExpressionParser.getCollectionRole());
                }
                queryTranslatorImpl.appendScalarSelectToken(this.aggregatePathExpressionParser.getWhereColumn());
                if (this.aggregateAddSelectScalar) {
                    queryTranslatorImpl.addSelectScalar(this.aggregateType(this.aggregateFuncTokenList, this.aggregatePathExpressionParser.getWhereColumnType(), queryTranslatorImpl));
                    this.aggregateAddSelectScalar = false;
                }
                this.aggregatePathExpressionParser.addAssociation(queryTranslatorImpl);
            }
            return;
        }
        if (!this.ready) {
            throw new QueryException(", expected in SELECT");
        }
        ParserHelper.parse(this.pathExpressionParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
        if (this.pathExpressionParser.isCollectionValued()) {
            queryTranslatorImpl.addCollection(this.pathExpressionParser.getCollectionName(), this.pathExpressionParser.getCollectionRole());
        } else if (this.pathExpressionParser.getWhereColumnType().isEntityType()) {
            queryTranslatorImpl.addSelectClass(this.pathExpressionParser.getSelectName());
        }
        queryTranslatorImpl.appendScalarSelectTokens(this.pathExpressionParser.getWhereColumns());
        queryTranslatorImpl.addSelectScalar(this.pathExpressionParser.getWhereColumnType());
        this.pathExpressionParser.addAssociation(queryTranslatorImpl);
        this.ready = false;
    }

    public boolean aggregateHasArgs(String string, QueryTranslatorImpl queryTranslatorImpl) {
        return this.getFunction(string, queryTranslatorImpl).hasArguments();
    }

    public boolean aggregateFuncNoArgsHasParenthesis(String string, QueryTranslatorImpl queryTranslatorImpl) {
        return this.getFunction(string, queryTranslatorImpl).hasParenthesesIfNoArguments();
    }

    public Type aggregateType(List list, Type type, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        Type type2 = type;
        for (int i = list.size() - 1; i >= 0; --i) {
            Type type3 = type2;
            String string = (String)list.get(i);
            type2 = this.getFunction(string, queryTranslatorImpl).getReturnType(type3, queryTranslatorImpl.getFactory());
        }
        return type2;
    }

    private SQLFunction getFunction(String string, QueryTranslatorImpl queryTranslatorImpl) {
        return queryTranslatorImpl.getFactory().getSqlFunctionRegistry().findSQLFunction(string);
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) {
        this.ready = true;
        this.first = true;
        this.aggregate = false;
        this.afterNew = false;
        this.insideNew = false;
        this.holderClass = null;
        this.aggregateFuncTokenList.clear();
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) {
    }

    static {
        COUNT_MODIFIERS.add("distinct");
        COUNT_MODIFIERS.add("all");
        COUNT_MODIFIERS.add("*");
    }
}

