/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.classic;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.classic.FromPathExpressionParser;
import org.hibernate.hql.internal.classic.Parser;
import org.hibernate.hql.internal.classic.ParserHelper;
import org.hibernate.hql.internal.classic.PathExpressionParser;
import org.hibernate.hql.internal.classic.QueryTranslatorImpl;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinType;

public class FromParser
implements Parser {
    private final PathExpressionParser peParser = new FromPathExpressionParser();
    private String entityName;
    private String alias;
    private boolean afterIn;
    private boolean afterAs;
    private boolean afterClass;
    private boolean expectingJoin;
    private boolean expectingIn;
    private boolean expectingAs;
    private boolean afterJoinType;
    private JoinType joinType = JoinType.INNER_JOIN;
    private boolean afterFetch;
    private boolean memberDeclarations;
    private boolean expectingPathExpression;
    private boolean afterMemberDeclarations;
    private String collectionName;
    private static final Map<String, JoinType> JOIN_TYPES = new HashMap<String, JoinType>();

    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String string2 = string.toLowerCase();
        if (string2.equals(",")) {
            if (!(this.expectingJoin | this.expectingAs)) {
                throw new QueryException("unexpected token: ,");
            }
            this.expectingJoin = false;
            this.expectingAs = false;
        } else if (string2.equals("join")) {
            if (!this.afterJoinType) {
                if (!(this.expectingJoin | this.expectingAs)) {
                    throw new QueryException("unexpected token: join");
                }
                this.joinType = JoinType.INNER_JOIN;
                this.expectingJoin = false;
                this.expectingAs = false;
            } else {
                this.afterJoinType = false;
            }
        } else if (string2.equals("fetch")) {
            if (queryTranslatorImpl.isShallowQuery()) {
                throw new QueryException("fetch may not be used with scroll() or iterate()");
            }
            if (this.joinType == JoinType.NONE) {
                throw new QueryException("unexpected token: fetch");
            }
            if (this.joinType == JoinType.FULL_JOIN || this.joinType == JoinType.RIGHT_OUTER_JOIN) {
                throw new QueryException("fetch may only be used with inner join or left outer join");
            }
            this.afterFetch = true;
        } else if (string2.equals("outer")) {
            if (!this.afterJoinType || this.joinType != JoinType.LEFT_OUTER_JOIN && this.joinType != JoinType.RIGHT_OUTER_JOIN) {
                throw new QueryException("unexpected token: outer");
            }
        } else if (JOIN_TYPES.containsKey(string2)) {
            if (!(this.expectingJoin | this.expectingAs)) {
                throw new QueryException("unexpected token: " + string);
            }
            this.joinType = JOIN_TYPES.get(string2);
            this.afterJoinType = true;
            this.expectingJoin = false;
            this.expectingAs = false;
        } else if (string2.equals("class")) {
            if (!this.afterIn) {
                throw new QueryException("unexpected token: class");
            }
            if (this.joinType != JoinType.NONE) {
                throw new QueryException("outer or full join must be followed by path expression");
            }
            this.afterClass = true;
        } else if (string2.equals("in")) {
            if (this.alias == null) {
                this.memberDeclarations = true;
                this.afterMemberDeclarations = false;
            } else {
                if (!this.expectingIn) {
                    throw new QueryException("unexpected token: in");
                }
                this.afterIn = true;
                this.expectingIn = false;
            }
        } else if (string2.equals("as")) {
            if (!this.expectingAs) {
                throw new QueryException("unexpected token: as");
            }
            this.afterAs = true;
            this.expectingAs = false;
        } else if ("(".equals(string)) {
            if (!this.memberDeclarations) {
                throw new QueryException("unexpected token: (");
            }
            this.expectingPathExpression = true;
        } else if (")".equals(string)) {
            this.afterMemberDeclarations = true;
        } else {
            if (this.afterJoinType) {
                throw new QueryException("join expected: " + string);
            }
            if (this.expectingJoin) {
                throw new QueryException("unexpected token: " + string);
            }
            if (this.expectingIn) {
                throw new QueryException("in expected: " + string);
            }
            if (this.afterAs || this.expectingAs) {
                if (this.entityName != null) {
                    queryTranslatorImpl.setAliasName(string, this.entityName);
                } else if (this.collectionName != null) {
                    queryTranslatorImpl.setAliasName(string, this.collectionName);
                } else {
                    throw new QueryException("unexpected: as " + string);
                }
                this.afterAs = false;
                this.expectingJoin = true;
                this.expectingAs = false;
                this.entityName = null;
                this.collectionName = null;
                this.memberDeclarations = false;
                this.expectingPathExpression = false;
                this.afterMemberDeclarations = false;
            } else if (this.afterIn) {
                if (this.alias == null) {
                    throw new QueryException("alias not specified for: " + string);
                }
                if (this.joinType != JoinType.NONE) {
                    throw new QueryException("outer or full join must be followed by path expression");
                }
                if (this.afterClass) {
                    Queryable queryable = queryTranslatorImpl.getEntityPersisterUsingImports(string);
                    if (queryable == null) {
                        throw new QueryException("persister not found: " + string);
                    }
                    queryTranslatorImpl.addFromClass(this.alias, queryable);
                } else {
                    this.peParser.setJoinType(JoinType.INNER_JOIN);
                    this.peParser.setUseThetaStyleJoin(true);
                    ParserHelper.parse(this.peParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
                    if (!this.peParser.isCollectionValued()) {
                        throw new QueryException("path expression did not resolve to collection: " + string);
                    }
                    String string3 = this.peParser.addFromCollection(queryTranslatorImpl);
                    queryTranslatorImpl.setAliasName(this.alias, string3);
                }
                this.alias = null;
                this.afterIn = false;
                this.afterClass = false;
                this.expectingJoin = true;
            } else if (this.memberDeclarations && this.expectingPathExpression) {
                this.expectingAs = true;
                this.peParser.setJoinType(JoinType.INNER_JOIN);
                this.peParser.setUseThetaStyleJoin(false);
                ParserHelper.parse(this.peParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
                if (!this.peParser.isCollectionValued()) {
                    throw new QueryException("path expression did not resolve to collection: " + string);
                }
                this.collectionName = this.peParser.addFromCollection(queryTranslatorImpl);
                this.expectingPathExpression = false;
                this.memberDeclarations = false;
            } else {
                Queryable queryable = queryTranslatorImpl.getEntityPersisterUsingImports(string);
                if (queryable != null) {
                    if (this.joinType != JoinType.NONE) {
                        throw new QueryException("outer or full join must be followed by path expression");
                    }
                    this.entityName = queryTranslatorImpl.createNameFor(queryable.getEntityName());
                    queryTranslatorImpl.addFromClass(this.entityName, queryable);
                    this.expectingAs = true;
                } else if (string.indexOf(46) < 0) {
                    this.alias = string;
                    this.expectingIn = true;
                } else {
                    if (this.joinType != JoinType.NONE) {
                        this.peParser.setJoinType(this.joinType);
                    } else {
                        this.peParser.setJoinType(JoinType.INNER_JOIN);
                    }
                    this.peParser.setUseThetaStyleJoin(queryTranslatorImpl.isSubquery());
                    ParserHelper.parse(this.peParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
                    this.entityName = this.peParser.addFromAssociation(queryTranslatorImpl);
                    this.joinType = JoinType.NONE;
                    this.peParser.setJoinType(JoinType.INNER_JOIN);
                    if (this.afterFetch) {
                        this.peParser.fetch(queryTranslatorImpl, this.entityName);
                        this.afterFetch = false;
                    }
                    this.expectingAs = true;
                }
            }
        }
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) {
        this.entityName = null;
        this.collectionName = null;
        this.alias = null;
        this.afterIn = false;
        this.afterAs = false;
        this.afterClass = false;
        this.expectingJoin = false;
        this.expectingIn = false;
        this.expectingAs = false;
        this.memberDeclarations = false;
        this.expectingPathExpression = false;
        this.afterMemberDeclarations = false;
        this.joinType = JoinType.NONE;
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) {
        if (this.afterMemberDeclarations) {
            throw new QueryException("alias not specified for IN");
        }
    }

    static {
        JOIN_TYPES.put("left", JoinType.LEFT_OUTER_JOIN);
        JOIN_TYPES.put("right", JoinType.RIGHT_OUTER_JOIN);
        JOIN_TYPES.put("full", JoinType.FULL_JOIN);
        JOIN_TYPES.put("inner", JoinType.INNER_JOIN);
    }
}

