/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.util;

import antlr.collections.AST;
import java.util.Map;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.tree.RestrictableStatement;
import org.hibernate.hql.internal.ast.tree.SqlFragment;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.hql.internal.ast.util.JoinProcessor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.CollectionFilterKeyParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SyntheticAndFactory
implements HqlSqlTokenTypes {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SyntheticAndFactory.class.getName());
    private HqlSqlWalker hqlSqlWalker;
    private AST thetaJoins;
    private AST filters;

    public SyntheticAndFactory(HqlSqlWalker hqlSqlWalker) {
        this.hqlSqlWalker = hqlSqlWalker;
    }

    private Node create(int n, String string) {
        return (Node)ASTUtil.create(this.hqlSqlWalker.getASTFactory(), n, string);
    }

    public void addWhereFragment(JoinFragment joinFragment, String string, QueryNode queryNode, FromElement fromElement, HqlSqlWalker hqlSqlWalker) {
        Type type;
        if (string == null) {
            return;
        }
        if (!fromElement.useWhereFragment() && !joinFragment.hasThetaJoins()) {
            return;
        }
        if (StringHelper.isEmpty(string = string.trim())) {
            return;
        }
        if (string.startsWith("and")) {
            string = string.substring(4);
        }
        LOG.debugf("Using unprocessed WHERE-fragment [%s]", (Object)string);
        SqlFragment sqlFragment = (SqlFragment)this.create(145, string);
        sqlFragment.setJoinFragment(joinFragment);
        sqlFragment.setFromElement(fromElement);
        if (fromElement.getIndexCollectionSelectorParamSpec() != null) {
            sqlFragment.addEmbeddedParameter(fromElement.getIndexCollectionSelectorParamSpec());
            fromElement.setIndexCollectionSelectorParamSpec(null);
        }
        if (hqlSqlWalker.isFilter() && string.indexOf(63) >= 0) {
            type = hqlSqlWalker.getSessionFactoryHelper().requireQueryableCollection(hqlSqlWalker.getCollectionFilterRole()).getKeyType();
            CollectionFilterKeyParameterSpecification collectionFilterKeyParameterSpecification = new CollectionFilterKeyParameterSpecification(hqlSqlWalker.getCollectionFilterRole(), type, 0);
            sqlFragment.addEmbeddedParameter(collectionFilterKeyParameterSpecification);
        }
        JoinProcessor.processDynamicFilterParameters(string, sqlFragment, hqlSqlWalker);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Using processed WHERE-fragment [%s]", (Object)sqlFragment.getText());
        }
        if (sqlFragment.getFromElement().isFilter() || sqlFragment.hasFilterCondition()) {
            if (this.filters == null) {
                type = queryNode.getWhereClause();
                this.filters = this.create(149, "{filter conditions}");
                ASTUtil.insertChild((AST)type, this.filters);
            }
            this.filters.addChild((AST)sqlFragment);
        } else {
            if (this.thetaJoins == null) {
                type = queryNode.getWhereClause();
                this.thetaJoins = this.create(148, "{theta joins}");
                if (this.filters == null) {
                    ASTUtil.insertChild((AST)type, this.thetaJoins);
                } else {
                    ASTUtil.insertSibling(this.thetaJoins, this.filters);
                }
            }
            this.thetaJoins.addChild((AST)sqlFragment);
        }
    }

    public void addDiscriminatorWhereFragment(RestrictableStatement restrictableStatement, Queryable queryable, Map map, String string) {
        String string2 = queryable.filterFragment(string, map).trim();
        if ("".equals(string2)) {
            return;
        }
        if (string2.startsWith("and")) {
            string2 = string2.substring(4);
        }
        string2 = StringHelper.replace(string2, queryable.generateFilterConditionAlias(string) + ".", "");
        SqlFragment sqlFragment = (SqlFragment)this.create(145, string2);
        JoinProcessor.processDynamicFilterParameters(string2, sqlFragment, this.hqlSqlWalker);
        if (restrictableStatement.getWhereClause().getNumberOfChildren() == 0) {
            restrictableStatement.getWhereClause().setFirstChild((AST)sqlFragment);
        } else {
            Node node = this.create(6, "{and}");
            AST aST = restrictableStatement.getWhereClause().getFirstChild();
            node.setFirstChild((AST)sqlFragment);
            node.addChild(aST);
            restrictableStatement.getWhereClause().setFirstChild((AST)node);
        }
    }
}

