/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.util;

import antlr.collections.AST;
import java.util.Stack;

public class NodeTraverser {
    private final VisitationStrategy strategy;

    public NodeTraverser(VisitationStrategy visitationStrategy) {
        this.strategy = visitationStrategy;
    }

    public void traverseDepthFirst(AST aST) {
        if (aST == null) {
            throw new IllegalArgumentException("node to traverse cannot be null!");
        }
        this.visitDepthFirst(aST.getFirstChild());
    }

    private void visitDepthFirst(AST aST) {
        if (aST == null) {
            return;
        }
        Stack<AST> stack = new Stack<AST>();
        if (aST != null) {
            stack.push(aST);
            while (!stack.empty()) {
                aST = (AST)stack.pop();
                this.strategy.visit(aST);
                if (aST.getNextSibling() != null) {
                    stack.push(aST.getNextSibling());
                }
                if (aST.getFirstChild() == null) continue;
                stack.push(aST.getFirstChild());
            }
        }
    }

    public static interface VisitationStrategy {
        public void visit(AST var1);
    }
}

