/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.hibernate.AssertionFailure;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.hql.internal.antlr.SqlTokenTypes;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.DotNode;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.ParameterContainer;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.util.SyntheticAndFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.param.DynamicFilterParameterSpecification;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class JoinProcessor
implements SqlTokenTypes {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JoinProcessor.class.getName());
    private final HqlSqlWalker walker;
    private final SyntheticAndFactory syntheticAndFactory;

    public JoinProcessor(HqlSqlWalker hqlSqlWalker) {
        this.walker = hqlSqlWalker;
        this.syntheticAndFactory = new SyntheticAndFactory(hqlSqlWalker);
    }

    public static JoinType toHibernateJoinType(int n) {
        switch (n) {
            case 141: {
                return JoinType.LEFT_OUTER_JOIN;
            }
            case 28: {
                return JoinType.INNER_JOIN;
            }
            case 142: {
                return JoinType.RIGHT_OUTER_JOIN;
            }
            case 23: {
                return JoinType.FULL_JOIN;
            }
        }
        throw new AssertionFailure("undefined join type " + n);
    }

    public void processJoins(QueryNode queryNode) {
        ArrayList arrayList;
        final FromClause fromClause = queryNode.getFromClause();
        if (DotNode.useThetaStyleImplicitJoins) {
            arrayList = new ArrayList();
            Iterator iterator = fromClause.getFromElements().listIterator(fromClause.getFromElements().size());
            while (iterator.hasPrevious()) {
                arrayList.add(iterator.previous());
            }
        } else {
            arrayList = fromClause.getFromElements();
        }
        for (final FromElement fromElement : arrayList) {
            JoinSequence joinSequence = fromElement.getJoinSequence();
            joinSequence.setSelector(new JoinSequence.Selector(){

                public boolean includeSubclasses(String string) {
                    boolean bl = fromClause.containsTableAlias(string);
                    if (fromElement.isDereferencedBySubclassProperty()) {
                        LOG.tracev("Forcing inclusion of extra joins [alias={0}, containsTableAlias={1}]", (Object)string, (Object)bl);
                        return true;
                    }
                    boolean bl2 = JoinProcessor.this.walker.isShallowQuery();
                    boolean bl3 = fromElement.isIncludeSubclasses();
                    boolean bl4 = fromClause.isSubQuery();
                    return bl3 && bl && !bl4 && !bl2;
                }
            });
            this.addJoinNodes(queryNode, joinSequence, fromElement);
        }
    }

    private void addJoinNodes(QueryNode queryNode, JoinSequence joinSequence, FromElement fromElement) {
        JoinFragment joinFragment = joinSequence.toJoinFragment(this.walker.getEnabledFilters(), fromElement.useFromFragment() || fromElement.isDereferencedBySuperclassOrSubclassProperty(), fromElement.getWithClauseFragment(), fromElement.getWithClauseJoinAlias());
        String string = joinFragment.toFromFragmentString();
        String string2 = joinFragment.toWhereFragmentString();
        if (fromElement.getType() == 139 && (joinSequence.isThetaStyle() || StringHelper.isNotEmpty(string2))) {
            fromElement.setType(137);
            fromElement.getJoinSequence().setUseThetaStyle(true);
        }
        if (fromElement.useFromFragment()) {
            String string3 = this.processFromFragment(string, joinSequence).trim();
            LOG.debugf("Using FROM fragment [%s]", (Object)string3);
            JoinProcessor.processDynamicFilterParameters(string3, fromElement, this.walker);
        }
        this.syntheticAndFactory.addWhereFragment(joinFragment, string2, queryNode, fromElement, this.walker);
    }

    private String processFromFragment(String string, JoinSequence joinSequence) {
        String string2 = string.trim();
        if (string2.startsWith(", ")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public static void processDynamicFilterParameters(String string, ParameterContainer parameterContainer, HqlSqlWalker hqlSqlWalker) {
        if (hqlSqlWalker.getEnabledFilters().isEmpty() && !JoinProcessor.hasDynamicFilterParam(string) && !JoinProcessor.hasCollectionFilterParam(string)) {
            return;
        }
        Dialect dialect = hqlSqlWalker.getSessionFactoryHelper().getFactory().getDialect();
        String string2 = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith(":")) {
                String string4 = string3.substring(1);
                String[] stringArray = LoadQueryInfluencers.parseFilterParameterName(string4);
                FilterImpl filterImpl = (FilterImpl)hqlSqlWalker.getEnabledFilters().get(stringArray[0]);
                Object object = filterImpl.getParameter(stringArray[1]);
                Type type = filterImpl.getFilterDefinition().getParameterType(stringArray[1]);
                String string5 = StringHelper.join(",", ArrayHelper.fillArray("?", type.getColumnSpan(hqlSqlWalker.getSessionFactoryHelper().getFactory())));
                String string6 = object != null && Collection.class.isInstance(object) ? StringHelper.join(",", ArrayHelper.fillArray(string5, ((Collection)object).size())) : string5;
                stringBuilder.append(string6);
                parameterContainer.addEmbeddedParameter(new DynamicFilterParameterSpecification(stringArray[0], stringArray[1], type));
                continue;
            }
            stringBuilder.append(string3);
        }
        parameterContainer.setText(stringBuilder.toString());
    }

    private static boolean hasDynamicFilterParam(String string) {
        return string.indexOf(":") < 0;
    }

    private static boolean hasCollectionFilterParam(String string) {
        return string.indexOf("?") < 0;
    }
}

