/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.hql.internal.ast.util.NodeTraverser;

public final class ASTUtil {
    private ASTUtil() {
    }

    public static AST create(ASTFactory aSTFactory, int n, String string) {
        return aSTFactory.create(n, string);
    }

    public static AST createSibling(ASTFactory aSTFactory, int n, String string, AST aST) {
        AST aST2 = aSTFactory.create(n, string);
        return ASTUtil.insertSibling(aST2, aST);
    }

    public static AST insertSibling(AST aST, AST aST2) {
        aST.setNextSibling(aST2.getNextSibling());
        aST2.setNextSibling(aST);
        return aST;
    }

    public static AST createBinarySubtree(ASTFactory aSTFactory, int n, String string, AST aST, AST aST2) {
        ASTArray aSTArray = ASTUtil.createAstArray(aSTFactory, 3, n, string, aST);
        aSTArray.add(aST2);
        return aSTFactory.make(aSTArray);
    }

    public static AST createParent(ASTFactory aSTFactory, int n, String string, AST aST) {
        ASTArray aSTArray = ASTUtil.createAstArray(aSTFactory, 2, n, string, aST);
        return aSTFactory.make(aSTArray);
    }

    public static AST createTree(ASTFactory aSTFactory, AST[] aSTArray) {
        int n;
        AST[] aSTArray2 = new AST[2];
        for (int i = n = aSTArray.length - 1; i >= 0; --i) {
            if (i == n) continue;
            aSTArray2[1] = aSTArray[i + 1];
            aSTArray2[0] = aSTArray[i];
            aSTFactory.make(aSTArray2);
        }
        return aSTArray2[0];
    }

    public static boolean isSubtreeChild(AST aST, AST aST2) {
        for (AST aST3 = aST.getFirstChild(); aST3 != null; aST3 = aST3.getNextSibling()) {
            if (aST3 == aST2) {
                return true;
            }
            if (aST3.getFirstChild() == null || !ASTUtil.isSubtreeChild(aST3, aST2)) continue;
            return true;
        }
        return false;
    }

    public static AST findTypeInChildren(AST aST, int n) {
        AST aST2;
        for (aST2 = aST.getFirstChild(); aST2 != null && aST2.getType() != n; aST2 = aST2.getNextSibling()) {
        }
        return aST2;
    }

    public static AST getLastChild(AST aST) {
        return ASTUtil.getLastSibling(aST.getFirstChild());
    }

    private static AST getLastSibling(AST aST) {
        AST aST2 = null;
        while (aST != null) {
            aST2 = aST;
            aST = aST.getNextSibling();
        }
        return aST2;
    }

    public static String getDebugString(AST aST) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append(aST == null ? "{null}" : aST.toStringTree());
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public static AST findPreviousSibling(AST aST, AST aST2) {
        AST aST3 = null;
        for (AST aST4 = aST.getFirstChild(); aST4 != null; aST4 = aST4.getNextSibling()) {
            if (aST4 == aST2) {
                return aST3;
            }
            aST3 = aST4;
        }
        throw new IllegalArgumentException("Child not found in parent!");
    }

    public static void makeSiblingOfParent(AST aST, AST aST2) {
        AST aST3 = ASTUtil.findPreviousSibling(aST, aST2);
        if (aST3 != null) {
            aST3.setNextSibling(aST2.getNextSibling());
        } else {
            aST.setFirstChild(aST2.getNextSibling());
        }
        aST2.setNextSibling(aST.getNextSibling());
        aST.setNextSibling(aST2);
    }

    public static String getPathText(AST aST) {
        StringBuilder stringBuilder = new StringBuilder();
        ASTUtil.getPathText(stringBuilder, aST);
        return stringBuilder.toString();
    }

    private static void getPathText(StringBuilder stringBuilder, AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            ASTUtil.getPathText(stringBuilder, aST2);
        }
        stringBuilder.append(aST.getText());
        if (aST2 != null && aST2.getNextSibling() != null) {
            ASTUtil.getPathText(stringBuilder, aST2.getNextSibling());
        }
    }

    public static boolean hasExactlyOneChild(AST aST) {
        return aST != null && aST.getFirstChild() != null && aST.getFirstChild().getNextSibling() == null;
    }

    public static void appendSibling(AST aST, AST aST2) {
        while (aST.getNextSibling() != null) {
            aST = aST.getNextSibling();
        }
        aST.setNextSibling(aST2);
    }

    public static void insertChild(AST aST, AST aST2) {
        if (aST.getFirstChild() == null) {
            aST.setFirstChild(aST2);
        } else {
            AST aST3 = aST.getFirstChild();
            aST.setFirstChild(aST2);
            aST2.setNextSibling(aST3);
        }
    }

    private static ASTArray createAstArray(ASTFactory aSTFactory, int n, int n2, String string, AST aST) {
        ASTArray aSTArray = new ASTArray(n);
        aSTArray.add(aSTFactory.create(n2, string));
        aSTArray.add(aST);
        return aSTArray;
    }

    public static List collectChildren(AST aST, FilterPredicate filterPredicate) {
        return new CollectingNodeVisitor(filterPredicate).collect(aST);
    }

    public static Map generateTokenNameCache(Class clazz) {
        Field[] fieldArray = clazz.getFields();
        HashMap<Object, String> hashMap = new HashMap<Object, String>((int)((double)fieldArray.length * 0.75) + 1);
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                hashMap.put(field.get(null), field.getName());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public static String getConstantName(Class clazz, int n) {
        return ASTUtil.getTokenTypeName(clazz, n);
    }

    public static String getTokenTypeName(Class clazz, int n) {
        String string = Integer.toString(n);
        if (clazz != null) {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Integer n2 = ASTUtil.extractIntegerValue(fieldArray[i]);
                if (n2 == null || n2 != n) continue;
                string = fieldArray[i].getName();
                break;
            }
        }
        return string;
    }

    private static Integer extractIntegerValue(Field field) {
        Integer n = null;
        try {
            Object object = field.get(null);
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof Short) {
                n = ((Short)object).intValue();
            } else if (object instanceof Long && (Long)object <= Integer.MAX_VALUE) {
                n = ((Long)object).intValue();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return n;
    }

    private static class CollectingNodeVisitor
    implements NodeTraverser.VisitationStrategy {
        private final FilterPredicate predicate;
        private final List collectedNodes = new ArrayList();

        public CollectingNodeVisitor(FilterPredicate filterPredicate) {
            this.predicate = filterPredicate;
        }

        public void visit(AST aST) {
            if (this.predicate == null || !this.predicate.exclude(aST)) {
                this.collectedNodes.add(aST);
            }
        }

        public List getCollectedNodes() {
            return this.collectedNodes;
        }

        public List collect(AST aST) {
            NodeTraverser nodeTraverser = new NodeTraverser(this);
            nodeTraverser.traverseDepthFirst(aST);
            return this.collectedNodes;
        }
    }

    public static abstract class IncludePredicate
    implements FilterPredicate {
        public final boolean exclude(AST aST) {
            return !this.include(aST);
        }

        public abstract boolean include(AST var1);
    }

    public static interface FilterPredicate {
        public boolean exclude(AST var1);
    }
}

