/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.util;

import antlr.collections.AST;
import java.util.Iterator;
import java.util.LinkedList;

public class ASTIterator
implements Iterator {
    private AST next;
    private AST current;
    private LinkedList parents = new LinkedList();

    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextNode();
    }

    public ASTIterator(AST aST) {
        this.next = aST;
        this.down();
    }

    public AST nextNode() {
        this.current = this.next;
        if (this.next != null) {
            AST aST = this.next.getNextSibling();
            if (aST == null) {
                this.next = this.pop();
            } else {
                this.next = aST;
                this.down();
            }
        }
        return this.current;
    }

    private void down() {
        while (this.next != null && this.next.getFirstChild() != null) {
            this.push(this.next);
            this.next = this.next.getFirstChild();
        }
    }

    private void push(AST aST) {
        this.parents.addFirst(aST);
    }

    private AST pop() {
        if (this.parents.size() == 0) {
            return null;
        }
        return (AST)this.parents.removeFirst();
    }
}

