/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.NameGenerator;
import org.hibernate.hql.internal.ast.tree.AbstractMapComponentNode;
import org.hibernate.hql.internal.ast.tree.AggregatedSelectExpression;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.AliasGenerator;
import org.hibernate.sql.SelectExpression;
import org.hibernate.sql.SelectFragment;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class MapEntryNode
extends AbstractMapComponentNode
implements AggregatedSelectExpression {
    private int scalarColumnIndex = -1;
    private List types = new ArrayList(4);
    private static final String[] ALIASES = new String[]{null, null};
    private MapEntryBuilder mapEntryBuilder;

    protected String expressionDescription() {
        return "entry(*)";
    }

    public Class getAggregationResultType() {
        return Map.Entry.class;
    }

    protected Type resolveType(QueryableCollection queryableCollection) {
        Type type = queryableCollection.getIndexType();
        Type type2 = queryableCollection.getElementType();
        this.types.add(type);
        this.types.add(type2);
        this.mapEntryBuilder = new MapEntryBuilder();
        return null;
    }

    protected String[] resolveColumns(QueryableCollection queryableCollection) {
        ArrayList arrayList = new ArrayList();
        this.determineKeySelectExpressions(queryableCollection, arrayList);
        this.determineValueSelectExpressions(queryableCollection, arrayList);
        String string = "";
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            SelectExpression selectExpression = (SelectExpression)arrayList.get(i);
            string = string + ", " + selectExpression.getExpression() + " as " + selectExpression.getAlias();
            stringArray[i] = selectExpression.getExpression();
        }
        string = string.substring(2);
        this.setText(string);
        this.setResolved();
        return stringArray;
    }

    private void determineKeySelectExpressions(QueryableCollection queryableCollection, List list) {
        LocalAliasGenerator localAliasGenerator = new LocalAliasGenerator(0);
        this.appendSelectExpressions(queryableCollection.getIndexColumnNames(), list, (AliasGenerator)localAliasGenerator);
        Type type = queryableCollection.getIndexType();
        if (type.isAssociationType()) {
            EntityType entityType = (EntityType)type;
            Queryable queryable = (Queryable)this.sfi().getEntityPersister(entityType.getAssociatedEntityName(this.sfi()));
            SelectFragment selectFragment = queryable.propertySelectFragmentFragment(this.collectionTableAlias(), null, false);
            this.appendSelectExpressions(selectFragment, list, (AliasGenerator)localAliasGenerator);
        }
    }

    private void appendSelectExpressions(String[] stringArray, List list, AliasGenerator aliasGenerator) {
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(new BasicSelectExpression(this.collectionTableAlias() + '.' + stringArray[i], aliasGenerator.generateAlias(stringArray[i])));
        }
    }

    private void appendSelectExpressions(SelectFragment selectFragment, List list, AliasGenerator aliasGenerator) {
        for (String string : selectFragment.getColumns()) {
            list.add(new BasicSelectExpression(string, aliasGenerator.generateAlias(string)));
        }
    }

    private void determineValueSelectExpressions(QueryableCollection queryableCollection, List list) {
        LocalAliasGenerator localAliasGenerator = new LocalAliasGenerator(1);
        this.appendSelectExpressions(queryableCollection.getElementColumnNames(), list, (AliasGenerator)localAliasGenerator);
        Type type = queryableCollection.getElementType();
        if (type.isAssociationType()) {
            EntityType entityType = (EntityType)type;
            Queryable queryable = (Queryable)this.sfi().getEntityPersister(entityType.getAssociatedEntityName(this.sfi()));
            SelectFragment selectFragment = queryable.propertySelectFragmentFragment(this.elementTableAlias(), null, false);
            this.appendSelectExpressions(selectFragment, list, (AliasGenerator)localAliasGenerator);
        }
    }

    private String collectionTableAlias() {
        return this.getFromElement().getCollectionTableAlias() != null ? this.getFromElement().getCollectionTableAlias() : this.getFromElement().getTableAlias();
    }

    private String elementTableAlias() {
        return this.getFromElement().getTableAlias();
    }

    public SessionFactoryImplementor sfi() {
        return this.getSessionFactoryHelper().getFactory();
    }

    public void setText(String string) {
        if (this.isResolved()) {
            return;
        }
        super.setText(string);
    }

    public void setScalarColumn(int n) throws SemanticException {
        this.scalarColumnIndex = n;
    }

    public int getScalarColumnIndex() {
        return this.scalarColumnIndex;
    }

    public void setScalarColumnText(int n) throws SemanticException {
    }

    public boolean isScalar() {
        return true;
    }

    public List getAggregatedSelectionTypeList() {
        return this.types;
    }

    public String[] getAggregatedAliases() {
        return ALIASES;
    }

    public ResultTransformer getResultTransformer() {
        return this.mapEntryBuilder;
    }

    private static class EntryAdapter
    implements Map.Entry {
        private final Object key;
        private Object value;

        private EntryAdapter(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            EntryAdapter entryAdapter = (EntryAdapter)object;
            return (this.key == null ? entryAdapter.key == null : this.key.equals(entryAdapter.key)) && (this.value == null ? entryAdapter.value == null : this.value.equals(entryAdapter.value));
        }

        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }
    }

    private static class MapEntryBuilder
    extends BasicTransformerAdapter {
        private MapEntryBuilder() {
        }

        public Object transformTuple(Object[] objectArray, String[] stringArray) {
            if (objectArray.length != 2) {
                throw new HibernateException("Expecting exactly 2 tuples to transform into Map.Entry");
            }
            return new EntryAdapter(objectArray[0], objectArray[1]);
        }
    }

    private static class BasicSelectExpression
    implements SelectExpression {
        private final String expression;
        private final String alias;

        private BasicSelectExpression(String string, String string2) {
            this.expression = string;
            this.alias = string2;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    private static class LocalAliasGenerator
    implements AliasGenerator {
        private final int base;
        private int counter = 0;

        private LocalAliasGenerator(int n) {
            this.base = n;
        }

        public String generateAlias(String string) {
            return NameGenerator.scalarName(this.base, this.counter++);
        }
    }
}

