/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.SessionFactoryAwareNode;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;

public class JavaConstantNode
extends Node
implements ExpectedTypeAwareNode,
SessionFactoryAwareNode {
    private SessionFactoryImplementor factory;
    private String constantExpression;
    private Object constantValue;
    private Type heuristicType;
    private Type expectedType;

    public void setText(String string) {
        if (StringHelper.isNotEmpty(string)) {
            this.constantExpression = string;
            this.constantValue = ReflectHelper.getConstantValue(string);
            this.heuristicType = this.factory.getTypeResolver().heuristicType(this.constantValue.getClass().getName());
            super.setText(string);
        }
    }

    public void setExpectedType(Type type) {
        this.expectedType = type;
    }

    public Type getExpectedType() {
        return this.expectedType;
    }

    public void setSessionFactory(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public String getRenderText(SessionFactoryImplementor sessionFactoryImplementor) {
        Type type = this.expectedType == null ? this.heuristicType : (Number.class.isAssignableFrom(this.heuristicType.getReturnedClass()) ? this.heuristicType : this.expectedType);
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            Dialect dialect = this.factory.getDialect();
            return literalType.objectToSQLString(this.constantValue, dialect);
        }
        catch (Throwable throwable) {
            throw new QueryException("Could not format constant value to SQL literal: " + this.constantExpression, throwable);
        }
    }
}

