/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.ast.tree.DisplayableNode;
import org.hibernate.hql.internal.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class IntoClause
extends HqlSqlWalkerNode
implements DisplayableNode {
    private Queryable persister;
    private String columnSpec = "";
    private Type[] types;
    private boolean discriminated;
    private boolean explicitIdInsertion;
    private boolean explicitVersionInsertion;
    private Set componentIds;
    private List explicitComponentIds;

    public void initialize(Queryable queryable) {
        if (queryable.isAbstract()) {
            throw new QueryException("cannot insert into abstract class (no table)");
        }
        this.persister = queryable;
        this.initializeColumns();
        if (this.getWalker().getSessionFactoryHelper().hasPhysicalDiscriminatorColumn(queryable)) {
            this.discriminated = true;
            this.columnSpec = this.columnSpec + ", " + queryable.getDiscriminatorColumnName();
        }
        this.resetText();
    }

    private void resetText() {
        this.setText("into " + this.getTableName() + " ( " + this.columnSpec + " )");
    }

    public String getTableName() {
        return this.persister.getSubclassTableName(0);
    }

    public Queryable getQueryable() {
        return this.persister;
    }

    public String getEntityName() {
        return this.persister.getEntityName();
    }

    public Type[] getInsertionTypes() {
        return this.types;
    }

    public boolean isDiscriminated() {
        return this.discriminated;
    }

    public boolean isExplicitIdInsertion() {
        return this.explicitIdInsertion;
    }

    public boolean isExplicitVersionInsertion() {
        return this.explicitVersionInsertion;
    }

    public void prependIdColumnSpec() {
        this.columnSpec = this.persister.getIdentifierColumnNames()[0] + ", " + this.columnSpec;
        this.resetText();
    }

    public void prependVersionColumnSpec() {
        this.columnSpec = this.persister.getPropertyColumnNames(this.persister.getVersionProperty())[0] + ", " + this.columnSpec;
        this.resetText();
    }

    public void validateTypes(SelectClause selectClause) throws QueryException {
        Type[] typeArray = selectClause.getQueryReturnTypes();
        if (typeArray.length != this.types.length) {
            throw new QueryException("number of select types did not match those for insert");
        }
        for (int i = 0; i < this.types.length; ++i) {
            if (this.areCompatible(this.types[i], typeArray[i])) continue;
            throw new QueryException("insertion type [" + this.types[i] + "] and selection type [" + typeArray[i] + "] at position " + i + " are not compatible");
        }
    }

    public String getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IntoClause{");
        stringBuilder.append("entityName=").append(this.getEntityName());
        stringBuilder.append(",tableName=").append(this.getTableName());
        stringBuilder.append(",columns={").append(this.columnSpec).append("}");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void initializeColumns() {
        AST aST = this.getFirstChild();
        ArrayList arrayList = new ArrayList();
        this.visitPropertySpecNodes(aST.getFirstChild(), arrayList);
        this.types = ArrayHelper.toTypeArray(arrayList);
        this.columnSpec = this.columnSpec.substring(0, this.columnSpec.length() - 2);
    }

    private void visitPropertySpecNodes(AST aST, List list) {
        String[] stringArray;
        if (aST == null) {
            return;
        }
        String string = aST.getText();
        if (this.isSuperclassProperty(string)) {
            throw new QueryException("INSERT statements cannot refer to superclass/joined properties [" + string + "]");
        }
        if (!this.explicitIdInsertion) {
            if (this.persister.getIdentifierType() instanceof ComponentType) {
                if (this.componentIds == null) {
                    stringArray = ((ComponentType)this.persister.getIdentifierType()).getPropertyNames();
                    this.componentIds = new HashSet();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.componentIds.add(stringArray[i]);
                    }
                }
                if (this.componentIds.contains(string)) {
                    if (this.explicitComponentIds == null) {
                        this.explicitComponentIds = new ArrayList(this.componentIds.size());
                    }
                    this.explicitComponentIds.add(string);
                    this.explicitIdInsertion = this.explicitComponentIds.size() == this.componentIds.size();
                }
            } else if (string.equals(this.persister.getIdentifierPropertyName())) {
                this.explicitIdInsertion = true;
            }
        }
        if (this.persister.isVersioned() && string.equals(this.persister.getPropertyNames()[this.persister.getVersionProperty()])) {
            this.explicitVersionInsertion = true;
        }
        stringArray = this.persister.toColumns(string);
        this.renderColumns(stringArray);
        list.add(this.persister.toType(string));
        this.visitPropertySpecNodes(aST.getNextSibling(), list);
        this.visitPropertySpecNodes(aST.getFirstChild(), list);
    }

    private void renderColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnSpec = this.columnSpec + stringArray[i] + ", ";
        }
    }

    private boolean isSuperclassProperty(String string) {
        return this.persister.getSubclassPropertyTableNumber(string) != 0;
    }

    private boolean areCompatible(Type type, Type type2) {
        int[] nArray;
        if (type.equals(type2)) {
            return true;
        }
        if (!type.getReturnedClass().isAssignableFrom(type2.getReturnedClass())) {
            return false;
        }
        int[] nArray2 = type.sqlTypes(this.getSessionFactoryHelper().getFactory());
        if (nArray2.length != (nArray = type2.sqlTypes(this.getSessionFactoryHelper().getFactory())).length) {
            return false;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (this.areSqlTypesCompatible(nArray2[i], nArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areSqlTypesCompatible(int n, int n2) {
        switch (n) {
            case 93: {
                return n2 == 91 || n2 == 92 || n2 == 93;
            }
            case 91: {
                return n2 == 91 || n2 == 93;
            }
            case 92: {
                return n2 == 92 || n2 == 93;
            }
        }
        return n == n2;
    }
}

