/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.SqlGenerator;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromElementFactory;
import org.hibernate.hql.internal.ast.tree.FromReferenceNode;
import org.hibernate.hql.internal.ast.util.SessionFactoryHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class IndexNode
extends FromReferenceNode {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IndexNode.class.getName());

    public void setScalarColumnText(int n) throws SemanticException {
        throw new UnsupportedOperationException("An IndexNode cannot generate column text!");
    }

    public void prepareForDot(String string) throws SemanticException {
        FromElement fromElement = this.getFromElement();
        if (fromElement == null) {
            throw new IllegalStateException("No FROM element for index operator!");
        }
        QueryableCollection queryableCollection = fromElement.getQueryableCollection();
        if (queryableCollection != null && !queryableCollection.isOneToMany()) {
            FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
            String string2 = fromReferenceNode.getPath() + "[]." + string;
            LOG.debugf("Creating join for many-to-many elements for %s", (Object)string2);
            FromElementFactory fromElementFactory = new FromElementFactory(fromElement.getFromClause(), fromElement, string2);
            FromElement fromElement2 = fromElementFactory.createElementJoin(queryableCollection);
            this.setFromElement(fromElement2);
        }
    }

    public void resolveIndex(AST aST) throws SemanticException {
        throw new UnsupportedOperationException();
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        Object object;
        FromElementFactory fromElementFactory;
        String string2;
        if (this.isResolved()) {
            return;
        }
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        SessionFactoryHelper sessionFactoryHelper = this.getSessionFactoryHelper();
        fromReferenceNode.resolveIndex((AST)this);
        Type type = fromReferenceNode.getDataType();
        if (!type.isCollectionType()) {
            throw new SemanticException("The [] operator cannot be applied to type " + type.toString());
        }
        String string3 = ((CollectionType)type).getRole();
        QueryableCollection queryableCollection = sessionFactoryHelper.requireQueryableCollection(string3);
        if (!queryableCollection.hasIndex()) {
            throw new QueryException("unindexed fromElement before []: " + fromReferenceNode.getPath());
        }
        FromElement fromElement = fromReferenceNode.getFromElement();
        String string4 = fromElement.getTableAlias();
        FromClause fromClause = fromElement.getFromClause();
        FromElement fromElement2 = fromClause.findCollectionJoin(string2 = fromReferenceNode.getPath());
        if (fromElement2 == null) {
            fromElementFactory = new FromElementFactory(fromClause, fromElement, string2);
            fromElement2 = fromElementFactory.createCollectionElementsJoin(queryableCollection, string4);
            LOG.debugf("No FROM element found for the elements of collection join path %s, created %s", (Object)string2, (Object)fromElement2);
        } else {
            LOG.debugf("FROM element found for collection join path %s", (Object)string2);
        }
        this.setFromElement(fromElement);
        fromElementFactory = fromReferenceNode.getNextSibling();
        if (fromElementFactory == null) {
            throw new QueryException("No index value!");
        }
        String string5 = string4;
        if (fromElement2.getCollectionTableAlias() != null) {
            string5 = fromElement2.getCollectionTableAlias();
        }
        JoinSequence joinSequence = fromElement.getJoinSequence();
        String[] stringArray = queryableCollection.getIndexColumnNames();
        if (stringArray.length != 1) {
            throw new QueryException("composite-index appears in []: " + fromReferenceNode.getPath());
        }
        SqlGenerator sqlGenerator = new SqlGenerator(this.getSessionFactoryHelper().getFactory());
        try {
            sqlGenerator.simpleExpr((AST)fromElementFactory);
        }
        catch (RecognitionException recognitionException) {
            throw new QueryException(recognitionException.getMessage(), recognitionException);
        }
        String string6 = sqlGenerator.getSQL();
        joinSequence.addCondition(string5 + '.' + stringArray[0] + " = " + string6);
        List<ParameterSpecification> list = sqlGenerator.getCollectedParameters();
        if (list != null) {
            switch (list.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    object = list.get(0);
                    object.setExpectedType(queryableCollection.getIndexType());
                    fromElement.setIndexCollectionSelectorParamSpec((ParameterSpecification)object);
                    break;
                }
                default: {
                    fromElement.setIndexCollectionSelectorParamSpec(new AggregatedIndexCollectionSelectorParameterSpecifications(list));
                }
            }
        }
        object = queryableCollection.getElementColumnNames(string4);
        this.setText(object[0]);
        this.setResolved();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AggregatedIndexCollectionSelectorParameterSpecifications
    implements ParameterSpecification {
        private final List<ParameterSpecification> paramSpecs;

        public AggregatedIndexCollectionSelectorParameterSpecifications(List<ParameterSpecification> list) {
            this.paramSpecs = list;
        }

        @Override
        public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
            int n2 = 0;
            for (ParameterSpecification parameterSpecification : this.paramSpecs) {
                n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n + n2);
            }
            return n2;
        }

        @Override
        public Type getExpectedType() {
            return null;
        }

        @Override
        public void setExpectedType(Type type) {
        }

        @Override
        public String renderDisplayInfo() {
            return "index-selector [" + this.collectDisplayInfo() + "]";
        }

        private String collectDisplayInfo() {
            StringBuilder stringBuilder = new StringBuilder();
            for (ParameterSpecification parameterSpecification : this.paramSpecs) {
                stringBuilder.append(parameterSpecification.renderDisplayInfo());
            }
            return stringBuilder.toString();
        }
    }
}

