/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.io.Serializable;
import java.util.ArrayList;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.hql.internal.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.LiteralNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class InLogicOperatorNode
extends BinaryLogicOperatorNode
implements BinaryOperatorNode {
    public Node getInList() {
        return this.getRightHandOperand();
    }

    public void initialize() throws SemanticException {
        Object object;
        Serializable serializable;
        Node node = this.getLeftHandOperand();
        if (node == null) {
            throw new SemanticException("left-hand operand of in operator was null");
        }
        Node node2 = this.getInList();
        if (node2 == null) {
            throw new SemanticException("right-hand operand of in operator was null");
        }
        if (SqlNode.class.isAssignableFrom(((Object)((Object)node)).getClass())) {
            serializable = ((SqlNode)node).getDataType();
            for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (!ExpectedTypeAwareNode.class.isAssignableFrom(object.getClass())) continue;
                ((ExpectedTypeAwareNode)object).setExpectedType((Type)serializable);
            }
        }
        if ((serializable = this.getSessionFactoryHelper().getFactory()).getDialect().supportsRowValueConstructorSyntaxInInList()) {
            return;
        }
        object = this.extractDataType(node);
        if (object == null) {
            return;
        }
        int n = object.getColumnSpan((Mapping)((Object)serializable));
        Node node3 = (Node)node2.getFirstChild();
        if (!this.isNodeAcceptable(node3)) {
            return;
        }
        int n2 = 0;
        if (node3 == null) {
            return;
        }
        if (node3.getType() == 95) {
            n2 = node3.getNumberOfChildren();
        } else {
            Type type = this.extractDataType(node3);
            if (type == null) {
                return;
            }
            n2 = type.getColumnSpan((Mapping)((Object)serializable));
        }
        if (n > 1 && n2 > 1) {
            this.mutateRowValueConstructorSyntaxInInListSyntax(n, n2);
        }
    }

    private boolean isNodeAcceptable(Node node) {
        return node == null || node instanceof LiteralNode || node instanceof ParameterNode || node.getType() == 95;
    }

    private void mutateRowValueConstructorSyntaxInInListSyntax(int n, int n2) {
        Node node;
        boolean bl;
        String[] stringArray = InLogicOperatorNode.extractMutationTexts(this.getLeftHandOperand(), n);
        ParameterSpecification parameterSpecification = this.getLeftHandOperand() == null || !ParameterNode.class.isInstance((Object)this.getLeftHandOperand()) ? null : ((ParameterNode)this.getLeftHandOperand()).getHqlParameterSpecification();
        boolean bl2 = bl = this.getType() == 86;
        if (node != null && node.getNextSibling() == null) {
            String[] stringArray2 = InLogicOperatorNode.extractMutationTexts(node, n2);
            this.setType(bl ? 40 : 6);
            this.setText(bl ? "or" : "and");
            ParameterSpecification parameterSpecification2 = node == null || !ParameterNode.class.isInstance((Object)node) ? null : ((ParameterNode)node).getHqlParameterSpecification();
            this.translate(n, bl ? 112 : 105, bl ? "<>" : "=", stringArray, stringArray2, parameterSpecification, parameterSpecification2, (AST)this);
        } else {
            ParameterSpecification parameterSpecification3;
            Object object;
            ArrayList<AST> arrayList = new ArrayList<AST>();
            for (node = (Node)this.getInList().getFirstChild(); node != null; node = (Node)node.getNextSibling()) {
                object = InLogicOperatorNode.extractMutationTexts(node, n2);
                AST aST = this.getASTFactory().create(bl ? 40 : 6, bl ? "or" : "and");
                parameterSpecification3 = node == null || !ParameterNode.class.isInstance((Object)node) ? null : ((ParameterNode)node).getHqlParameterSpecification();
                this.translate(n, bl ? 112 : 105, bl ? "<>" : "=", stringArray, (String[])object, parameterSpecification, parameterSpecification3, aST);
                arrayList.add(aST);
            }
            this.setType(bl ? 6 : 40);
            this.setText(bl ? "and" : "or");
            object = this;
            for (int i = arrayList.size() - 1; i > 1; --i) {
                parameterSpecification3 = this.getASTFactory().create(bl ? 6 : 40, bl ? "and" : "or");
                object.setFirstChild((AST)parameterSpecification3);
                object = parameterSpecification3;
                AST aST = (AST)arrayList.get(i);
                parameterSpecification3.setNextSibling(aST);
            }
            AST aST = (AST)arrayList.get(0);
            parameterSpecification3 = (AST)arrayList.get(1);
            aST.setNextSibling((AST)parameterSpecification3);
            object.setFirstChild(aST);
        }
    }
}

