/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.hql.internal.ast.tree.DotNode;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromElementFactory;
import org.hibernate.hql.internal.ast.tree.FromReferenceNode;
import org.hibernate.hql.internal.ast.tree.SelectExpression;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class IdentNode
extends FromReferenceNode
implements SelectExpression {
    private static final int UNKNOWN = 0;
    private static final int PROPERTY_REF = 1;
    private static final int COMPONENT_REF = 2;
    private boolean nakedPropertyRef = false;

    public void resolveIndex(AST aST) throws SemanticException {
        if (!this.isResolved() || !this.nakedPropertyRef) {
            throw new UnsupportedOperationException();
        }
        String string = this.getOriginalText();
        if (!this.getDataType().isCollectionType()) {
            throw new SemanticException("Collection expected; [" + string + "] does not refer to a collection property");
        }
        CollectionType collectionType = (CollectionType)this.getDataType();
        String string2 = collectionType.getRole();
        QueryableCollection queryableCollection = this.getSessionFactoryHelper().requireQueryableCollection(string2);
        String string3 = null;
        String string4 = this.getFromElement().getTableAlias();
        JoinType joinType = JoinType.INNER_JOIN;
        boolean bl = false;
        FromElementFactory fromElementFactory = new FromElementFactory(this.getWalker().getCurrentFromClause(), this.getFromElement(), string, string3, this.getFromElement().toColumns(string4, string, false), true);
        FromElement fromElement = fromElementFactory.createCollection(queryableCollection, string2, joinType, bl, true);
        this.setFromElement(fromElement);
        this.getWalker().addQuerySpaces(queryableCollection.getCollectionSpaces());
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) {
        if (!this.isResolved()) {
            if (this.getWalker().getCurrentFromClause().isFromElementAlias(this.getText())) {
                if (this.resolveAsAlias()) {
                    this.setResolved();
                }
            } else if (aST != null && aST.getType() == 15) {
                DotNode dotNode = (DotNode)aST;
                if (aST.getFirstChild() == this) {
                    if (this.resolveAsNakedComponentPropertyRefLHS(dotNode)) {
                        this.setResolved();
                    }
                } else if (this.resolveAsNakedComponentPropertyRefRHS(dotNode)) {
                    this.setResolved();
                }
            } else {
                int n = this.resolveAsNakedPropertyRef();
                if (n == 1) {
                    this.setResolved();
                } else if (n == 2) {
                    return;
                }
            }
            if (!this.isResolved()) {
                try {
                    this.getWalker().getLiteralProcessor().processConstant((AST)this, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private boolean resolveAsAlias() {
        boolean bl;
        FromElement fromElement = this.getWalker().getCurrentFromClause().getFromElement(this.getText());
        if (fromElement == null) {
            return false;
        }
        this.setType(143);
        this.setFromElement(fromElement);
        String[] stringArray = fromElement.getIdentityColumns();
        if (!this.isFromElementUpdateOrDeleteRoot(fromElement) && StringHelper.isNotEmpty(fromElement.getTableAlias())) {
            stringArray = StringHelper.qualifyIfNot(fromElement.getTableAlias(), stringArray);
        }
        boolean bl2 = this.getWalker().isInCount() && !this.getWalker().isInCountDistinct();
        boolean bl3 = bl = stringArray.length > 1;
        if (bl) {
            if (bl2 && !this.getWalker().getSessionFactoryHelper().getFactory().getDialect().supportsTupleCounts()) {
                this.setText(stringArray[0]);
            } else {
                boolean bl4;
                String string = StringHelper.join(", ", stringArray);
                boolean bl5 = bl4 = this.getWalker().isInCount() || this.getWalker().getCurrentTopLevelClauseType() == 41 || this.getWalker().getCurrentTopLevelClauseType() == 24;
                if (!bl4) {
                    string = "(" + string + ")";
                }
                this.setText(string);
            }
            return true;
        }
        if (stringArray.length > 0) {
            this.setText(stringArray[0]);
            return true;
        }
        return false;
    }

    private Type getNakedPropertyType(FromElement fromElement) {
        if (fromElement == null) {
            return null;
        }
        String string = this.getOriginalText();
        Type type = null;
        try {
            type = fromElement.getPropertyType(string, string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return type;
    }

    private int resolveAsNakedPropertyRef() {
        FromElement fromElement = this.locateSingleFromElement();
        if (fromElement == null) {
            return 0;
        }
        Queryable queryable = fromElement.getQueryable();
        if (queryable == null) {
            return 0;
        }
        Type type = this.getNakedPropertyType(fromElement);
        if (type == null) {
            return 0;
        }
        if (type.isComponentType() || type.isAssociationType()) {
            return 2;
        }
        this.setFromElement(fromElement);
        String string = this.getText();
        String[] stringArray = this.getWalker().isSelectStatement() ? queryable.toColumns(fromElement.getTableAlias(), string) : queryable.toColumns(string);
        String string2 = StringHelper.join(", ", stringArray);
        this.setText(stringArray.length == 1 ? string2 : "(" + string2 + ")");
        this.setType(145);
        super.setDataType(type);
        this.nakedPropertyRef = true;
        return 1;
    }

    private boolean resolveAsNakedComponentPropertyRefLHS(DotNode dotNode) {
        FromElement fromElement = this.locateSingleFromElement();
        if (fromElement == null) {
            return false;
        }
        Type type = this.getNakedPropertyType(fromElement);
        if (type == null) {
            throw new QueryException("Unable to resolve path [" + dotNode.getPath() + "], unexpected token [" + this.getOriginalText() + "]");
        }
        if (!type.isComponentType()) {
            throw new QueryException("Property '" + this.getOriginalText() + "' is not a component.  Use an alias to reference associations or collections.");
        }
        Type type2 = null;
        String string = this.getText() + "." + this.getNextSibling().getText();
        try {
            type2 = fromElement.getPropertyType(this.getText(), string);
        }
        catch (Throwable throwable) {
            return false;
        }
        this.setFromElement(fromElement);
        dotNode.setPropertyPath(string);
        dotNode.setDataType(type2);
        return true;
    }

    private boolean resolveAsNakedComponentPropertyRefRHS(DotNode dotNode) {
        FromElement fromElement = this.locateSingleFromElement();
        if (fromElement == null) {
            return false;
        }
        Type type = null;
        String string = dotNode.getLhs().getText() + "." + this.getText();
        try {
            type = fromElement.getPropertyType(this.getText(), string);
        }
        catch (Throwable throwable) {
            return false;
        }
        this.setFromElement(fromElement);
        super.setDataType(type);
        this.nakedPropertyRef = true;
        return true;
    }

    private FromElement locateSingleFromElement() {
        List list = this.getWalker().getCurrentFromClause().getFromElements();
        if (list == null || list.size() != 1) {
            return null;
        }
        FromElement fromElement = (FromElement)list.get(0);
        if (fromElement.getClassAlias() != null) {
            return null;
        }
        return fromElement;
    }

    public Type getDataType() {
        Type type = super.getDataType();
        if (type != null) {
            return type;
        }
        FromElement fromElement = this.getFromElement();
        if (fromElement != null) {
            return fromElement.getDataType();
        }
        SQLFunction sQLFunction = this.getWalker().getSessionFactoryHelper().findSQLFunction(this.getText());
        if (sQLFunction != null) {
            return sQLFunction.getReturnType(null, this.getWalker().getSessionFactoryHelper().getFactory());
        }
        return null;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        if (this.nakedPropertyRef) {
            ColumnHelper.generateSingleScalarColumn(this, n);
        } else {
            FromElement fromElement = this.getFromElement();
            if (fromElement != null) {
                this.setText(fromElement.renderScalarIdentifierSelect(n));
            } else {
                ColumnHelper.generateSingleScalarColumn(this, n);
            }
        }
    }

    public String getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getType() == 143) {
            stringBuilder.append("{alias=").append(this.getOriginalText());
            if (this.getFromElement() == null) {
                stringBuilder.append(", no from element");
            } else {
                stringBuilder.append(", className=").append(this.getFromElement().getClassName());
                stringBuilder.append(", tableAlias=").append(this.getFromElement().getTableAlias());
            }
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{originalText=" + this.getOriginalText()).append("}");
        }
        return stringBuilder.toString();
    }
}

