/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.hql.internal.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.internal.ast.tree.DisplayableNode;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.InitializeableNode;
import org.hibernate.hql.internal.ast.tree.PathNode;
import org.hibernate.hql.internal.ast.tree.ResolvableNode;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public abstract class FromReferenceNode
extends AbstractSelectExpression
implements ResolvableNode,
DisplayableNode,
InitializeableNode,
PathNode {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, FromReferenceNode.class.getName());
    private FromElement fromElement;
    private boolean resolved = false;
    public static final int ROOT_LEVEL = 0;

    public FromElement getFromElement() {
        return this.fromElement;
    }

    public void setFromElement(FromElement fromElement) {
        this.fromElement = fromElement;
    }

    public void resolveFirstChild() throws SemanticException {
    }

    public String getPath() {
        return this.getOriginalText();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved() {
        this.resolved = true;
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Resolved : %s -> %s", (Object)this.getPath(), (Object)this.getText());
        }
    }

    public String getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{").append(this.fromElement == null ? "no fromElement" : this.fromElement.getDisplayText());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void recursiveResolve(int n, boolean bl, String string) throws SemanticException {
        this.recursiveResolve(n, bl, string, (AST)this);
    }

    public void recursiveResolve(int n, boolean bl, String string, AST aST) throws SemanticException {
        AST aST2 = this.getFirstChild();
        int n2 = n + 1;
        if (aST2 != null) {
            FromReferenceNode fromReferenceNode = (FromReferenceNode)aST2;
            fromReferenceNode.recursiveResolve(n2, bl, null, (AST)this);
        }
        this.resolveFirstChild();
        boolean bl2 = true;
        if (n == 0 && !bl) {
            bl2 = false;
        }
        this.resolve(true, bl2, string, aST);
    }

    public boolean isReturnableEntity() throws SemanticException {
        return !this.isScalar() && this.fromElement.isEntity();
    }

    public void resolveInFunctionCall(boolean bl, boolean bl2) throws SemanticException {
        this.resolve(bl, bl2);
    }

    public void resolve(boolean bl, boolean bl2) throws SemanticException {
        this.resolve(bl, bl2, null);
    }

    public void resolve(boolean bl, boolean bl2, String string) throws SemanticException {
        this.resolve(bl, bl2, string, null);
    }

    public void prepareForDot(String string) throws SemanticException {
    }

    public FromElement getImpliedJoin() {
        return null;
    }

    protected boolean isFromElementUpdateOrDeleteRoot(FromElement fromElement) {
        if (fromElement.getFromClause().getParentFromClause() != null) {
            return false;
        }
        return this.getWalker().getStatementType() == 13 || this.getWalker().getStatementType() == 51;
    }
}

