/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.hql.internal.CollectionProperties;
import org.hibernate.hql.internal.CollectionSubqueryFactory;
import org.hibernate.hql.internal.NameGenerator;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

class FromElementType {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, FromElementType.class.getName());
    private FromElement fromElement;
    private EntityType entityType;
    private EntityPersister persister;
    private QueryableCollection queryableCollection;
    private CollectionPropertyMapping collectionPropertyMapping;
    private JoinSequence joinSequence;
    private String collectionSuffix;
    private ParameterSpecification indexCollectionSelectorParamSpec;
    private static final List SPECIAL_MANY2MANY_TREATMENT_FUNCTION_NAMES = Arrays.asList("index", "minIndex", "maxIndex");

    public FromElementType(FromElement fromElement, EntityPersister entityPersister, EntityType entityType) {
        this.fromElement = fromElement;
        this.persister = entityPersister;
        this.entityType = entityType;
        if (entityPersister != null) {
            fromElement.setText(((Queryable)entityPersister).getTableName() + " " + this.getTableAlias());
        }
    }

    protected FromElementType(FromElement fromElement) {
        this.fromElement = fromElement;
    }

    private String getTableAlias() {
        return this.fromElement.getTableAlias();
    }

    private String getCollectionTableAlias() {
        return this.fromElement.getCollectionTableAlias();
    }

    public String getCollectionSuffix() {
        return this.collectionSuffix;
    }

    public void setCollectionSuffix(String string) {
        this.collectionSuffix = string;
    }

    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    public Type getDataType() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return null;
            }
            return this.queryableCollection.getType();
        }
        return this.entityType;
    }

    public Type getSelectType() {
        if (this.entityType == null) {
            return null;
        }
        boolean bl = this.fromElement.getFromClause().getWalker().isShallowQuery();
        return this.fromElement.getSessionFactoryHelper().getFactory().getTypeResolver().getTypeFactory().manyToOne(this.entityType.getAssociatedEntityName(), bl);
    }

    public Queryable getQueryable() {
        return this.persister instanceof Queryable ? (Queryable)this.persister : null;
    }

    String renderScalarIdentifierSelect(int n) {
        this.checkInitialized();
        String[] stringArray = this.getPropertyMapping("id").toColumns(this.getTableAlias(), "id");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string).append(" as ").append(NameGenerator.scalarName(n, i));
        }
        return stringBuilder.toString();
    }

    String renderIdentifierSelect(int n, int n2) {
        this.checkInitialized();
        if (this.fromElement.getFromClause().isSubQuery()) {
            String[] stringArray = this.persister != null ? ((Queryable)this.persister).getIdentifierColumnNames() : new String[]{};
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(this.fromElement.getTableAlias()).append('.').append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
        if (this.persister == null) {
            throw new QueryException("not an entity");
        }
        String string = ((Queryable)this.persister).identifierSelectFragment(this.getTableAlias(), this.getSuffix(n, n2));
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    private String getSuffix(int n, int n2) {
        return FromElementType.generateSuffix(n, n2);
    }

    private static String generateSuffix(int n, int n2) {
        String string = n == 1 ? "" : Integer.toString(n2) + '_';
        return string;
    }

    private void checkInitialized() {
        this.fromElement.checkInitialized();
    }

    String renderPropertySelect(int n, int n2, boolean bl) {
        this.checkInitialized();
        if (this.persister == null) {
            return "";
        }
        String string = ((Queryable)this.persister).propertySelectFragment(this.getTableAlias(), this.getSuffix(n, n2), bl);
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    String renderCollectionSelectFragment(int n, int n2) {
        if (this.queryableCollection == null) {
            return "";
        }
        if (this.collectionSuffix == null) {
            this.collectionSuffix = FromElementType.generateSuffix(n, n2);
        }
        String string = this.queryableCollection.selectFragment(this.getCollectionTableAlias(), this.collectionSuffix);
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    public String renderValueCollectionSelectFragment(int n, int n2) {
        if (this.queryableCollection == null) {
            return "";
        }
        if (this.collectionSuffix == null) {
            this.collectionSuffix = FromElementType.generateSuffix(n, n2);
        }
        String string = this.queryableCollection.selectFragment(this.getTableAlias(), this.collectionSuffix);
        return FromElementType.trimLeadingCommaAndSpaces(string);
    }

    private static String trimLeadingCommaAndSpaces(String string) {
        if (string.length() > 0 && string.charAt(0) == ',') {
            string = string.substring(1);
        }
        string = string.trim();
        return string.trim();
    }

    public void setJoinSequence(JoinSequence joinSequence) {
        this.joinSequence = joinSequence;
    }

    public JoinSequence getJoinSequence() {
        if (this.joinSequence != null) {
            return this.joinSequence;
        }
        if (this.persister instanceof Joinable) {
            Joinable joinable = (Joinable)((Object)this.persister);
            return this.fromElement.getSessionFactoryHelper().createJoinSequence().setRoot(joinable, this.getTableAlias());
        }
        return null;
    }

    public void setQueryableCollection(QueryableCollection queryableCollection) {
        if (this.queryableCollection != null) {
            throw new IllegalStateException("QueryableCollection is already defined for " + this + "!");
        }
        this.queryableCollection = queryableCollection;
        if (!queryableCollection.isOneToMany()) {
            this.fromElement.setText(queryableCollection.getTableName() + " " + this.getTableAlias());
        }
    }

    public QueryableCollection getQueryableCollection() {
        return this.queryableCollection;
    }

    public Type getPropertyType(String string, String string2) {
        this.checkInitialized();
        Type type = null;
        if (this.persister != null && string.equals(string2) && string.equals(this.persister.getIdentifierPropertyName())) {
            type = this.persister.getIdentifierType();
        } else {
            PropertyMapping propertyMapping = this.getPropertyMapping(string);
            type = propertyMapping.toType(string2);
        }
        if (type == null) {
            throw new MappingException("Property " + string + " does not exist in " + (this.queryableCollection == null ? "class" : "collection") + " " + (this.queryableCollection == null ? this.fromElement.getClassName() : this.queryableCollection.getRole()));
        }
        return type;
    }

    String[] toColumns(String string, String string2, boolean bl) {
        return this.toColumns(string, string2, bl, false);
    }

    String[] toColumns(String string, String string2, boolean bl, boolean bl2) {
        this.checkInitialized();
        PropertyMapping propertyMapping = this.getPropertyMapping(string2);
        if (!bl && this.queryableCollection != null && CollectionProperties.isCollectionProperty(string2)) {
            Map map = this.fromElement.getWalker().getEnabledFilters();
            String string3 = CollectionSubqueryFactory.createCollectionSubquery(this.joinSequence.copy().setUseThetaStyle(true), map, propertyMapping.toColumns(string, string2));
            LOG.debugf("toColumns(%s,%s) : subquery = %s", (Object)string, (Object)string2, (Object)string3);
            return new String[]{"(" + string3 + ")"};
        }
        if (bl2) {
            return propertyMapping.toColumns(string, string2);
        }
        if (this.fromElement.getWalker().getStatementType() == 45) {
            return propertyMapping.toColumns(string, string2);
        }
        if (this.fromElement.getWalker().getCurrentClauseType() == 45) {
            return propertyMapping.toColumns(string, string2);
        }
        if (this.fromElement.getWalker().isSubQuery()) {
            if (this.isCorrelation()) {
                if (this.isMultiTable()) {
                    return propertyMapping.toColumns(string, string2);
                }
                return propertyMapping.toColumns(this.extractTableName(), string2);
            }
            return propertyMapping.toColumns(string, string2);
        }
        if (this.isManipulationQuery() && this.isMultiTable() && this.inWhereClause()) {
            return propertyMapping.toColumns(string, string2);
        }
        Object[] objectArray = propertyMapping.toColumns(string2);
        LOG.tracev("Using non-qualified column reference [{0} -> ({1})]", (Object)string2, (Object)ArrayHelper.toString(objectArray));
        return objectArray;
    }

    private boolean isCorrelation() {
        FromClause fromClause = this.fromElement.getWalker().getFinalFromClause();
        return this.fromElement.getFromClause() != this.fromElement.getWalker().getCurrentFromClause() && this.fromElement.getFromClause() == fromClause;
    }

    private boolean isMultiTable() {
        return this.fromElement.getQueryable() != null && this.fromElement.getQueryable().isMultiTable();
    }

    private String extractTableName() {
        return this.fromElement.getQueryable().getTableName();
    }

    private boolean isManipulationQuery() {
        return this.fromElement.getWalker().getStatementType() == 51 || this.fromElement.getWalker().getStatementType() == 13;
    }

    private boolean inWhereClause() {
        return this.fromElement.getWalker().getCurrentTopLevelClauseType() == 53;
    }

    PropertyMapping getPropertyMapping(String string) {
        this.checkInitialized();
        if (this.queryableCollection == null) {
            return (PropertyMapping)((Object)this.persister);
        }
        if (this.queryableCollection.isManyToMany() && this.queryableCollection.hasIndex() && SPECIAL_MANY2MANY_TREATMENT_FUNCTION_NAMES.contains(string)) {
            return new SpecialManyToManyCollectionPropertyMapping();
        }
        if (CollectionProperties.isCollectionProperty(string)) {
            if (this.collectionPropertyMapping == null) {
                this.collectionPropertyMapping = new CollectionPropertyMapping(this.queryableCollection);
            }
            return this.collectionPropertyMapping;
        }
        if (this.queryableCollection.getElementType().isAnyType()) {
            return this.queryableCollection;
        }
        if (this.queryableCollection.getElementType().isComponentType() && string.equals("id")) {
            return (PropertyMapping)((Object)this.queryableCollection.getOwnerEntityPersister());
        }
        return this.queryableCollection;
    }

    public boolean isCollectionOfValuesOrComponents() {
        return this.persister == null && this.queryableCollection != null && !this.queryableCollection.getElementType().isEntityType();
    }

    public boolean isEntity() {
        return this.persister != null;
    }

    public ParameterSpecification getIndexCollectionSelectorParamSpec() {
        return this.indexCollectionSelectorParamSpec;
    }

    public void setIndexCollectionSelectorParamSpec(ParameterSpecification parameterSpecification) {
        this.indexCollectionSelectorParamSpec = parameterSpecification;
    }

    private class SpecialManyToManyCollectionPropertyMapping
    implements PropertyMapping {
        private SpecialManyToManyCollectionPropertyMapping() {
        }

        public Type getType() {
            return FromElementType.this.queryableCollection.getCollectionType();
        }

        private void validate(String string) {
            if (!("index".equals(string) || "maxIndex".equals(string) || "minIndex".equals(string))) {
                throw new IllegalArgumentException("Expecting index-related function call");
            }
        }

        public Type toType(String string) throws QueryException {
            this.validate(string);
            return FromElementType.this.queryableCollection.getIndexType();
        }

        public String[] toColumns(String string, String string2) throws QueryException {
            this.validate(string2);
            String string3 = FromElementType.this.joinSequence.getFirstJoin().getAlias();
            if ("index".equals(string2)) {
                return FromElementType.this.queryableCollection.toColumns(string3, string2);
            }
            String[] stringArray = FromElementType.this.queryableCollection.getIndexColumnNames(string3);
            if ("minIndex".equals(string2)) {
                if (stringArray.length != 1) {
                    throw new QueryException("composite collection index in minIndex()");
                }
                return new String[]{"min(" + stringArray[0] + ')'};
            }
            if (stringArray.length != 1) {
                throw new QueryException("composite collection index in maxIndex()");
            }
            return new String[]{"max(" + stringArray[0] + ')'};
        }

        public String[] toColumns(String string) throws QueryException, UnsupportedOperationException {
            this.validate(string);
            return FromElementType.this.queryableCollection.toColumns(string);
        }
    }
}

