/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.tree.DisplayableNode;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromElementFactory;
import org.hibernate.hql.internal.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.internal.ast.util.ASTIterator;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class FromClause
extends HqlSqlWalkerNode
implements HqlSqlTokenTypes,
DisplayableNode {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, FromClause.class.getName());
    public static final int ROOT_LEVEL = 1;
    private int level = 1;
    private Set fromElements = new HashSet();
    private Map fromElementByClassAlias = new HashMap();
    private Map fromElementByTableAlias = new HashMap();
    private Map fromElementsByPath = new HashMap();
    private Map collectionJoinFromElementsByPath = new HashMap();
    private FromClause parentFromClause;
    private Set childFromClauses;
    private int fromElementCounter = 0;
    private List impliedElements = new LinkedList();
    private static ASTUtil.FilterPredicate fromElementPredicate = new ASTUtil.IncludePredicate(){

        public boolean include(AST aST) {
            FromElement fromElement = (FromElement)aST;
            return fromElement.isFromOrJoinFragment();
        }
    };
    private static ASTUtil.FilterPredicate projectionListPredicate = new ASTUtil.IncludePredicate(){

        public boolean include(AST aST) {
            FromElement fromElement = (FromElement)aST;
            return fromElement.inProjectionList();
        }
    };
    private static ASTUtil.FilterPredicate collectionFetchPredicate = new ASTUtil.IncludePredicate(){

        public boolean include(AST aST) {
            FromElement fromElement = (FromElement)aST;
            return fromElement.isFetch() && fromElement.getQueryableCollection() != null;
        }
    };
    private static ASTUtil.FilterPredicate explicitFromPredicate = new ASTUtil.IncludePredicate(){

        public boolean include(AST aST) {
            FromElement fromElement = (FromElement)aST;
            return !fromElement.isImplied();
        }
    };

    public FromElement addFromElement(String string, AST aST) throws SemanticException {
        String string2 = aST == null ? null : aST.getText();
        this.checkForDuplicateClassAlias(string2);
        FromElementFactory fromElementFactory = new FromElementFactory(this, null, string, string2, null, false);
        return fromElementFactory.addFromElement();
    }

    void registerFromElement(FromElement fromElement) {
        String string;
        this.fromElements.add(fromElement);
        String string2 = fromElement.getClassAlias();
        if (string2 != null) {
            this.fromElementByClassAlias.put(string2, fromElement);
        }
        if ((string = fromElement.getTableAlias()) != null) {
            this.fromElementByTableAlias.put(string, fromElement);
        }
    }

    void addDuplicateAlias(String string, FromElement fromElement) {
        if (string != null) {
            this.fromElementByClassAlias.put(string, fromElement);
        }
    }

    private void checkForDuplicateClassAlias(String string) throws SemanticException {
        if (string != null && this.fromElementByClassAlias.containsKey(string)) {
            throw new SemanticException("Duplicate definition of alias '" + string + "'");
        }
    }

    public FromElement getFromElement(String string) {
        FromElement fromElement = (FromElement)this.fromElementByClassAlias.get(string);
        if (fromElement == null && this.getSessionFactoryHelper().isStrictJPAQLComplianceEnabled()) {
            fromElement = this.findIntendedAliasedFromElementBasedOnCrazyJPARequirements(string);
        }
        if (fromElement == null && this.parentFromClause != null) {
            fromElement = this.parentFromClause.getFromElement(string);
        }
        return fromElement;
    }

    public FromElement findFromElementBySqlAlias(String string) {
        FromElement fromElement = (FromElement)this.fromElementByTableAlias.get(string);
        if (fromElement == null && this.parentFromClause != null) {
            fromElement = this.parentFromClause.getFromElement(string);
        }
        return fromElement;
    }

    public FromElement findFromElementByUserOrSqlAlias(String string, String string2) {
        FromElement fromElement = null;
        if (string != null) {
            fromElement = this.getFromElement(string);
        }
        if (fromElement == null) {
            fromElement = this.findFromElementBySqlAlias(string2);
        }
        return fromElement;
    }

    private FromElement findIntendedAliasedFromElementBasedOnCrazyJPARequirements(String string) {
        for (Map.Entry entry : this.fromElementByClassAlias.entrySet()) {
            String string2 = (String)entry.getKey();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (FromElement)entry.getValue();
        }
        return null;
    }

    public boolean isFromElementAlias(String string) {
        boolean bl = this.containsClassAlias(string);
        if (!bl && this.parentFromClause != null) {
            bl = this.parentFromClause.isFromElementAlias(string);
        }
        return bl;
    }

    public List getFromElements() {
        return ASTUtil.collectChildren((AST)this, fromElementPredicate);
    }

    public FromElement getFromElement() {
        return (FromElement)this.getFromElements().get(0);
    }

    public List getProjectionList() {
        return ASTUtil.collectChildren((AST)this, projectionListPredicate);
    }

    public List getCollectionFetches() {
        return ASTUtil.collectChildren((AST)this, collectionFetchPredicate);
    }

    public boolean hasCollectionFecthes() {
        return this.getCollectionFetches().size() > 0;
    }

    public List getExplicitFromElements() {
        return ASTUtil.collectChildren((AST)this, explicitFromPredicate);
    }

    FromElement findCollectionJoin(String string) {
        return (FromElement)this.collectionJoinFromElementsByPath.get(string);
    }

    FromElement findJoinByPath(String string) {
        FromElement fromElement = this.findJoinByPathLocal(string);
        if (fromElement == null && this.parentFromClause != null) {
            fromElement = this.parentFromClause.findJoinByPath(string);
        }
        return fromElement;
    }

    FromElement findJoinByPathLocal(String string) {
        Map map = this.fromElementsByPath;
        return (FromElement)map.get(string);
    }

    void addJoinByPathMap(String string, FromElement fromElement) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("addJoinByPathMap() : %s -> %s", (Object)string, (Object)fromElement.getDisplayText());
        }
        this.fromElementsByPath.put(string, fromElement);
    }

    public boolean containsClassAlias(String string) {
        boolean bl = this.fromElementByClassAlias.containsKey(string);
        if (!bl && this.getSessionFactoryHelper().isStrictJPAQLComplianceEnabled()) {
            bl = this.findIntendedAliasedFromElementBasedOnCrazyJPARequirements(string) != null;
        }
        return bl;
    }

    public boolean containsTableAlias(String string) {
        return this.fromElementByTableAlias.keySet().contains(string);
    }

    public String getDisplayText() {
        return "FromClause{level=" + this.level + ", fromElementCounter=" + this.fromElementCounter + ", fromElements=" + this.fromElements.size() + ", fromElementByClassAlias=" + this.fromElementByClassAlias.keySet() + ", fromElementByTableAlias=" + this.fromElementByTableAlias.keySet() + ", fromElementsByPath=" + this.fromElementsByPath.keySet() + ", collectionJoinFromElementsByPath=" + this.collectionJoinFromElementsByPath.keySet() + ", impliedElements=" + this.impliedElements + "}";
    }

    public void setParentFromClause(FromClause fromClause) {
        this.parentFromClause = fromClause;
        if (fromClause != null) {
            this.level = fromClause.getLevel() + 1;
            fromClause.addChild(this);
        }
    }

    private void addChild(FromClause fromClause) {
        if (this.childFromClauses == null) {
            this.childFromClauses = new HashSet();
        }
        this.childFromClauses.add(fromClause);
    }

    public FromClause locateChildFromClauseWithJoinByPath(String string) {
        if (this.childFromClauses != null && !this.childFromClauses.isEmpty()) {
            for (FromClause fromClause : this.childFromClauses) {
                if (fromClause.findJoinByPathLocal(string) == null) continue;
                return fromClause;
            }
        }
        return null;
    }

    public void promoteJoin(FromElement fromElement) {
        LOG.debugf("Promoting [%s] to [%s]", (Object)fromElement, (Object)this);
    }

    public boolean isSubQuery() {
        return this.parentFromClause != null;
    }

    void addCollectionJoinFromElementByPath(String string, FromElement fromElement) {
        LOG.debugf("addCollectionJoinFromElementByPath() : %s -> %s", (Object)string, (Object)fromElement);
        this.collectionJoinFromElementsByPath.put(string, fromElement);
    }

    public FromClause getParentFromClause() {
        return this.parentFromClause;
    }

    public int getLevel() {
        return this.level;
    }

    public int nextFromElementCounter() {
        return this.fromElementCounter++;
    }

    public void resolve() {
        ASTIterator aSTIterator = new ASTIterator(this.getFirstChild());
        HashSet<Object> hashSet = new HashSet<Object>();
        while (aSTIterator.hasNext()) {
            hashSet.add(aSTIterator.next());
        }
        for (FromElement fromElement : this.fromElements) {
            if (hashSet.contains(fromElement)) continue;
            throw new IllegalStateException("Element not in AST: " + fromElement);
        }
    }

    public void addImpliedFromElement(FromElement fromElement) {
        this.impliedElements.add(fromElement);
    }

    public String toString() {
        return "FromClause{level=" + this.level + "}";
    }
}

