/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.QueryException;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.hql.internal.CollectionProperties;
import org.hibernate.hql.internal.ast.tree.ComponentJoin;
import org.hibernate.hql.internal.ast.tree.DisplayableNode;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromElementFactory;
import org.hibernate.hql.internal.ast.tree.FromReferenceNode;
import org.hibernate.hql.internal.ast.tree.IndexNode;
import org.hibernate.hql.internal.ast.tree.SelectExpression;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.JoinType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DotNode
extends FromReferenceNode
implements DisplayableNode,
SelectExpression {
    public static boolean useThetaStyleImplicitJoins = false;
    public static boolean REGRESSION_STYLE_JOIN_SUPPRESSION = false;
    public static final IllegalCollectionDereferenceExceptionBuilder DEF_ILLEGAL_COLL_DEREF_EXCP_BUILDER;
    public static IllegalCollectionDereferenceExceptionBuilder ILLEGAL_COLL_DEREF_EXCP_BUILDER;
    private static final CoreMessageLogger LOG;
    private static final int DEREF_UNKNOWN = 0;
    private static final int DEREF_ENTITY = 1;
    private static final int DEREF_COMPONENT = 2;
    private static final int DEREF_COLLECTION = 3;
    private static final int DEREF_PRIMITIVE = 4;
    private static final int DEREF_IDENTIFIER = 5;
    private static final int DEREF_JAVA_CONSTANT = 6;
    private String propertyName;
    private String path;
    private String propertyPath;
    private String[] columns;
    private JoinType joinType = JoinType.INNER_JOIN;
    private boolean fetch = false;
    private int dereferenceType = 0;
    private FromElement impliedJoin;

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    private String[] getColumns() throws QueryException {
        if (this.columns == null) {
            String string = this.getLhs().getFromElement().getTableAlias();
            this.columns = this.getFromElement().toColumns(string, this.propertyPath, false);
        }
        return this.columns;
    }

    public String getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        FromElement fromElement = this.getFromElement();
        stringBuilder.append("{propertyName=").append(this.propertyName);
        stringBuilder.append(",dereferenceType=").append(this.getWalker().getASTPrinter().getTokenTypeName(this.dereferenceType));
        stringBuilder.append(",propertyPath=").append(this.propertyPath);
        stringBuilder.append(",path=").append(this.getPath());
        if (fromElement != null) {
            stringBuilder.append(",tableAlias=").append(fromElement.getTableAlias());
            stringBuilder.append(",className=").append(fromElement.getClassName());
            stringBuilder.append(",classAlias=").append(fromElement.getClassAlias());
        } else {
            stringBuilder.append(",no from element");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void resolveFirstChild() throws SemanticException {
        String string;
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        SqlNode sqlNode = (SqlNode)fromReferenceNode.getNextSibling();
        this.propertyName = string = sqlNode.getText();
        if (this.propertyPath == null) {
            this.propertyPath = string;
        }
        fromReferenceNode.resolve(true, true, null, (AST)this);
        this.setFromElement(fromReferenceNode.getFromElement());
        this.checkSubclassOrSuperclassPropertyReference(fromReferenceNode, string);
    }

    public void resolveInFunctionCall(boolean bl, boolean bl2) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type type = this.prepareLhs();
        if (type != null && type.isCollectionType()) {
            this.resolveIndex(null);
        } else {
            this.resolveFirstChild();
            super.resolve(bl, bl2);
        }
    }

    public void resolveIndex(AST aST) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type type = this.prepareLhs();
        this.dereferenceCollection((CollectionType)type, true, true, null, aST);
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        if (this.isResolved()) {
            return;
        }
        Type type = this.prepareLhs();
        if (type == null) {
            if (aST == null) {
                this.getWalker().getLiteralProcessor().lookupConstant(this);
            }
            return;
        }
        if (type.isComponentType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceComponent(aST);
            this.initText();
        } else if (type.isEntityType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceEntity((EntityType)type, bl2, string, bl, aST);
            this.initText();
        } else if (type.isCollectionType()) {
            this.checkLhsIsNotCollection();
            this.dereferenceCollection((CollectionType)type, bl2, false, string, aST);
        } else {
            if (!CollectionProperties.isAnyCollectionProperty(this.propertyName)) {
                this.checkLhsIsNotCollection();
            }
            this.dereferenceType = 4;
            this.initText();
        }
        this.setResolved();
    }

    private void initText() {
        String[] stringArray = this.getColumns();
        String string = StringHelper.join(", ", stringArray);
        if (stringArray.length > 1 && this.getWalker().isComparativeExpressionClause()) {
            string = "(" + string + ")";
        }
        this.setText(string);
    }

    private Type prepareLhs() throws SemanticException {
        FromReferenceNode fromReferenceNode = this.getLhs();
        fromReferenceNode.prepareForDot(this.propertyName);
        return this.getDataType();
    }

    private void dereferenceCollection(CollectionType collectionType, boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        EntityPersister entityPersister;
        Object object;
        boolean bl3;
        this.dereferenceType = 3;
        String string2 = collectionType.getRole();
        boolean bl4 = bl3 = this.getNextSibling() != null && CollectionProperties.isAnyCollectionProperty(this.getNextSibling().getText());
        if (bl3) {
            bl2 = true;
        }
        QueryableCollection queryableCollection = this.getSessionFactoryHelper().requireQueryableCollection(string2);
        String string3 = this.getPath();
        FromClause fromClause = this.getWalker().getCurrentFromClause();
        FromElement fromElement = this.getLhs().getFromElement();
        if (this.getWalker().getStatementType() != 45 && this.isFromElementUpdateOrDeleteRoot(fromElement)) {
            boolean bl5 = false;
            if (this.getWalker().getStatementType() != 29 && (object = fromElement.getQueryable()).isMultiTable()) {
                bl5 = true;
            }
            if (!bl5) {
                object = fromElement.getQueryable().getTableName();
                this.columns = this.getFromElement().toColumns((String)object, this.propertyPath, false, true);
            }
        }
        FromElementFactory fromElementFactory = new FromElementFactory(fromClause, this.getLhs().getFromElement(), string3, string, this.getColumns(), bl);
        object = fromElementFactory.createCollection(queryableCollection, string2, this.joinType, this.fetch, bl2);
        LOG.debugf("dereferenceCollection() : Created new FROM element for %s : %s", (Object)string3, object);
        this.setImpliedJoin((FromElement)object);
        this.setFromElement((FromElement)object);
        if (bl3) {
            ((SqlNode)((Object)object)).setText("");
            ((FromElement)object).setUseWhereFragment(false);
        }
        if (!bl && (entityPersister = ((FromElement)object).getEntityPersister()) != null) {
            this.getWalker().addQuerySpaces(entityPersister.getQuerySpaces());
        }
        this.getWalker().addQuerySpaces(queryableCollection.getCollectionSpaces());
    }

    private void dereferenceEntity(EntityType entityType, boolean bl, String string, boolean bl2, AST aST) throws SemanticException {
        boolean bl3;
        this.checkForCorrelatedSubquery("dereferenceEntity");
        DotNode dotNode = null;
        String string2 = this.propertyName;
        if (this.isDotNode(aST)) {
            dotNode = (DotNode)aST;
            string2 = dotNode.propertyName;
            bl3 = bl2 && !this.isReferenceToPrimaryKey(dotNode.propertyName, entityType);
        } else if (!this.getWalker().isSelectStatement()) {
            bl3 = this.getWalker().getCurrentStatementType() == 45 && this.getWalker().isInFrom();
        } else if (REGRESSION_STYLE_JOIN_SUPPRESSION) {
            bl3 = bl2 && (!this.getWalker().isInSelect() || !this.getWalker().isShallowQuery());
        } else {
            boolean bl4 = bl3 = bl2 || this.getWalker().isInSelect() || this.getWalker().isInFrom();
        }
        if (bl3) {
            this.dereferenceEntityJoin(string, entityType, bl, aST);
        } else {
            this.dereferenceEntityIdentifier(string2, dotNode);
        }
    }

    private boolean isDotNode(AST aST) {
        return aST != null && aST.getType() == 15;
    }

    private void dereferenceEntityJoin(String string, EntityType entityType, boolean bl, AST aST) throws SemanticException {
        boolean bl2;
        FromClause fromClause;
        FromElement fromElement;
        this.dereferenceType = 1;
        if (LOG.isDebugEnabled()) {
            LOG.debugf("dereferenceEntityJoin() : generating join for %s in %s (%s) parent = %s", this.propertyName, this.getFromElement().getClassName(), string == null ? "<no alias>" : string, ASTUtil.getDebugString(aST));
        }
        String string2 = entityType.getAssociatedEntityName();
        String string3 = this.getAliasGenerator().createName(string2);
        String[] stringArray = this.getColumns();
        String string4 = this.getPath();
        if (bl && this.getWalker().isInFrom()) {
            this.joinType = this.getWalker().getImpliedJoinType();
        }
        boolean bl3 = (fromElement = (fromClause = this.getWalker().getCurrentFromClause()).findJoinByPath(string4)) != null;
        boolean bl4 = bl2 = bl3 && (fromElement.isImplied() || this.areSame(string, fromElement.getClassAlias()));
        if (!bl2) {
            FromElement fromElement2;
            JoinSequence joinSequence = this.getSessionFactoryHelper().createJoinSequence(bl, entityType, string3, this.joinType, stringArray);
            for (fromElement2 = this.getLhs().getFromElement(); fromElement2 != null && ComponentJoin.class.isInstance(fromElement2); fromElement2 = fromElement2.getOrigin()) {
            }
            if (fromElement2 == null) {
                throw new QueryException("Unable to locate appropriate lhs");
            }
            FromElementFactory fromElementFactory = new FromElementFactory(fromClause, fromElement2, string4, string, stringArray, bl);
            fromElement = fromElementFactory.createEntityJoin(string2, string3, joinSequence, this.fetch, this.getWalker().isInFrom(), entityType);
        } else {
            fromClause.addDuplicateAlias(string, fromElement);
        }
        this.setImpliedJoin(fromElement);
        this.getWalker().addQuerySpaces(fromElement.getEntityPersister().getQuerySpaces());
        this.setFromElement(fromElement);
    }

    private boolean areSame(String string, String string2) {
        return !StringHelper.isEmpty(string) && !StringHelper.isEmpty(string2) && string.equals(string2);
    }

    private void setImpliedJoin(FromElement fromElement) {
        DotNode dotNode;
        this.impliedJoin = fromElement;
        if (this.getFirstChild().getType() == 15 && (dotNode = (DotNode)this.getFirstChild()).getImpliedJoin() != null) {
            this.impliedJoin = dotNode.getImpliedJoin();
        }
    }

    public FromElement getImpliedJoin() {
        return this.impliedJoin;
    }

    private boolean isReferenceToPrimaryKey(String string, EntityType entityType) {
        EntityPersister entityPersister = this.getSessionFactoryHelper().getFactory().getEntityPersister(entityType.getAssociatedEntityName());
        if (entityPersister.getEntityMetamodel().hasNonIdentifierPropertyNamedId()) {
            return string.equals(entityPersister.getIdentifierPropertyName()) && entityType.isReferenceToPrimaryKey();
        }
        if ("id".equals(string)) {
            return entityType.isReferenceToPrimaryKey();
        }
        String string2 = this.getSessionFactoryHelper().getIdentifierOrUniqueKeyPropertyName(entityType);
        return string2 != null && string2.equals(string) && entityType.isReferenceToPrimaryKey();
    }

    private void checkForCorrelatedSubquery(String string) {
        if (this.isCorrelatedSubselect()) {
            LOG.debugf("%s() : correlated subquery", (Object)string);
        }
    }

    private boolean isCorrelatedSubselect() {
        return this.getWalker().isSubQuery() && this.getFromElement().getFromClause() != this.getWalker().getCurrentFromClause();
    }

    private void checkLhsIsNotCollection() throws SemanticException {
        if (this.getLhs().getDataType() != null && this.getLhs().getDataType().isCollectionType()) {
            throw ILLEGAL_COLL_DEREF_EXCP_BUILDER.buildIllegalCollectionDereferenceException(this.propertyName, this.getLhs());
        }
    }

    private void dereferenceComponent(AST aST) {
        this.dereferenceType = 2;
        this.setPropertyNameAndPath(aST);
    }

    private void dereferenceEntityIdentifier(String string, DotNode dotNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("dereferenceShortcut() : property %s in %s does not require a join.", (Object)string, (Object)this.getFromElement().getClassName());
        }
        this.initText();
        this.setPropertyNameAndPath((AST)dotNode);
        if (dotNode != null) {
            dotNode.dereferenceType = 5;
            dotNode.setText(this.getText());
            dotNode.columns = this.getColumns();
        }
    }

    private void setPropertyNameAndPath(AST aST) {
        if (this.isDotNode(aST)) {
            DotNode dotNode = (DotNode)aST;
            AST aST2 = dotNode.getFirstChild();
            AST aST3 = aST2.getNextSibling();
            this.propertyName = aST3.getText();
            dotNode.propertyPath = this.propertyPath = this.propertyPath + "." + this.propertyName;
            LOG.debugf("Unresolved property path is now '%s'", (Object)dotNode.propertyPath);
        } else {
            LOG.debugf("Terminal propertyPath = [%s]", (Object)this.propertyPath);
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            FromElement fromElement = this.getLhs().getFromElement();
            if (fromElement == null) {
                return null;
            }
            Type type = fromElement.getPropertyType(this.propertyName, this.propertyPath);
            LOG.debugf("getDataType() : %s -> %s", (Object)this.propertyPath, (Object)type);
            super.setDataType(type);
        }
        return super.getDataType();
    }

    public void setPropertyPath(String string) {
        this.propertyPath = string;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public FromReferenceNode getLhs() {
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        if (fromReferenceNode == null) {
            throw new IllegalStateException("DOT node with no left-hand-side!");
        }
        return fromReferenceNode;
    }

    public String getPath() {
        if (this.path == null) {
            FromReferenceNode fromReferenceNode = this.getLhs();
            if (fromReferenceNode == null) {
                this.path = this.getText();
            } else {
                SqlNode sqlNode = (SqlNode)fromReferenceNode.getNextSibling();
                this.path = fromReferenceNode.getPath() + "." + sqlNode.getOriginalText();
            }
        }
        return this.path;
    }

    public void setFetch(boolean bl) {
        this.fetch = bl;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        String[] stringArray = this.getColumns();
        ColumnHelper.generateScalarColumns(this, stringArray, n);
    }

    public void resolveSelectExpression() throws SemanticException {
        Object object;
        if (this.getWalker().isShallowQuery() || this.getWalker().getCurrentFromClause().isSubQuery()) {
            this.resolve(false, true);
        } else {
            this.resolve(true, false);
            object = this.getDataType();
            if (object.isEntityType()) {
                FromElement fromElement = this.getFromElement();
                fromElement.setIncludeSubclasses(true);
                if (useThetaStyleImplicitJoins) {
                    fromElement.getJoinSequence().setUseThetaStyle(true);
                    FromElement fromElement2 = fromElement.getOrigin();
                    if (fromElement2 != null) {
                        ASTUtil.makeSiblingOfParent((AST)fromElement2, (AST)fromElement);
                    }
                }
            }
        }
        for (object = this.getLhs(); object != null; object = (FromReferenceNode)object.getFirstChild()) {
            this.checkSubclassOrSuperclassPropertyReference((FromReferenceNode)object, object.getNextSibling().getText());
        }
    }

    public void setResolvedConstant(String string) {
        this.path = string;
        this.dereferenceType = 6;
        this.setResolved();
    }

    private boolean checkSubclassOrSuperclassPropertyReference(FromReferenceNode fromReferenceNode, String string) {
        FromElement fromElement;
        if (fromReferenceNode != null && !(fromReferenceNode instanceof IndexNode) && (fromElement = fromReferenceNode.getFromElement()) != null) {
            fromElement.handlePropertyBeingDereferenced(fromReferenceNode.getDataType(), string);
        }
        return false;
    }

    static {
        ILLEGAL_COLL_DEREF_EXCP_BUILDER = DEF_ILLEGAL_COLL_DEREF_EXCP_BUILDER = new IllegalCollectionDereferenceExceptionBuilder(){

            public QueryException buildIllegalCollectionDereferenceException(String string, FromReferenceNode fromReferenceNode) {
                String string2 = ASTUtil.getPathText((AST)fromReferenceNode);
                return new QueryException("illegal attempt to dereference collection [" + string2 + "] with element property reference [" + string + "]");
            }
        };
        LOG = Logger.getMessageLogger(CoreMessageLogger.class, DotNode.class.getName());
    }

    public static interface IllegalCollectionDereferenceExceptionBuilder {
        public QueryException buildIllegalCollectionDereferenceException(String var1, FromReferenceNode var2);
    }
}

