/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.ast.DetailedSemanticException;
import org.hibernate.hql.internal.ast.tree.AggregatedSelectExpression;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.PathNode;
import org.hibernate.hql.internal.ast.tree.SelectExpression;
import org.hibernate.hql.internal.ast.tree.SelectExpressionList;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.transform.AliasToBeanConstructorResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;

public class ConstructorNode
extends SelectExpressionList
implements AggregatedSelectExpression {
    private Class resultType;
    private Constructor constructor;
    private Type[] constructorArgumentTypes;
    private boolean isMap;
    private boolean isList;
    private String[] aggregatedAliases;

    public ResultTransformer getResultTransformer() {
        if (this.constructor != null) {
            return new AliasToBeanConstructorResultTransformer(this.constructor);
        }
        if (this.isMap) {
            return Transformers.ALIAS_TO_ENTITY_MAP;
        }
        if (this.isList) {
            return Transformers.TO_LIST;
        }
        throw new QueryException("Unable to determine proper dynamic-instantiation tranformer to use.");
    }

    public String[] getAggregatedAliases() {
        if (this.aggregatedAliases == null) {
            this.aggregatedAliases = this.buildAggregatedAliases();
        }
        return this.aggregatedAliases;
    }

    private String[] buildAggregatedAliases() {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        String[] stringArray = new String[selectExpressionArray.length];
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            String string = selectExpressionArray[i].getAlias();
            stringArray[i] = string == null ? Integer.toString(i) : string;
        }
        return stringArray;
    }

    public void setScalarColumn(int n) throws SemanticException {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            SelectExpression selectExpression = selectExpressionArray[i];
            selectExpression.setScalarColumn(i);
        }
    }

    public int getScalarColumnIndex() {
        return -1;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            SelectExpression selectExpression = selectExpressionArray[i];
            selectExpression.setScalarColumnText(i);
        }
    }

    protected AST getFirstSelectExpression() {
        return this.getFirstChild().getNextSibling();
    }

    public Class getAggregationResultType() {
        return this.resultType;
    }

    @Deprecated
    public Type getDataType() {
        throw new UnsupportedOperationException("getDataType() is not supported by ConstructorNode!");
    }

    public void prepare() throws SemanticException {
        this.constructorArgumentTypes = this.resolveConstructorArgumentTypes();
        String string = ((PathNode)this.getFirstChild()).getPath();
        if ("map".equals(string.toLowerCase())) {
            this.isMap = true;
            this.resultType = Map.class;
        } else if ("list".equals(string.toLowerCase())) {
            this.isList = true;
            this.resultType = List.class;
        } else {
            this.constructor = this.resolveConstructor(string);
            this.resultType = this.constructor.getDeclaringClass();
        }
    }

    private Type[] resolveConstructorArgumentTypes() throws SemanticException {
        SelectExpression[] selectExpressionArray = this.collectSelectExpressions();
        if (selectExpressionArray == null) {
            return new Type[0];
        }
        Type[] typeArray = new Type[selectExpressionArray.length];
        for (int i = 0; i < selectExpressionArray.length; ++i) {
            typeArray[i] = selectExpressionArray[i].getDataType();
        }
        return typeArray;
    }

    private Constructor resolveConstructor(String string) throws SemanticException {
        String string2;
        String string3 = this.getSessionFactoryHelper().getImportedClassName(string);
        String string4 = string2 = StringHelper.isEmpty(string3) ? string : string3;
        if (string2 == null) {
            throw new SemanticException("Unable to locate class [" + string + "]");
        }
        try {
            Class clazz = ReflectHelper.classForName(string2);
            return ReflectHelper.getConstructor(clazz, this.constructorArgumentTypes);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DetailedSemanticException("Unable to locate class [" + string2 + "]", classNotFoundException);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new DetailedSemanticException("Unable to locate appropriate constructor on class [" + string2 + "]", propertyNotFoundException);
        }
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public List getConstructorArgumentTypeList() {
        return Arrays.asList(this.constructorArgumentTypes);
    }

    public List getAggregatedSelectionTypeList() {
        return this.getConstructorArgumentTypeList();
    }

    public FromElement getFromElement() {
        return null;
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isReturnableEntity() throws SemanticException {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    public void setAlias(String string) {
        throw new UnsupportedOperationException("constructor may not be aliased");
    }

    public String getAlias() {
        throw new UnsupportedOperationException("constructor may not be aliased");
    }
}

