/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.hql.internal.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.internal.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.internal.ast.tree.DisplayableNode;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class BinaryArithmeticOperatorNode
extends AbstractSelectExpression
implements BinaryOperatorNode,
DisplayableNode {
    public void initialize() throws SemanticException {
        Type type;
        Node node = this.getLeftHandOperand();
        Node node2 = this.getRightHandOperand();
        if (node == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        if (node2 == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        Type type2 = node instanceof SqlNode ? ((SqlNode)node).getDataType() : null;
        Type type3 = type = node2 instanceof SqlNode ? ((SqlNode)node2).getDataType() : null;
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)node)).getClass()) && type != null) {
            Type type4 = null;
            type4 = this.isDateTimeType(type) ? (this.getType() == 119 ? StandardBasicTypes.DOUBLE : type) : type;
            ((ExpectedTypeAwareNode)((Object)node)).setExpectedType(type4);
        } else if (ParameterNode.class.isAssignableFrom(((Object)((Object)node2)).getClass()) && type2 != null) {
            Type type5 = null;
            if (this.isDateTimeType(type2)) {
                if (this.getType() == 119) {
                    type5 = StandardBasicTypes.DOUBLE;
                }
            } else {
                type5 = type2;
            }
            ((ExpectedTypeAwareNode)((Object)node2)).setExpectedType(type5);
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            super.setDataType(this.resolveDataType());
        }
        return super.getDataType();
    }

    private Type resolveDataType() {
        Type type;
        Node node = this.getLeftHandOperand();
        Node node2 = this.getRightHandOperand();
        Type type2 = node instanceof SqlNode ? ((SqlNode)node).getDataType() : null;
        Type type3 = type = node2 instanceof SqlNode ? ((SqlNode)node2).getDataType() : null;
        if (this.isDateTimeType(type2) || this.isDateTimeType(type)) {
            return this.resolveDateTimeArithmeticResultType(type2, type);
        }
        if (type2 == null) {
            if (type == null) {
                return StandardBasicTypes.DOUBLE;
            }
            return type;
        }
        if (type == null) {
            return type2;
        }
        if (type2 == StandardBasicTypes.DOUBLE || type == StandardBasicTypes.DOUBLE) {
            return StandardBasicTypes.DOUBLE;
        }
        if (type2 == StandardBasicTypes.FLOAT || type == StandardBasicTypes.FLOAT) {
            return StandardBasicTypes.FLOAT;
        }
        if (type2 == StandardBasicTypes.BIG_DECIMAL || type == StandardBasicTypes.BIG_DECIMAL) {
            return StandardBasicTypes.BIG_DECIMAL;
        }
        if (type2 == StandardBasicTypes.BIG_INTEGER || type == StandardBasicTypes.BIG_INTEGER) {
            return StandardBasicTypes.BIG_INTEGER;
        }
        if (type2 == StandardBasicTypes.LONG || type == StandardBasicTypes.LONG) {
            return StandardBasicTypes.LONG;
        }
        if (type2 == StandardBasicTypes.INTEGER || type == StandardBasicTypes.INTEGER) {
            return StandardBasicTypes.INTEGER;
        }
        return type2;
    }

    private boolean isDateTimeType(Type type) {
        if (type == null) {
            return false;
        }
        return Date.class.isAssignableFrom(type.getReturnedClass()) || Calendar.class.isAssignableFrom(type.getReturnedClass());
    }

    private Type resolveDateTimeArithmeticResultType(Type type, Type type2) {
        boolean bl = this.isDateTimeType(type);
        boolean bl2 = this.isDateTimeType(type2);
        if (this.getType() == 119) {
            return bl ? type : type2;
        }
        if (this.getType() == 120) {
            if (bl && !bl2) {
                return type;
            }
            if (bl && bl2) {
                return StandardBasicTypes.DOUBLE;
            }
        }
        return null;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, n);
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }

    public String getDisplayText() {
        return "{dataType=" + this.getDataType() + "}";
    }
}

