/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.OperatorNode;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class BetweenOperatorNode
extends SqlNode
implements OperatorNode {
    public void initialize() throws SemanticException {
        Node node = this.getFixtureOperand();
        if (node == null) {
            throw new SemanticException("fixture operand of a between operator was null");
        }
        Node node2 = this.getLowOperand();
        if (node2 == null) {
            throw new SemanticException("low operand of a between operator was null");
        }
        Node node3 = this.getHighOperand();
        if (node3 == null) {
            throw new SemanticException("high operand of a between operator was null");
        }
        this.check(node, node2, node3);
        this.check(node2, node3, node);
        this.check(node3, node, node2);
    }

    public Type getDataType() {
        return StandardBasicTypes.BOOLEAN;
    }

    public Node getFixtureOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getLowOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }

    public Node getHighOperand() {
        return (Node)this.getFirstChild().getNextSibling().getNextSibling();
    }

    private void check(Node node, Node node2, Node node3) {
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)node)).getClass())) {
            Type type = null;
            if (SqlNode.class.isAssignableFrom(((Object)((Object)node2)).getClass())) {
                type = ((SqlNode)node2).getDataType();
            }
            if (type == null && SqlNode.class.isAssignableFrom(((Object)((Object)node3)).getClass())) {
                type = ((SqlNode)node3).getDataType();
            }
            ((ExpectedTypeAwareNode)((Object)node)).setExpectedType(type);
        }
    }
}

