/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.hql.internal.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.internal.ast.tree.FunctionNode;
import org.hibernate.hql.internal.ast.tree.SelectExpression;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class AggregateNode
extends AbstractSelectExpression
implements SelectExpression,
FunctionNode {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AggregateNode.class.getName());
    private SQLFunction sqlFunction;

    public SQLFunction getSQLFunction() {
        return this.sqlFunction;
    }

    public void resolve() {
        this.resolveFunction();
    }

    private SQLFunction resolveFunction() {
        if (this.sqlFunction == null) {
            String string = this.getText();
            this.sqlFunction = this.getSessionFactoryHelper().findSQLFunction(this.getText());
            if (this.sqlFunction == null) {
                LOG.unableToResolveAggregateFunction(string);
                this.sqlFunction = new StandardSQLFunction(string);
            }
        }
        return this.sqlFunction;
    }

    public Type getFirstArgumentType() {
        AST aST = this.getFirstChild();
        while (aST != null) {
            if (!(aST instanceof SqlNode)) continue;
            Type type = ((SqlNode)aST).getDataType();
            if (type != null) {
                return type;
            }
            aST = aST.getNextSibling();
        }
        return null;
    }

    public Type getDataType() {
        return this.getSessionFactoryHelper().findFunctionReturnType(this.getText(), this.resolveFunction(), this.getFirstChild());
    }

    public void setScalarColumnText(int n) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, n);
    }

    public boolean isScalar() throws SemanticException {
        return true;
    }
}

