/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.collections.AST;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public abstract class AbstractNullnessCheckNode
extends UnaryLogicOperatorNode {
    public void initialize() {
        Type type = AbstractNullnessCheckNode.extractDataType(this.getOperand());
        if (type == null) {
            return;
        }
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryHelper().getFactory();
        int n = type.getColumnSpan(sessionFactoryImplementor);
        if (n > 1) {
            this.mutateRowValueConstructorSyntax(n);
        }
    }

    protected abstract int getExpansionConnectorType();

    protected abstract String getExpansionConnectorText();

    private void mutateRowValueConstructorSyntax(int n) {
        int n2 = this.getType();
        String string = this.getText();
        int n3 = this.getExpansionConnectorType();
        String string2 = this.getExpansionConnectorText();
        this.setType(n3);
        this.setText(string2);
        String[] stringArray = AbstractNullnessCheckNode.extractMutationTexts(this.getOperand(), n);
        AbstractNullnessCheckNode abstractNullnessCheckNode = this;
        for (int i = n - 1; i > 0; --i) {
            AST aST;
            AST aST2;
            AST aST3;
            if (i == 1) {
                aST3 = this.getASTFactory().create(n2, string);
                aST2 = this.getASTFactory().create(145, stringArray[0]);
                aST3.setFirstChild(aST2);
                abstractNullnessCheckNode.setFirstChild(aST3);
                aST = this.getASTFactory().create(n2, string);
                AST aST4 = this.getASTFactory().create(145, stringArray[1]);
                aST.setFirstChild(aST4);
                aST3.setNextSibling(aST);
                continue;
            }
            aST3 = this.getASTFactory().create(n2, string);
            aST2 = this.getASTFactory().create(145, stringArray[i]);
            aST3.setFirstChild(aST2);
            aST = this.getASTFactory().create(n3, string2);
            abstractNullnessCheckNode.setFirstChild(aST);
            aST.setNextSibling(aST3);
            abstractNullnessCheckNode = aST;
        }
    }

    private static Type extractDataType(Node node) {
        Type type = null;
        if (node instanceof SqlNode) {
            type = ((SqlNode)node).getDataType();
        }
        if (type == null && node instanceof ExpectedTypeAwareNode) {
            type = ((ExpectedTypeAwareNode)((Object)node)).getExpectedType();
        }
        return type;
    }

    private static String[] extractMutationTexts(Node node, int n) {
        if (node instanceof ParameterNode) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "?";
            }
            return stringArray;
        }
        if (node.getType() == 95) {
            String[] stringArray = new String[node.getNumberOfChildren()];
            int n2 = 0;
            for (AST aST = node.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
                stringArray[n2++] = aST.getText();
            }
            return stringArray;
        }
        if (node instanceof SqlNode) {
            String[] stringArray;
            String string = node.getText();
            if (string.startsWith("(")) {
                string = string.substring(1);
            }
            if (string.endsWith(")")) {
                string = string.substring(0, string.length() - 1);
            }
            if (n != (stringArray = StringHelper.split(", ", string)).length) {
                throw new HibernateException("SqlNode's text did not reference expected number of columns");
            }
            return stringArray;
        }
        throw new HibernateException("dont know how to extract row value elements from node : " + (Object)((Object)node));
    }
}

