/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.Map;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromReferenceNode;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public abstract class AbstractMapComponentNode
extends FromReferenceNode
implements HqlSqlTokenTypes {
    private String[] columns;

    public FromReferenceNode getMapReference() {
        return (FromReferenceNode)this.getFirstChild();
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setScalarColumnText(int n) throws SemanticException {
        ColumnHelper.generateScalarColumns(this, this.getColumns(), n);
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        CollectionType collectionType;
        if (aST != null) {
            throw this.attemptedDereference();
        }
        FromReferenceNode fromReferenceNode = this.getMapReference();
        fromReferenceNode.resolve(true, true);
        FromElement fromElement = null;
        if (this.isAliasRef(fromReferenceNode)) {
            QueryableCollection queryableCollection = fromReferenceNode.getFromElement().getQueryableCollection();
            if (Map.class.isAssignableFrom(queryableCollection.getCollectionType().getReturnedClass())) {
                fromElement = fromReferenceNode.getFromElement();
            }
        } else if (fromReferenceNode.getDataType().isCollectionType() && Map.class.isAssignableFrom((collectionType = (CollectionType)fromReferenceNode.getDataType()).getReturnedClass())) {
            fromElement = fromReferenceNode.getFromElement();
        }
        if (fromElement == null) {
            throw this.nonMap();
        }
        this.setFromElement(fromElement);
        this.setDataType(this.resolveType(fromElement.getQueryableCollection()));
        this.columns = this.resolveColumns(fromElement.getQueryableCollection());
        this.initText(this.columns);
        this.setFirstChild(null);
    }

    private boolean isAliasRef(FromReferenceNode fromReferenceNode) {
        return 143 == fromReferenceNode.getType();
    }

    private void initText(String[] stringArray) {
        String string = StringHelper.join(", ", stringArray);
        if (stringArray.length > 1 && this.getWalker().isComparativeExpressionClause()) {
            string = "(" + string + ")";
        }
        this.setText(string);
    }

    protected abstract String expressionDescription();

    protected abstract String[] resolveColumns(QueryableCollection var1);

    protected abstract Type resolveType(QueryableCollection var1);

    protected SemanticException attemptedDereference() {
        return new SemanticException(this.expressionDescription() + " expression cannot be further de-referenced");
    }

    protected SemanticException nonMap() {
        return new SemanticException(this.expressionDescription() + " expression did not reference map property");
    }

    public void resolveIndex(AST aST) throws SemanticException {
        throw new UnsupportedOperationException(this.expressionDescription() + " expression cannot be the source for an index operation");
    }
}

