/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.exec;

import org.hibernate.HibernateException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.hibernate.hql.spi.MultiTableBulkIdStrategy;

public class MultiTableDeleteExecutor
implements StatementExecutor {
    private final MultiTableBulkIdStrategy.DeleteHandler deleteHandler;

    public MultiTableDeleteExecutor(HqlSqlWalker hqlSqlWalker) {
        MultiTableBulkIdStrategy multiTableBulkIdStrategy = hqlSqlWalker.getSessionFactoryHelper().getFactory().getSettings().getMultiTableBulkIdStrategy();
        this.deleteHandler = multiTableBulkIdStrategy.buildDeleteHandler(hqlSqlWalker.getSessionFactoryHelper().getFactory(), hqlSqlWalker);
    }

    public String[] getSqlStatements() {
        return this.deleteHandler.getSqlStatements();
    }

    public int execute(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        BulkOperationCleanupAction bulkOperationCleanupAction = new BulkOperationCleanupAction(sessionImplementor, this.deleteHandler.getTargetedQueryable());
        if (sessionImplementor.isEventSource()) {
            ((EventSource)sessionImplementor).getActionQueue().addAction(bulkOperationCleanupAction);
        } else {
            bulkOperationCleanupAction.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, sessionImplementor);
        }
        return this.deleteHandler.execute(sessionImplementor, queryParameters);
    }
}

