/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.exec;

import antlr.RecognitionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.hql.internal.ast.SqlGenerator;
import org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;

public class BasicExecutor
implements StatementExecutor {
    private final SessionFactoryImplementor factory;
    private final Queryable persister;
    private final String sql;
    private final List parameterSpecifications;

    public BasicExecutor(HqlSqlWalker hqlSqlWalker, Queryable queryable) {
        this.factory = hqlSqlWalker.getSessionFactoryHelper().getFactory();
        this.persister = queryable;
        try {
            SqlGenerator sqlGenerator = new SqlGenerator(this.factory);
            sqlGenerator.statement(hqlSqlWalker.getAST());
            this.sql = sqlGenerator.getSQL();
            sqlGenerator.getParseErrorHandler().throwQueryException();
            this.parameterSpecifications = sqlGenerator.getCollectedParameters();
        }
        catch (RecognitionException recognitionException) {
            throw QuerySyntaxException.convert(recognitionException);
        }
    }

    public String[] getSqlStatements() {
        return new String[]{this.sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        BulkOperationCleanupAction bulkOperationCleanupAction = new BulkOperationCleanupAction(sessionImplementor, this.persister);
        if (sessionImplementor.isEventSource()) {
            ((EventSource)sessionImplementor).getActionQueue().addAction(bulkOperationCleanupAction);
        } else {
            bulkOperationCleanupAction.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, sessionImplementor);
        }
        PreparedStatement preparedStatement = null;
        RowSelection rowSelection = queryParameters.getRowSelection();
        try {
            preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql, false);
            Iterator iterator = this.parameterSpecifications.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                ParameterSpecification parameterSpecification = (ParameterSpecification)iterator.next();
                n += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n);
            }
            if (rowSelection != null && rowSelection.getTimeout() != null) {
                preparedStatement.setQueryTimeout(rowSelection.getTimeout());
            }
            int n2 = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
            if (preparedStatement != null) {
                sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
            }
            return n2;
        }
        catch (Throwable throwable) {
            try {
                if (preparedStatement != null) {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                }
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw this.factory.getSQLExceptionHelper().convert(sQLException, "could not execute update query", this.sql);
            }
        }
    }
}

