/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.NullPrecedence;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.antlr.SqlGeneratorBase;
import org.hibernate.hql.internal.antlr.SqlTokenTypes;
import org.hibernate.hql.internal.ast.ErrorCounter;
import org.hibernate.hql.internal.ast.ErrorReporter;
import org.hibernate.hql.internal.ast.ParseErrorHandler;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FunctionNode;
import org.hibernate.hql.internal.ast.tree.Node;
import org.hibernate.hql.internal.ast.tree.ParameterContainer;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlGenerator
extends SqlGeneratorBase
implements ErrorReporter {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SqlGenerator.class.getName());
    public static boolean REGRESSION_STYLE_CROSS_JOINS = false;
    private SqlWriter writer = new DefaultWriter();
    private ParseErrorHandler parseErrorHandler;
    private SessionFactoryImplementor sessionFactory;
    private LinkedList<SqlWriter> outputStack = new LinkedList();
    private final ASTPrinter printer = new ASTPrinter(SqlTokenTypes.class);
    private List<ParameterSpecification> collectedParameters = new ArrayList<ParameterSpecification>();
    private int traceDepth = 0;

    public void traceIn(String string, AST aST) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String string3 = string + " (" + this.buildTraceNodeName(aST) + ")";
        LOG.trace(string2 + string3);
    }

    private String buildTraceNodeName(AST aST) {
        return aST == null ? "???" : aST.getText() + " [" + this.printer.getTokenTypeName(aST.getType()) + "]";
    }

    public void traceOut(String string, AST aST) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(string2 + string);
    }

    public List<ParameterSpecification> getCollectedParameters() {
        return this.collectedParameters;
    }

    @Override
    protected void out(String string) {
        this.writer.clause(string);
    }

    @Override
    protected void out(AST aST) {
        ParameterSpecification[] parameterSpecificationArray;
        if (aST instanceof Node) {
            this.out(((Node)aST).getRenderText(this.sessionFactory));
        } else {
            super.out(aST);
        }
        if (aST instanceof ParameterNode) {
            this.collectedParameters.add(((ParameterNode)aST).getHqlParameterSpecification());
        } else if (aST instanceof ParameterContainer && ((ParameterContainer)aST).hasEmbeddedParameters() && (parameterSpecificationArray = ((ParameterContainer)aST).getEmbeddedParameters()) != null) {
            this.collectedParameters.addAll(Arrays.asList(parameterSpecificationArray));
        }
    }

    @Override
    protected void commaBetweenParameters(String string) {
        this.writer.commaBetweenParameters(string);
    }

    @Override
    public void reportError(RecognitionException recognitionException) {
        this.parseErrorHandler.reportError(recognitionException);
    }

    @Override
    public void reportError(String string) {
        this.parseErrorHandler.reportError(string);
    }

    @Override
    public void reportWarning(String string) {
        this.parseErrorHandler.reportWarning(string);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public SqlGenerator(SessionFactoryImplementor sessionFactoryImplementor) {
        this.parseErrorHandler = new ErrorCounter();
        this.sessionFactory = sessionFactoryImplementor;
    }

    public String getSQL() {
        return this.getStringBuilder().toString();
    }

    @Override
    protected void optionalSpace() {
        int n = this.getLastChar();
        switch (n) {
            case -1: {
                return;
            }
            case 32: {
                return;
            }
            case 41: {
                return;
            }
            case 40: {
                return;
            }
        }
        this.out(" ");
    }

    @Override
    protected void beginFunctionTemplate(AST aST, AST aST2) {
        FunctionNode functionNode = (FunctionNode)aST;
        SQLFunction sQLFunction = functionNode.getSQLFunction();
        if (sQLFunction == null) {
            super.beginFunctionTemplate(aST, aST2);
        } else {
            this.outputStack.addFirst(this.writer);
            this.writer = new FunctionArguments();
        }
    }

    @Override
    protected void endFunctionTemplate(AST aST) {
        FunctionNode functionNode = (FunctionNode)aST;
        SQLFunction sQLFunction = functionNode.getSQLFunction();
        if (sQLFunction == null) {
            super.endFunctionTemplate(aST);
        } else {
            Type type = functionNode.getFirstArgumentType();
            FunctionArguments functionArguments = (FunctionArguments)this.writer;
            this.writer = this.outputStack.removeFirst();
            this.out(sQLFunction.render(type, functionArguments.getArgs(), this.sessionFactory));
        }
    }

    public static void panic() {
        throw new QueryException("TreeWalker: panic");
    }

    @Override
    protected void fromFragmentSeparator(AST aST) {
        FromElement fromElement;
        AST aST2 = aST.getNextSibling();
        if (aST2 == null || !this.hasText(aST)) {
            return;
        }
        FromElement fromElement2 = (FromElement)aST;
        for (fromElement = (FromElement)aST2; fromElement != null && !this.hasText((AST)fromElement); fromElement = (FromElement)fromElement.getNextSibling()) {
        }
        if (fromElement == null) {
            return;
        }
        if (!this.hasText((AST)fromElement)) {
            return;
        }
        if (fromElement.getRealOrigin() == fromElement2 || fromElement.getRealOrigin() != null && fromElement.getRealOrigin() == fromElement2.getRealOrigin()) {
            if (fromElement.getJoinSequence() != null && fromElement.getJoinSequence().isThetaStyle()) {
                this.writeCrossJoinSeparator();
            } else {
                this.out(" ");
            }
        } else {
            this.writeCrossJoinSeparator();
        }
    }

    private void writeCrossJoinSeparator() {
        if (REGRESSION_STYLE_CROSS_JOINS) {
            this.out(", ");
        } else {
            this.out(this.sessionFactory.getDialect().getCrossJoinSeparator());
        }
    }

    @Override
    protected void nestedFromFragment(AST aST, AST aST2) {
        if (aST != null && this.hasText(aST)) {
            if (aST2 != null && this.hasText(aST2)) {
                FromElement fromElement = (FromElement)aST2;
                FromElement fromElement2 = (FromElement)aST;
                if (fromElement2.getRealOrigin() == fromElement) {
                    if (fromElement2.getJoinSequence() != null && fromElement2.getJoinSequence().isThetaStyle()) {
                        this.out(", ");
                    } else {
                        this.out(" ");
                    }
                } else {
                    this.out(", ");
                }
            }
            this.out(aST);
        }
    }

    @Override
    protected String renderOrderByElement(String string, String string2, String string3) {
        NullPrecedence nullPrecedence = NullPrecedence.parse(string3, this.sessionFactory.getSettings().getDefaultNullPrecedence());
        return this.sessionFactory.getDialect().renderOrderByElement(string, null, string2, nullPrecedence);
    }

    class DefaultWriter
    implements SqlWriter {
        DefaultWriter() {
        }

        public void clause(String string) {
            SqlGenerator.this.getStringBuilder().append(string);
        }

        public void commaBetweenParameters(String string) {
            SqlGenerator.this.getStringBuilder().append(string);
        }
    }

    class FunctionArguments
    implements SqlWriter {
        private int argInd;
        private final List<String> args = new ArrayList<String>(3);

        FunctionArguments() {
        }

        public void clause(String string) {
            if (this.argInd == this.args.size()) {
                this.args.add(string);
            } else {
                this.args.set(this.argInd, this.args.get(this.argInd) + string);
            }
        }

        public void commaBetweenParameters(String string) {
            ++this.argInd;
        }

        public List getArgs() {
            return this.args;
        }
    }

    static interface SqlWriter {
        public void clause(String var1);

        public void commaBetweenParameters(String var1);
    }
}

