/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.ASTFactory;
import antlr.Token;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AggregateNode;
import org.hibernate.hql.internal.ast.tree.BetweenOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryArithmeticOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.BooleanLiteralNode;
import org.hibernate.hql.internal.ast.tree.Case2Node;
import org.hibernate.hql.internal.ast.tree.CaseNode;
import org.hibernate.hql.internal.ast.tree.CollectionFunction;
import org.hibernate.hql.internal.ast.tree.ConstructorNode;
import org.hibernate.hql.internal.ast.tree.CountNode;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.DotNode;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.IdentNode;
import org.hibernate.hql.internal.ast.tree.ImpliedFromElement;
import org.hibernate.hql.internal.ast.tree.InLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.IndexNode;
import org.hibernate.hql.internal.ast.tree.InitializeableNode;
import org.hibernate.hql.internal.ast.tree.InsertStatement;
import org.hibernate.hql.internal.ast.tree.IntoClause;
import org.hibernate.hql.internal.ast.tree.IsNotNullLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.IsNullLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.JavaConstantNode;
import org.hibernate.hql.internal.ast.tree.LiteralNode;
import org.hibernate.hql.internal.ast.tree.MapEntryNode;
import org.hibernate.hql.internal.ast.tree.MapKeyNode;
import org.hibernate.hql.internal.ast.tree.MapValueNode;
import org.hibernate.hql.internal.ast.tree.MethodNode;
import org.hibernate.hql.internal.ast.tree.OrderByClause;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.tree.ResultVariableRefNode;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.hql.internal.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.internal.ast.tree.SessionFactoryAwareNode;
import org.hibernate.hql.internal.ast.tree.SqlFragment;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.tree.UnaryArithmeticNode;
import org.hibernate.hql.internal.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;

public class SqlASTFactory
extends ASTFactory
implements HqlSqlTokenTypes {
    private HqlSqlWalker walker;

    public SqlASTFactory(HqlSqlWalker hqlSqlWalker) {
        this.walker = hqlSqlWalker;
    }

    public Class getASTNodeType(int n) {
        switch (n) {
            case 45: 
            case 89: {
                return QueryNode.class;
            }
            case 51: {
                return UpdateStatement.class;
            }
            case 13: {
                return DeleteStatement.class;
            }
            case 29: {
                return InsertStatement.class;
            }
            case 30: {
                return IntoClause.class;
            }
            case 22: {
                return FromClause.class;
            }
            case 137: {
                return FromElement.class;
            }
            case 138: {
                return ImpliedFromElement.class;
            }
            case 15: {
                return DotNode.class;
            }
            case 81: {
                return IndexNode.class;
            }
            case 111: 
            case 143: {
                return IdentNode.class;
            }
            case 153: {
                return ResultVariableRefNode.class;
            }
            case 145: {
                return SqlFragment.class;
            }
            case 84: {
                return MethodNode.class;
            }
            case 17: 
            case 27: {
                return CollectionFunction.class;
            }
            case 140: {
                return SelectClause.class;
            }
            case 147: {
                return SelectExpressionImpl.class;
            }
            case 74: {
                return AggregateNode.class;
            }
            case 12: {
                return CountNode.class;
            }
            case 76: {
                return ConstructorNode.class;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 128: 
            case 129: {
                return LiteralNode.class;
            }
            case 20: 
            case 49: {
                return BooleanLiteralNode.class;
            }
            case 103: {
                return JavaConstantNode.class;
            }
            case 41: {
                return OrderByClause.class;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return BinaryArithmeticOperatorNode.class;
            }
            case 93: 
            case 94: {
                return UnaryArithmeticNode.class;
            }
            case 77: {
                return Case2Node.class;
            }
            case 57: {
                return CaseNode.class;
            }
            case 127: 
            case 151: {
                return ParameterNode.class;
            }
            case 34: 
            case 87: 
            case 105: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                return BinaryLogicOperatorNode.class;
            }
            case 26: 
            case 86: {
                return InLogicOperatorNode.class;
            }
            case 10: 
            case 85: {
                return BetweenOperatorNode.class;
            }
            case 83: {
                return IsNullLogicOperatorNode.class;
            }
            case 82: {
                return IsNotNullLogicOperatorNode.class;
            }
            case 19: {
                return UnaryLogicOperatorNode.class;
            }
            case 71: {
                return MapKeyNode.class;
            }
            case 72: {
                return MapValueNode.class;
            }
            case 73: {
                return MapEntryNode.class;
            }
        }
        return SqlNode.class;
    }

    protected AST createUsingCtor(Token token, String string) {
        AST aST;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Token.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            if (constructor != null) {
                aST = (AST)constructor.newInstance(token);
                this.initializeSqlNode(aST);
            } else {
                aST = this.create(clazz);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid class or can't make instance, " + string);
        }
        return aST;
    }

    private void initializeSqlNode(AST aST) {
        if (aST instanceof InitializeableNode) {
            InitializeableNode initializeableNode = (InitializeableNode)aST;
            initializeableNode.initialize(this.walker);
        }
        if (aST instanceof SessionFactoryAwareNode) {
            ((SessionFactoryAwareNode)aST).setSessionFactory(this.walker.getSessionFactoryHelper().getFactory());
        }
    }

    protected AST create(Class clazz) {
        AST aST;
        try {
            aST = (AST)clazz.newInstance();
            this.initializeSqlNode(aST);
        }
        catch (Exception exception) {
            this.error("Can't create AST Node " + clazz.getName());
            return null;
        }
        return aST;
    }
}

