/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.ASTPair;
import antlr.MismatchedTokenException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.antlr.HqlBaseParser;
import org.hibernate.hql.internal.antlr.HqlTokenTypes;
import org.hibernate.hql.internal.ast.ErrorCounter;
import org.hibernate.hql.internal.ast.HqlASTFactory;
import org.hibernate.hql.internal.ast.HqlLexer;
import org.hibernate.hql.internal.ast.HqlToken;
import org.hibernate.hql.internal.ast.ParseErrorHandler;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public final class HqlParser
extends HqlBaseParser {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, HqlParser.class.getName());
    private ParseErrorHandler parseErrorHandler;
    private ASTPrinter printer = HqlParser.getASTPrinter();
    private int traceDepth = 0;

    private static ASTPrinter getASTPrinter() {
        return new ASTPrinter(HqlTokenTypes.class);
    }

    public static HqlParser getInstance(String string) {
        HqlLexer hqlLexer = new HqlLexer(new StringReader(string));
        return new HqlParser(hqlLexer);
    }

    private HqlParser(TokenStream tokenStream) {
        super(tokenStream);
        this.initialize();
    }

    public void traceIn(String string) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        LOG.trace(string2 + string);
    }

    public void traceOut(String string) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        LOG.trace(string2 + string);
    }

    public void reportError(RecognitionException recognitionException) {
        this.parseErrorHandler.reportError(recognitionException);
    }

    public void reportError(String string) {
        this.parseErrorHandler.reportError(string);
    }

    public void reportWarning(String string) {
        this.parseErrorHandler.reportWarning(string);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public AST handleIdentifierError(Token token, RecognitionException recognitionException) throws RecognitionException, TokenStreamException {
        HqlToken hqlToken;
        if (token instanceof HqlToken && (hqlToken = (HqlToken)token).isPossibleID() && recognitionException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)recognitionException;
            if (mismatchedTokenException.expecting == 111) {
                this.reportWarning("Keyword  '" + token.getText() + "' is being interpreted as an identifier due to: " + mismatchedTokenException.getMessage());
                ASTPair aSTPair = new ASTPair();
                token.setType(96);
                this.astFactory.addASTChild(aSTPair, this.astFactory.create(token));
                this.consume();
                AST aST = aSTPair.root;
                return aST;
            }
        }
        return super.handleIdentifierError(token, recognitionException);
    }

    public AST negateNode(AST aST) {
        switch (aST.getType()) {
            case 40: {
                aST.setType(6);
                aST.setText("{and}");
                aST.setFirstChild(this.negateNode(aST.getFirstChild()));
                aST.getFirstChild().setNextSibling(this.negateNode(aST.getFirstChild().getNextSibling()));
                return aST;
            }
            case 6: {
                aST.setType(40);
                aST.setText("{or}");
                aST.setFirstChild(this.negateNode(aST.getFirstChild()));
                aST.getFirstChild().setNextSibling(this.negateNode(aST.getFirstChild().getNextSibling()));
                return aST;
            }
            case 105: {
                aST.setType(112);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 112: {
                aST.setType(105);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 115: {
                aST.setType(116);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 114: {
                aST.setType(117);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 117: {
                aST.setType(114);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 116: {
                aST.setType(115);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 34: {
                aST.setType(87);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 87: {
                aST.setType(34);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 26: {
                aST.setType(86);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 86: {
                aST.setType(26);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 83: {
                aST.setType(82);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 82: {
                aST.setType(83);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 10: {
                aST.setType(85);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
            case 85: {
                aST.setType(10);
                aST.setText("{not}" + aST.getText());
                return aST;
            }
        }
        AST aST2 = super.negateNode(aST);
        if (aST2 != aST) {
            aST2.setNextSibling(aST.getNextSibling());
            aST.setNextSibling(null);
        }
        return aST2;
    }

    public AST processEqualityExpression(AST aST) {
        if (aST == null) {
            LOG.processEqualityExpression();
            return null;
        }
        int n = aST.getType();
        if (n == 105 || n == 112) {
            boolean bl;
            boolean bl2 = bl = n == 112;
            if (aST.getNumberOfChildren() == 2) {
                AST aST2 = aST.getFirstChild();
                AST aST3 = aST2.getNextSibling();
                if (aST2.getType() == 39 && aST3.getType() != 39) {
                    return this.createIsNullParent(aST3, bl);
                }
                if (aST3.getType() == 39 && aST2.getType() != 39) {
                    return this.createIsNullParent(aST2, bl);
                }
                if (aST3.getType() == 65) {
                    return this.processIsEmpty(aST2, bl);
                }
                return aST;
            }
            return aST;
        }
        return aST;
    }

    private AST createIsNullParent(AST aST, boolean bl) {
        aST.setNextSibling(null);
        int n = bl ? 82 : 83;
        String string = bl ? "is not null" : "is null";
        return ASTUtil.createParent(this.astFactory, n, string, aST);
    }

    private AST processIsEmpty(AST aST, boolean bl) {
        aST.setNextSibling(null);
        AST aST2 = this.createSubquery(aST);
        aST2 = ASTUtil.createParent(this.astFactory, 19, "exists", aST2);
        if (!bl) {
            aST2 = ASTUtil.createParent(this.astFactory, 38, "not", aST2);
        }
        return aST2;
    }

    private AST createSubquery(AST aST) {
        AST aST2 = ASTUtil.createParent(this.astFactory, 90, "RANGE", aST);
        aST2 = ASTUtil.createParent(this.astFactory, 22, "from", aST2);
        aST2 = ASTUtil.createParent(this.astFactory, 92, "SELECT_FROM", aST2);
        aST2 = ASTUtil.createParent(this.astFactory, 89, "QUERY", aST2);
        return aST2;
    }

    public void showAst(AST aST, PrintStream printStream) {
        this.showAst(aST, new PrintWriter(printStream));
    }

    private void showAst(AST aST, PrintWriter printWriter) {
        this.printer.showAst(aST, printWriter);
    }

    private void initialize() {
        this.parseErrorHandler = new ErrorCounter();
        this.setASTFactory(new HqlASTFactory());
    }

    public void weakKeywords() throws TokenStreamException {
        int n = this.LA(1);
        switch (n) {
            case 24: 
            case 41: {
                if (this.LA(2) == 108) break;
                this.LT(1).setType(111);
                if (!LOG.isDebugEnabled()) break;
                LOG.debugf("weakKeywords() : new LT(1) token - %s", (Object)this.LT(1));
                break;
            }
            default: {
                HqlToken hqlToken;
                if (this.LA(0) != 22 || n == 111 || this.LA(2) != 15 || !(hqlToken = (HqlToken)this.LT(1)).isPossibleID()) break;
                hqlToken.setType(111);
                if (!LOG.isDebugEnabled()) break;
                LOG.debugf("weakKeywords() : new LT(1) token - %s", (Object)this.LT(1));
            }
        }
    }

    public void handleDotIdent() throws TokenStreamException {
        HqlToken hqlToken;
        if (this.LA(1) == 15 && this.LA(2) != 111 && (hqlToken = (HqlToken)this.LT(2)).isPossibleID()) {
            this.LT(2).setType(111);
            if (LOG.isDebugEnabled()) {
                LOG.debugf("handleDotIdent() : new LT(2) token - %s", (Object)this.LT(1));
            }
        }
    }

    public void processMemberOf(Token token, AST aST, ASTPair aSTPair) {
        AST aST2 = token == null ? this.astFactory.create(26, "in") : this.astFactory.create(86, "not in");
        this.astFactory.makeASTRoot(aSTPair, aST2);
        AST aST3 = this.astFactory.create(80, "inList");
        aST2.addChild(aST3);
        AST aST4 = this.astFactory.create(17, "elements");
        aST3.addChild(aST4);
        aST4.addChild(aST);
    }

    public static void panic() {
        throw new QueryException("Parser: panic");
    }
}

