/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.RecognitionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.ast.ParseErrorHandler;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class ErrorCounter
implements ParseErrorHandler {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ErrorCounter.class.getName());
    private List errorList = new ArrayList();
    private List warningList = new ArrayList();
    private List recognitionExceptions = new ArrayList();

    public void reportError(RecognitionException recognitionException) {
        this.reportError(recognitionException.toString());
        this.recognitionExceptions.add(recognitionException);
        LOG.error(recognitionException.toString(), recognitionException);
    }

    public void reportError(String string) {
        LOG.error(string);
        this.errorList.add(string);
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public void reportWarning(String string) {
        LOG.debug(string);
        this.warningList.add(string);
    }

    private String getErrorString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.errorList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void throwQueryException() throws QueryException {
        if (this.getErrorCount() > 0) {
            if (this.recognitionExceptions.size() > 0) {
                throw QuerySyntaxException.convert((RecognitionException)((Object)this.recognitionExceptions.get(0)));
            }
            throw new QueryException(this.getErrorString());
        }
        LOG.debug("throwQueryException() : no errors");
    }
}

