/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.antlr;

import antlr.LLkParser;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.hql.internal.antlr.SqlStatementParserTokenTypes;
import org.hibernate.hql.internal.ast.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStatementParser
extends LLkParser
implements SqlStatementParserTokenTypes {
    private ErrorHandler errorHandler = new ErrorHandler();
    private List<String> statementList = new LinkedList<String>();
    private StringBuilder current = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "NOT_STMT_END", "QUOTED_STRING", "STMT_END", "ESCqs", "LINE_COMMENT", "MULTILINE_COMMENT"};
    public static final BitSet _tokenSet_0 = new BitSet(SqlStatementParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SqlStatementParser.mk_tokenSet_1());

    public void reportError(RecognitionException recognitionException) {
        this.errorHandler.reportError(recognitionException);
    }

    public void reportError(String string) {
        this.errorHandler.reportError(string);
    }

    public void reportWarning(String string) {
        this.errorHandler.reportWarning(string);
    }

    public void throwExceptionIfErrorOccurred() {
        if (this.errorHandler.hasErrors()) {
            throw new StatementParserException(this.errorHandler.getErrorMessage());
        }
    }

    protected void out(String string) {
        this.current.append(string);
    }

    protected void out(Token token) {
        this.out(token.getText());
    }

    public List<String> getStatementList() {
        return this.statementList;
    }

    protected void statementEnd() {
        this.statementList.add(this.current.toString().trim());
        this.current = new StringBuilder();
    }

    protected SqlStatementParser(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.tokenNames = _tokenNames;
    }

    public SqlStatementParser(TokenBuffer tokenBuffer) {
        this(tokenBuffer, 1);
    }

    protected SqlStatementParser(TokenStream tokenStream, int n) {
        super(tokenStream, n);
        this.tokenNames = _tokenNames;
    }

    public SqlStatementParser(TokenStream tokenStream) {
        this(tokenStream, 1);
    }

    public SqlStatementParser(ParserSharedInputState parserSharedInputState) {
        super(parserSharedInputState, 1);
        this.tokenNames = _tokenNames;
    }

    public final void script() throws RecognitionException, TokenStreamException {
        try {
            while (this.LA(1) >= 4 && this.LA(1) <= 6) {
                this.statement();
            }
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover(recognitionException, _tokenSet_0);
        }
    }

    public final void statement() throws RecognitionException, TokenStreamException {
        Token token = null;
        Token token2 = null;
        try {
            block6: while (true) {
                switch (this.LA(1)) {
                    case 4: {
                        token = this.LT(1);
                        this.match(4);
                        this.out(token);
                        continue block6;
                    }
                    case 5: {
                        token2 = this.LT(1);
                        this.match(5);
                        this.out(token2);
                        continue block6;
                    }
                }
                break;
            }
            this.match(6);
            this.statementEnd();
        }
        catch (RecognitionException recognitionException) {
            this.reportError(recognitionException);
            this.recover(recognitionException, _tokenSet_1);
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[]{2L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[]{114L, 0L};
        return lArray;
    }

    private class ErrorHandler
    implements ErrorReporter {
        private List<String> errorList = new LinkedList<String>();

        private ErrorHandler() {
        }

        public void reportError(RecognitionException recognitionException) {
            this.reportError(recognitionException.toString());
        }

        public void reportError(String string) {
            this.errorList.add(string);
        }

        public void reportWarning(String string) {
        }

        public boolean hasErrors() {
            return !this.errorList.isEmpty();
        }

        public String getErrorMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = this.errorList.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public class StatementParserException
    extends RuntimeException {
        public StatementParserException(String string) {
            super(string);
        }
    }
}

