/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.antlr;

import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import org.hibernate.hql.internal.antlr.SqlTokenTypes;

public class SqlGeneratorBase
extends TreeParser
implements SqlTokenTypes {
    private StringBuilder buf = new StringBuilder();
    private boolean captureExpression = false;
    private StringBuilder expr = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"all\"", "\"any\"", "\"and\"", "\"as\"", "\"asc\"", "\"avg\"", "\"between\"", "\"class\"", "\"count\"", "\"delete\"", "\"desc\"", "DOT", "\"distinct\"", "\"elements\"", "\"escape\"", "\"exists\"", "\"false\"", "\"fetch\"", "\"from\"", "\"full\"", "\"group\"", "\"having\"", "\"in\"", "\"indices\"", "\"inner\"", "\"insert\"", "\"into\"", "\"is\"", "\"join\"", "\"left\"", "\"like\"", "\"max\"", "\"min\"", "\"new\"", "\"not\"", "\"null\"", "\"or\"", "\"order\"", "\"outer\"", "\"properties\"", "\"right\"", "\"select\"", "\"set\"", "\"some\"", "\"sum\"", "\"true\"", "\"union\"", "\"update\"", "\"versioned\"", "\"where\"", "\"nulls\"", "FIRST", "LAST", "\"case\"", "\"end\"", "\"else\"", "\"then\"", "\"when\"", "\"on\"", "\"with\"", "\"both\"", "\"empty\"", "\"leading\"", "\"member\"", "\"object\"", "\"of\"", "\"trailing\"", "KEY", "VALUE", "ENTRY", "AGGREGATE", "ALIAS", "CONSTRUCTOR", "CASE2", "EXPR_LIST", "FILTER_ENTITY", "IN_LIST", "INDEX_OP", "IS_NOT_NULL", "IS_NULL", "METHOD_CALL", "NOT_BETWEEN", "NOT_IN", "NOT_LIKE", "ORDER_ELEMENT", "QUERY", "RANGE", "ROW_STAR", "SELECT_FROM", "UNARY_MINUS", "UNARY_PLUS", "VECTOR_EXPR", "WEIRD_IDENT", "CONSTANT", "NUM_DOUBLE", "NUM_FLOAT", "NUM_LONG", "NUM_BIG_INTEGER", "NUM_BIG_DECIMAL", "JAVA_CONSTANT", "COMMA", "EQ", "OPEN", "CLOSE", "\"by\"", "\"ascending\"", "\"descending\"", "IDENT", "NE", "SQL_NE", "LT", "GT", "LE", "GE", "CONCAT", "PLUS", "MINUS", "STAR", "DIV", "MOD", "OPEN_BRACKET", "CLOSE_BRACKET", "COLON", "PARAM", "NUM_INT", "QUOTED_STRING", "ID_START_LETTER", "ID_LETTER", "ESCqs", "WS", "HEX_DIGIT", "EXPONENT", "FLOAT_SUFFIX", "FROM_FRAGMENT", "IMPLIED_FROM", "JOIN_FRAGMENT", "SELECT_CLAUSE", "LEFT_OUTER", "RIGHT_OUTER", "ALIAS_REF", "PROPERTY_REF", "SQL_TOKEN", "SELECT_COLUMNS", "SELECT_EXPR", "THETA_JOINS", "FILTERS", "METHOD_NAME", "NAMED_PARAM", "BOGUS", "RESULT_VARIABLE_REF", "SQL_NODE"};
    public static final BitSet _tokenSet_0 = new BitSet(SqlGeneratorBase.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SqlGeneratorBase.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SqlGeneratorBase.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(SqlGeneratorBase.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(SqlGeneratorBase.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(SqlGeneratorBase.mk_tokenSet_5());

    protected void out(String string) {
        this.getStringBuilder().append(string);
    }

    protected int getLastChar() {
        int n = this.buf.length();
        if (n == 0) {
            return -1;
        }
        return this.buf.charAt(n - 1);
    }

    protected void optionalSpace() {
    }

    protected void out(AST aST) {
        this.out(aST.getText());
    }

    protected void separator(AST aST, String string) {
        if (aST.getNextSibling() != null) {
            this.out(string);
        }
    }

    protected boolean hasText(AST aST) {
        String string = aST.getText();
        return string != null && string.length() > 0;
    }

    protected void fromFragmentSeparator(AST aST) {
    }

    protected void nestedFromFragment(AST aST, AST aST2) {
    }

    protected StringBuilder getStringBuilder() {
        return this.captureExpression ? this.expr : this.buf;
    }

    protected void nyi(AST aST) {
        throw new UnsupportedOperationException("Unsupported node: " + aST);
    }

    protected void beginFunctionTemplate(AST aST, AST aST2) {
        this.out(aST2);
        this.out("(");
    }

    protected void endFunctionTemplate(AST aST) {
        this.out(")");
    }

    protected void commaBetweenParameters(String string) {
        this.out(string);
    }

    protected void captureExpressionStart() {
        this.captureExpression = true;
    }

    protected void captureExpressionFinish() {
        this.captureExpression = false;
    }

    protected String resetCapture() {
        String string = this.expr.toString();
        this.expr = new StringBuilder();
        return string;
    }

    protected String renderOrderByElement(String string, String string2, String string3) {
        throw new UnsupportedOperationException("Concrete SQL generator should override this method.");
    }

    public SqlGeneratorBase() {
        this.tokenNames = _tokenNames;
    }

    public final void statement(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 45: {
                    this.selectStatement(aST);
                    aST = this._retTree;
                    break;
                }
                case 51: {
                    this.updateStatement(aST);
                    aST = this._retTree;
                    break;
                }
                case 13: {
                    this.deleteStatement(aST);
                    aST = this._retTree;
                    break;
                }
                case 29: {
                    this.insertStatement(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void selectStatement(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3;
            AST aST4;
            AST aST5 = aST;
            AST aST6 = aST;
            this.match(aST, 45);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out("select ");
            }
            this.selectClause(aST);
            aST = this._retTree;
            this.from(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 53: {
                    aST4 = aST;
                    aST3 = aST;
                    this.match(aST, 53);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(" where ");
                    }
                    this.whereExpr(aST);
                    aST = this._retTree;
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 3: 
                case 24: 
                case 41: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 24: {
                    aST4 = aST;
                    aST3 = aST;
                    this.match(aST, 24);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(" group by ");
                    }
                    this.groupExprs(aST);
                    aST = this._retTree;
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 25: {
                            AST aST7 = aST;
                            AST aST8 = aST;
                            this.match(aST, 25);
                            aST = aST.getFirstChild();
                            if (this.inputState.guessing == 0) {
                                this.out(" having ");
                            }
                            this.booleanExpr(aST, false);
                            aST = this._retTree;
                            aST = aST7;
                            aST = aST.getNextSibling();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 3: 
                case 41: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 41: {
                    aST4 = aST;
                    aST3 = aST;
                    this.match(aST, 41);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(" order by ");
                    }
                    this.orderExprs(aST);
                    aST = this._retTree;
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST5;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void updateStatement(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 51);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out("update ");
            }
            AST aST5 = aST;
            AST aST6 = aST;
            this.match(aST, 22);
            aST = aST.getFirstChild();
            this.fromTable(aST);
            aST = this._retTree;
            aST = aST5;
            aST = aST.getNextSibling();
            this.setClause(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 53: {
                    this.whereClause(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void deleteStatement(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 13);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out("delete");
            }
            this.from(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 53: {
                    this.whereClause(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void insertStatement(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            AST aST4 = aST;
            AST aST5 = aST;
            this.match(aST, 29);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out("insert ");
            }
            aST3 = aST;
            this.match(aST, 30);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.out(aST3);
                this.out(" ");
            }
            this.selectStatement(aST);
            aST = this._retTree;
            aST = aST4;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void selectClause(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 140);
            aST = aST.getFirstChild();
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 4: 
                case 16: {
                    this.distinctOrAll(aST);
                    aST = this._retTree;
                    break;
                }
                case 12: 
                case 15: 
                case 20: 
                case 45: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 77: 
                case 84: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 147: 
                case 154: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            int n = 0;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_0.member(aST.getType())) {
                    if (n >= 1) break;
                    throw new NoViableAltException(aST);
                }
                this.selectColumn(aST);
                aST = this._retTree;
                ++n;
            }
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void from(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            AST aST4 = aST;
            aST3 = aST == ASTNULL ? null : aST;
            this.match(aST, 22);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out(" from ");
            }
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() != 137 && aST.getType() != 139) break;
                this.fromTable(aST);
                aST = this._retTree;
            }
            aST = aST4;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void whereExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            block1 : switch (aST.getType()) {
                case 149: {
                    this.filters(aST);
                    aST = this._retTree;
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 148: {
                            if (this.inputState.guessing == 0) {
                                this.out(" and ");
                            }
                            this.thetaJoins(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 10: 
                        case 19: 
                        case 26: 
                        case 34: 
                        case 38: 
                        case 40: 
                        case 82: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 105: 
                        case 112: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 145: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 6: 
                        case 10: 
                        case 19: 
                        case 26: 
                        case 34: 
                        case 38: 
                        case 40: 
                        case 82: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 105: 
                        case 112: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 145: {
                            if (this.inputState.guessing == 0) {
                                this.out(" and ");
                            }
                            this.booleanExpr(aST, true);
                            aST = this._retTree;
                            break block1;
                        }
                        case 3: {
                            break block1;
                        }
                    }
                    throw new NoViableAltException(aST);
                }
                case 148: {
                    this.thetaJoins(aST);
                    aST = this._retTree;
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 6: 
                        case 10: 
                        case 19: 
                        case 26: 
                        case 34: 
                        case 38: 
                        case 40: 
                        case 82: 
                        case 83: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 105: 
                        case 112: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 145: {
                            if (this.inputState.guessing == 0) {
                                this.out(" and ");
                            }
                            this.booleanExpr(aST, true);
                            aST = this._retTree;
                            break block1;
                        }
                        case 3: {
                            break block1;
                        }
                    }
                    throw new NoViableAltException(aST);
                }
                case 6: 
                case 10: 
                case 19: 
                case 26: 
                case 34: 
                case 38: 
                case 40: 
                case 82: 
                case 83: 
                case 85: 
                case 86: 
                case 87: 
                case 105: 
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 145: {
                    this.booleanExpr(aST, false);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void groupExprs(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            this.expr(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 4: 
                case 5: 
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 45: 
                case 47: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    if (this.inputState.guessing == 0) {
                        this.out(" , ");
                    }
                    this.groupExprs(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: 
                case 25: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void booleanExpr(AST aST, boolean bl) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 6: 
                case 38: 
                case 40: {
                    this.booleanOp(aST, bl);
                    aST = this._retTree;
                    break;
                }
                case 10: 
                case 19: 
                case 26: 
                case 34: 
                case 82: 
                case 83: 
                case 85: 
                case 86: 
                case 87: 
                case 105: 
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    this.comparisonExpr(aST, bl);
                    aST = this._retTree;
                    break;
                }
                case 145: {
                    aST3 = aST;
                    this.match(aST, 145);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST3);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void orderExprs(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (this.inputState.guessing == 0) {
                this.captureExpressionStart();
            }
            this.expr(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                this.captureExpressionFinish();
                string = this.resetCapture();
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 8: 
                case 14: {
                    aST3 = aST == ASTNULL ? null : aST;
                    this.orderDirection(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing != 0) break;
                    string2 = aST3.getText();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 45: 
                case 47: 
                case 49: 
                case 54: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 54: {
                    string3 = this.nullOrdering(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 45: 
                case 47: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (this.inputState.guessing == 0) {
                this.out(this.renderOrderByElement(string, string2, string3));
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 4: 
                case 5: 
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 45: 
                case 47: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    if (this.inputState.guessing == 0) {
                        this.out(", ");
                    }
                    this.orderExprs(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void fromTable(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 137: {
                    AST aST5 = aST;
                    aST3 = aST == ASTNULL ? null : aST;
                    this.match(aST, 137);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(aST3);
                    }
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 137 && aST.getType() != 139) break;
                        this.tableJoin(aST, aST3);
                        aST = this._retTree;
                    }
                    if (this.inputState.guessing == 0) {
                        this.fromFragmentSeparator(aST3);
                    }
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 139: {
                    AST aST6 = aST;
                    aST4 = aST == ASTNULL ? null : aST;
                    this.match(aST, 139);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(aST4);
                    }
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 137 && aST.getType() != 139) break;
                        this.tableJoin(aST, aST4);
                        aST = this._retTree;
                    }
                    if (this.inputState.guessing == 0) {
                        this.fromFragmentSeparator(aST4);
                    }
                    aST = aST6;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void setClause(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 46);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out(" set ");
            }
            this.comparisonExpr(aST, false);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_1.member(aST.getType())) break;
                if (this.inputState.guessing == 0) {
                    this.out(", ");
                }
                this.comparisonExpr(aST, false);
                aST = this._retTree;
            }
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void whereClause(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 53);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out(" where ");
            }
            this.whereClauseExpr(aST);
            aST = this._retTree;
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void comparisonExpr(AST aST, boolean bl) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 105: 
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    this.binaryComparisonExpression(aST);
                    aST = this._retTree;
                    break;
                }
                case 10: 
                case 19: 
                case 26: 
                case 34: 
                case 82: 
                case 83: 
                case 85: 
                case 86: 
                case 87: {
                    if (this.inputState.guessing == 0 && bl) {
                        this.out("(");
                    }
                    this.exoticComparisonExpression(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0 && bl) {
                        this.out(")");
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void whereClauseExpr(AST aST) throws RecognitionException {
        block10: {
            AST aST2 = aST == ASTNULL ? null : aST;
            try {
                boolean bl = false;
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 145) {
                    AST aST3 = aST;
                    bl = true;
                    ++this.inputState.guessing;
                    try {
                        AST aST4 = aST;
                        this.match(aST, 145);
                        aST = aST.getNextSibling();
                    }
                    catch (RecognitionException recognitionException) {
                        bl = false;
                    }
                    aST = aST3;
                    --this.inputState.guessing;
                }
                if (bl) {
                    this.conditionList(aST);
                    aST = this._retTree;
                    break block10;
                }
                if (_tokenSet_2.member(aST.getType())) {
                    this.booleanExpr(aST, false);
                    aST = this._retTree;
                    break block10;
                }
                throw new NoViableAltException(aST);
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void conditionList(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            this.sqlToken(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 145: {
                    if (this.inputState.guessing == 0) {
                        this.out(" and ");
                    }
                    this.conditionList(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void expr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    this.simpleExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 95: {
                    this.tupleExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 45: {
                    this.parenSelect(aST);
                    aST = this._retTree;
                    break;
                }
                case 5: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 5);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out("any ");
                    }
                    this.quantified(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 4: {
                    AST aST5 = aST;
                    AST aST6 = aST;
                    this.match(aST, 4);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out("all ");
                    }
                    this.quantified(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 47: {
                    AST aST7 = aST;
                    AST aST8 = aST;
                    this.match(aST, 47);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out("some ");
                    }
                    this.quantified(aST);
                    aST = this._retTree;
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void orderDirection(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 8: {
                    AST aST3 = aST;
                    this.match(aST, 8);
                    aST = aST.getNextSibling();
                    break;
                }
                case 14: {
                    AST aST4 = aST;
                    this.match(aST, 14);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final String nullOrdering(AST aST) throws RecognitionException {
        String string = null;
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            AST aST4 = aST;
            this.match(aST, 54);
            aST = aST.getNextSibling();
            aST3 = aST == ASTNULL ? null : aST;
            this.nullPrecedence(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                string = aST3.getText();
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
        return string;
    }

    public final void nullPrecedence(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 55: {
                    AST aST3 = aST;
                    this.match(aST, 55);
                    aST = aST.getNextSibling();
                    break;
                }
                case 56: {
                    AST aST4 = aST;
                    this.match(aST, 56);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void filters(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 149);
            aST = aST.getFirstChild();
            this.conditionList(aST);
            aST = this._retTree;
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void thetaJoins(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 148);
            aST = aST.getFirstChild();
            this.conditionList(aST);
            aST = this._retTree;
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void sqlToken(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            aST3 = aST;
            this.match(aST, 145);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.out(aST3);
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void distinctOrAll(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 16: {
                    AST aST3 = aST;
                    this.match(aST, 16);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out("distinct ");
                    }
                    break;
                }
                case 4: {
                    AST aST4 = aST;
                    this.match(aST, 4);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out("all ");
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void selectColumn(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        try {
            aST3 = aST == ASTNULL ? null : aST;
            this.selectExpr(aST);
            aST = this._retTree;
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 146: {
                    aST4 = aST;
                    this.match(aST, 146);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing != 0) break;
                    this.out(aST4);
                    break;
                }
                case 3: 
                case 12: 
                case 15: 
                case 20: 
                case 45: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 77: 
                case 84: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 147: 
                case 154: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (this.inputState.guessing == 0) {
                this.separator(aST4 != null ? aST4 : aST3, ", ");
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void selectExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        AST aST5 = null;
        AST aST6 = null;
        AST aST7 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 15: 
                case 143: 
                case 145: 
                case 147: {
                    aST3 = aST == ASTNULL ? null : aST;
                    this.selectAtom(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(aST3);
                    }
                    break;
                }
                case 71: 
                case 72: 
                case 73: {
                    aST4 = aST == ASTNULL ? null : aST;
                    this.mapComponentReference(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(aST4);
                    }
                    break;
                }
                case 12: {
                    this.count(aST);
                    aST = this._retTree;
                    break;
                }
                case 76: {
                    AST aST8 = aST;
                    AST aST9 = aST;
                    this.match(aST, 76);
                    aST = aST.getFirstChild();
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 15: {
                            AST aST10 = aST;
                            this.match(aST, 15);
                            aST = aST.getNextSibling();
                            break;
                        }
                        case 111: {
                            AST aST10 = aST;
                            this.match(aST, 111);
                            aST = aST.getNextSibling();
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    int n = 0;
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (!_tokenSet_0.member(aST.getType())) {
                            if (n >= 1) break;
                            throw new NoViableAltException(aST);
                        }
                        this.selectColumn(aST);
                        aST = this._retTree;
                        ++n;
                    }
                    aST = aST8;
                    aST = aST.getNextSibling();
                    break;
                }
                case 84: {
                    this.methodCall(aST);
                    aST = this._retTree;
                    break;
                }
                case 74: {
                    this.aggregate(aST);
                    aST = this._retTree;
                    break;
                }
                case 20: 
                case 49: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 128: 
                case 129: {
                    aST5 = aST == ASTNULL ? null : aST;
                    this.constant(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(aST5);
                    }
                    break;
                }
                case 57: 
                case 77: 
                case 93: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: {
                    this.arithmeticExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 127: {
                    aST6 = aST;
                    this.match(aST, 127);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST6);
                    }
                    break;
                }
                case 154: {
                    aST7 = aST;
                    this.match(aST, 154);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST7);
                    }
                    break;
                }
                case 45: {
                    if (this.inputState.guessing == 0) {
                        this.out("(");
                    }
                    this.selectStatement(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(")");
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void selectAtom(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 15: {
                    AST aST3 = aST;
                    this.match(aST, 15);
                    aST = aST.getNextSibling();
                    break;
                }
                case 145: {
                    AST aST4 = aST;
                    this.match(aST, 145);
                    aST = aST.getNextSibling();
                    break;
                }
                case 143: {
                    AST aST5 = aST;
                    this.match(aST, 143);
                    aST = aST.getNextSibling();
                    break;
                }
                case 147: {
                    AST aST6 = aST;
                    this.match(aST, 147);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void mapComponentReference(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 71: {
                    AST aST3 = aST;
                    this.match(aST, 71);
                    aST = aST.getNextSibling();
                    break;
                }
                case 72: {
                    AST aST4 = aST;
                    this.match(aST, 72);
                    aST = aST.getNextSibling();
                    break;
                }
                case 73: {
                    AST aST5 = aST;
                    this.match(aST, 73);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void count(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 12);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out("count(");
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 4: 
                case 16: {
                    this.distinctOrAll(aST);
                    aST = this._retTree;
                    break;
                }
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 91: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            this.countExpr(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                this.out(")");
            }
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void methodCall(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        try {
            AST aST5 = aST;
            aST3 = aST == ASTNULL ? null : aST;
            this.match(aST, 84);
            aST4 = aST = aST.getFirstChild();
            this.match(aST, 150);
            aST = aST.getNextSibling();
            if (this.inputState.guessing == 0) {
                this.beginFunctionTemplate(aST3, aST4);
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 78: {
                    AST aST6 = aST;
                    AST aST7 = aST;
                    this.match(aST, 78);
                    aST = aST.getFirstChild();
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 4: 
                        case 5: 
                        case 12: 
                        case 15: 
                        case 20: 
                        case 39: 
                        case 45: 
                        case 47: 
                        case 49: 
                        case 57: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 77: 
                        case 81: 
                        case 84: 
                        case 93: 
                        case 95: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 111: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 143: 
                        case 145: 
                        case 151: 
                        case 153: {
                            this.arguments(aST);
                            aST = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    aST = aST6;
                    aST = aST.getNextSibling();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (this.inputState.guessing == 0) {
                this.endFunctionTemplate(aST3);
            }
            aST = aST5;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void aggregate(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            AST aST4 = aST;
            aST3 = aST == ASTNULL ? null : aST;
            this.match(aST, 74);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.beginFunctionTemplate(aST3, aST3);
            }
            this.expr(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                this.endFunctionTemplate(aST3);
            }
            aST = aST4;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void constant(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 98: {
                    AST aST3 = aST;
                    this.match(aST, 98);
                    aST = aST.getNextSibling();
                    break;
                }
                case 99: {
                    AST aST4 = aST;
                    this.match(aST, 99);
                    aST = aST.getNextSibling();
                    break;
                }
                case 128: {
                    AST aST5 = aST;
                    this.match(aST, 128);
                    aST = aST.getNextSibling();
                    break;
                }
                case 100: {
                    AST aST6 = aST;
                    this.match(aST, 100);
                    aST = aST.getNextSibling();
                    break;
                }
                case 101: {
                    AST aST7 = aST;
                    this.match(aST, 101);
                    aST = aST.getNextSibling();
                    break;
                }
                case 102: {
                    AST aST8 = aST;
                    this.match(aST, 102);
                    aST = aST.getNextSibling();
                    break;
                }
                case 129: {
                    AST aST9 = aST;
                    this.match(aST, 129);
                    aST = aST.getNextSibling();
                    break;
                }
                case 97: {
                    AST aST10 = aST;
                    this.match(aST, 97);
                    aST = aST.getNextSibling();
                    break;
                }
                case 103: {
                    AST aST11 = aST;
                    this.match(aST, 103);
                    aST = aST.getNextSibling();
                    break;
                }
                case 49: {
                    AST aST12 = aST;
                    this.match(aST, 49);
                    aST = aST.getNextSibling();
                    break;
                }
                case 20: {
                    AST aST13 = aST;
                    this.match(aST, 20);
                    aST = aST.getNextSibling();
                    break;
                }
                case 111: {
                    AST aST14 = aST;
                    this.match(aST, 111);
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void arithmeticExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 119: 
                case 120: {
                    this.additiveExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 121: 
                case 122: 
                case 123: {
                    this.multiplicativeExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 93: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 93);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out("-");
                    }
                    this.nestedExprAfterMinusDiv(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 57: 
                case 77: {
                    this.caseExpr(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void countExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 91: {
                    AST aST3 = aST;
                    this.match(aST, 91);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out("*");
                    }
                    break;
                }
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    this.simpleExpr(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void simpleExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 20: 
                case 49: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 128: 
                case 129: {
                    aST3 = aST == ASTNULL ? null : aST;
                    this.constant(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(aST3);
                    }
                    break;
                }
                case 39: {
                    AST aST4 = aST;
                    this.match(aST, 39);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out("null");
                    }
                    break;
                }
                case 15: 
                case 71: 
                case 72: 
                case 73: 
                case 81: 
                case 143: 
                case 153: {
                    this.addrExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 145: {
                    this.sqlToken(aST);
                    aST = this._retTree;
                    break;
                }
                case 74: {
                    this.aggregate(aST);
                    aST = this._retTree;
                    break;
                }
                case 84: {
                    this.methodCall(aST);
                    aST = this._retTree;
                    break;
                }
                case 12: {
                    this.count(aST);
                    aST = this._retTree;
                    break;
                }
                case 127: 
                case 151: {
                    this.parameter(aST);
                    aST = this._retTree;
                    break;
                }
                case 57: 
                case 77: 
                case 93: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: {
                    this.arithmeticExpr(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void tableJoin(AST aST, AST aST2) throws RecognitionException {
        AST aST3 = aST == ASTNULL ? null : aST;
        AST aST4 = null;
        AST aST5 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 139: {
                    AST aST6 = aST;
                    aST4 = aST == ASTNULL ? null : aST;
                    this.match(aST, 139);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(" ");
                        this.out(aST4);
                    }
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 137 && aST.getType() != 139) break;
                        this.tableJoin(aST, aST4);
                        aST = this._retTree;
                    }
                    aST = aST6;
                    aST = aST.getNextSibling();
                    break;
                }
                case 137: {
                    AST aST7 = aST;
                    aST5 = aST == ASTNULL ? null : aST;
                    this.match(aST, 137);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.nestedFromFragment(aST5, aST2);
                    }
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() != 137 && aST.getType() != 139) break;
                        this.tableJoin(aST, aST5);
                        aST = this._retTree;
                    }
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void booleanOp(AST aST, boolean bl) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 6: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 6);
                    aST = aST.getFirstChild();
                    this.booleanExpr(aST, true);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" and ");
                    }
                    this.booleanExpr(aST, true);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 40: {
                    AST aST5 = aST;
                    AST aST6 = aST;
                    this.match(aST, 40);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0 && bl) {
                        this.out("(");
                    }
                    this.booleanExpr(aST, false);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" or ");
                    }
                    this.booleanExpr(aST, false);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0 && bl) {
                        this.out(")");
                    }
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 38: {
                    AST aST7 = aST;
                    AST aST8 = aST;
                    this.match(aST, 38);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(" not (");
                    }
                    this.booleanExpr(aST, false);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(")");
                    }
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void binaryComparisonExpression(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 105: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 105);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("=");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 112: {
                    AST aST5 = aST;
                    AST aST6 = aST;
                    this.match(aST, 112);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("<>");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 115: {
                    AST aST7 = aST;
                    AST aST8 = aST;
                    this.match(aST, 115);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(">");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                case 117: {
                    AST aST9 = aST;
                    AST aST10 = aST;
                    this.match(aST, 117);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(">=");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST9;
                    aST = aST.getNextSibling();
                    break;
                }
                case 114: {
                    AST aST11 = aST;
                    AST aST12 = aST;
                    this.match(aST, 114);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("<");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST11;
                    aST = aST.getNextSibling();
                    break;
                }
                case 116: {
                    AST aST13 = aST;
                    AST aST14 = aST;
                    this.match(aST, 116);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("<=");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST13;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void exoticComparisonExpression(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 34: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 34);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" like ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    this.likeEscape(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 87: {
                    AST aST5 = aST;
                    AST aST6 = aST;
                    this.match(aST, 87);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" not like ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    this.likeEscape(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 10: {
                    AST aST7 = aST;
                    AST aST8 = aST;
                    this.match(aST, 10);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" between ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" and ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                case 85: {
                    AST aST9 = aST;
                    AST aST10 = aST;
                    this.match(aST, 85);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" not between ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" and ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST9;
                    aST = aST.getNextSibling();
                    break;
                }
                case 26: {
                    AST aST11 = aST;
                    AST aST12 = aST;
                    this.match(aST, 26);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" in");
                    }
                    this.inList(aST);
                    aST = this._retTree;
                    aST = aST11;
                    aST = aST.getNextSibling();
                    break;
                }
                case 86: {
                    AST aST13 = aST;
                    AST aST14 = aST;
                    this.match(aST, 86);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" not in ");
                    }
                    this.inList(aST);
                    aST = this._retTree;
                    aST = aST13;
                    aST = aST.getNextSibling();
                    break;
                }
                case 19: {
                    AST aST15 = aST;
                    AST aST16 = aST;
                    this.match(aST, 19);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.optionalSpace();
                        this.out("exists ");
                    }
                    this.quantified(aST);
                    aST = this._retTree;
                    aST = aST15;
                    aST = aST.getNextSibling();
                    break;
                }
                case 83: {
                    AST aST17 = aST;
                    AST aST18 = aST;
                    this.match(aST, 83);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST17;
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(" is null");
                    }
                    break;
                }
                case 82: {
                    AST aST19 = aST;
                    AST aST20 = aST;
                    this.match(aST, 82);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST19;
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(" is not null");
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void likeEscape(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 18: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 18);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out(" escape ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void inList(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            AST aST3 = aST;
            AST aST4 = aST;
            this.match(aST, 80);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out(" ");
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 45: {
                    this.parenSelect(aST);
                    aST = this._retTree;
                    break;
                }
                case 3: 
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    this.simpleExprList(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            aST = aST3;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void quantified(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (this.inputState.guessing == 0) {
                this.out("(");
            }
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 145: {
                    this.sqlToken(aST);
                    aST = this._retTree;
                    break;
                }
                case 45: {
                    this.selectStatement(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
            if (this.inputState.guessing == 0) {
                this.out(")");
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void parenSelect(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (this.inputState.guessing == 0) {
                this.out("(");
            }
            this.selectStatement(aST);
            aST = this._retTree;
            if (this.inputState.guessing == 0) {
                this.out(")");
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void simpleExprList(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            if (this.inputState.guessing == 0) {
                this.out("(");
            }
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_3.member(aST.getType())) break;
                aST3 = aST == ASTNULL ? null : aST;
                this.simpleOrTupleExpr(aST);
                aST = this._retTree;
                if (this.inputState.guessing != 0) continue;
                this.separator(aST3, " , ");
            }
            if (this.inputState.guessing == 0) {
                this.out(")");
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void simpleOrTupleExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 12: 
                case 15: 
                case 20: 
                case 39: 
                case 49: 
                case 57: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 77: 
                case 81: 
                case 84: 
                case 93: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 111: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 128: 
                case 129: 
                case 143: 
                case 145: 
                case 151: 
                case 153: {
                    this.simpleExpr(aST);
                    aST = this._retTree;
                    break;
                }
                case 95: {
                    this.tupleExpr(aST);
                    aST = this._retTree;
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void tupleExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        try {
            AST aST4 = aST;
            AST aST5 = aST;
            this.match(aST, 95);
            aST = aST.getFirstChild();
            if (this.inputState.guessing == 0) {
                this.out("(");
            }
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (!_tokenSet_4.member(aST.getType())) break;
                aST3 = aST == ASTNULL ? null : aST;
                this.expr(aST);
                aST = this._retTree;
                if (this.inputState.guessing != 0) continue;
                this.separator(aST3, " , ");
            }
            if (this.inputState.guessing == 0) {
                this.out(")");
            }
            aST = aST4;
            aST = aST.getNextSibling();
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void addrExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        AST aST5 = null;
        AST aST6 = null;
        AST aST7 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 15: {
                    AST aST8 = aST;
                    aST3 = aST == ASTNULL ? null : aST;
                    this.match(aST, 15);
                    AST aST9 = aST = aST.getFirstChild();
                    if (aST == null) {
                        throw new MismatchedTokenException();
                    }
                    AST aST10 = aST = aST.getNextSibling();
                    if (aST == null) {
                        throw new MismatchedTokenException();
                    }
                    aST = aST.getNextSibling();
                    aST = aST8;
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST3);
                    }
                    break;
                }
                case 143: {
                    aST4 = aST;
                    this.match(aST, 143);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST4);
                    }
                    break;
                }
                case 81: {
                    aST5 = aST;
                    this.match(aST, 81);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST5);
                    }
                    break;
                }
                case 153: {
                    aST6 = aST;
                    this.match(aST, 153);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST6);
                    }
                    break;
                }
                case 71: 
                case 72: 
                case 73: {
                    aST7 = aST == ASTNULL ? null : aST;
                    this.mapComponentReference(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(aST7);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void parameter(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 151: {
                    aST3 = aST;
                    this.match(aST, 151);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST3);
                    }
                    break;
                }
                case 127: {
                    aST4 = aST;
                    this.match(aST, 127);
                    aST = aST.getNextSibling();
                    if (this.inputState.guessing == 0) {
                        this.out(aST4);
                    }
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void additiveExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 119: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 119);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("+");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 120: {
                    AST aST5 = aST;
                    AST aST6 = aST;
                    this.match(aST, 120);
                    aST = aST.getFirstChild();
                    this.expr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("-");
                    }
                    this.nestedExprAfterMinusDiv(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void multiplicativeExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 121: {
                    AST aST3 = aST;
                    AST aST4 = aST;
                    this.match(aST, 121);
                    aST = aST.getFirstChild();
                    this.nestedExpr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("*");
                    }
                    this.nestedExpr(aST);
                    aST = this._retTree;
                    aST = aST3;
                    aST = aST.getNextSibling();
                    break;
                }
                case 122: {
                    AST aST5 = aST;
                    AST aST6 = aST;
                    this.match(aST, 122);
                    aST = aST.getFirstChild();
                    this.nestedExpr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out("/");
                    }
                    this.nestedExprAfterMinusDiv(aST);
                    aST = this._retTree;
                    aST = aST5;
                    aST = aST.getNextSibling();
                    break;
                }
                case 123: {
                    AST aST7 = aST;
                    AST aST8 = aST;
                    this.match(aST, 123);
                    aST = aST.getFirstChild();
                    this.nestedExpr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(" % ");
                    }
                    this.nestedExprAfterMinusDiv(aST);
                    aST = this._retTree;
                    aST = aST7;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void nestedExprAfterMinusDiv(AST aST) throws RecognitionException {
        block12: {
            AST aST2 = aST == ASTNULL ? null : aST;
            try {
                boolean bl = false;
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (_tokenSet_5.member(aST.getType())) {
                    AST aST3 = aST;
                    bl = true;
                    ++this.inputState.guessing;
                    try {
                        this.arithmeticExpr(aST);
                        aST = this._retTree;
                    }
                    catch (RecognitionException recognitionException) {
                        bl = false;
                    }
                    aST = aST3;
                    --this.inputState.guessing;
                }
                if (bl) {
                    if (this.inputState.guessing == 0) {
                        this.out("(");
                    }
                    this.arithmeticExpr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(")");
                    }
                    break block12;
                }
                if (_tokenSet_4.member(aST.getType())) {
                    this.expr(aST);
                    aST = this._retTree;
                    break block12;
                }
                throw new NoViableAltException(aST);
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void caseExpr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            if (aST == null) {
                aST = ASTNULL;
            }
            switch (aST.getType()) {
                case 57: {
                    AST aST3;
                    AST aST4 = aST;
                    AST aST5 = aST;
                    this.match(aST, 57);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out("case");
                    }
                    int n = 0;
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() == 61) {
                            aST3 = aST;
                            AST aST6 = aST;
                            this.match(aST, 61);
                            aST = aST.getFirstChild();
                            if (this.inputState.guessing == 0) {
                                this.out(" when ");
                            }
                            this.booleanExpr(aST, false);
                            aST = this._retTree;
                            if (this.inputState.guessing == 0) {
                                this.out(" then ");
                            }
                        } else {
                            if (n >= 1) break;
                            throw new NoViableAltException(aST);
                        }
                        this.expr(aST);
                        aST = this._retTree;
                        aST = aST3;
                        aST = aST.getNextSibling();
                        ++n;
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 59: {
                            AST aST7 = aST;
                            aST3 = aST;
                            this.match(aST, 59);
                            aST = aST.getFirstChild();
                            if (this.inputState.guessing == 0) {
                                this.out(" else ");
                            }
                            this.expr(aST);
                            aST = this._retTree;
                            aST = aST7;
                            aST = aST.getNextSibling();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    if (this.inputState.guessing == 0) {
                        this.out(" end");
                    }
                    aST = aST4;
                    aST = aST.getNextSibling();
                    break;
                }
                case 77: {
                    AST aST8;
                    AST aST9 = aST;
                    AST aST10 = aST;
                    this.match(aST, 77);
                    aST = aST.getFirstChild();
                    if (this.inputState.guessing == 0) {
                        this.out("case ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    int n = 0;
                    while (true) {
                        if (aST == null) {
                            aST = ASTNULL;
                        }
                        if (aST.getType() == 61) {
                            aST8 = aST;
                            AST aST11 = aST;
                            this.match(aST, 61);
                            aST = aST.getFirstChild();
                            if (this.inputState.guessing == 0) {
                                this.out(" when ");
                            }
                            this.expr(aST);
                            aST = this._retTree;
                            if (this.inputState.guessing == 0) {
                                this.out(" then ");
                            }
                        } else {
                            if (n >= 1) break;
                            throw new NoViableAltException(aST);
                        }
                        this.expr(aST);
                        aST = this._retTree;
                        aST = aST8;
                        aST = aST.getNextSibling();
                        ++n;
                    }
                    if (aST == null) {
                        aST = ASTNULL;
                    }
                    switch (aST.getType()) {
                        case 59: {
                            AST aST12 = aST;
                            aST8 = aST;
                            this.match(aST, 59);
                            aST = aST.getFirstChild();
                            if (this.inputState.guessing == 0) {
                                this.out(" else ");
                            }
                            this.expr(aST);
                            aST = this._retTree;
                            aST = aST12;
                            aST = aST.getNextSibling();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(aST);
                        }
                    }
                    if (this.inputState.guessing == 0) {
                        this.out(" end");
                    }
                    aST = aST9;
                    aST = aST.getNextSibling();
                    break;
                }
                default: {
                    throw new NoViableAltException(aST);
                }
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    public final void nestedExpr(AST aST) throws RecognitionException {
        block12: {
            AST aST2 = aST == ASTNULL ? null : aST;
            try {
                boolean bl = false;
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (aST.getType() == 119 || aST.getType() == 120) {
                    AST aST3 = aST;
                    bl = true;
                    ++this.inputState.guessing;
                    try {
                        this.additiveExpr(aST);
                        aST = this._retTree;
                    }
                    catch (RecognitionException recognitionException) {
                        bl = false;
                    }
                    aST = aST3;
                    --this.inputState.guessing;
                }
                if (bl) {
                    if (this.inputState.guessing == 0) {
                        this.out("(");
                    }
                    this.additiveExpr(aST);
                    aST = this._retTree;
                    if (this.inputState.guessing == 0) {
                        this.out(")");
                    }
                    break block12;
                }
                if (_tokenSet_4.member(aST.getType())) {
                    this.expr(aST);
                    aST = this._retTree;
                    break block12;
                }
                throw new NoViableAltException(aST);
            }
            catch (RecognitionException recognitionException) {
                if (this.inputState.guessing == 0) {
                    this.reportError(recognitionException);
                    if (aST != null) {
                        aST = aST.getNextSibling();
                    }
                }
                throw recognitionException;
            }
        }
        this._retTree = aST;
    }

    public final void arguments(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        try {
            this.expr(aST);
            aST = this._retTree;
            while (true) {
                if (aST == null) {
                    aST = ASTNULL;
                }
                if (_tokenSet_4.member(aST.getType())) {
                    if (this.inputState.guessing == 0) {
                        this.commaBetweenParameters(", ");
                    }
                    this.expr(aST);
                    aST = this._retTree;
                    continue;
                }
                break;
            }
        }
        catch (RecognitionException recognitionException) {
            if (this.inputState.guessing == 0) {
                this.reportError(recognitionException);
                if (aST != null) {
                    aST = aST.getNextSibling();
                }
            }
            throw recognitionException;
        }
        this._retTree = aST;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[]{144713322402451456L, -8106337500318910592L, 67796995L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[]{0x404080400L, 17172172618072064L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_2() {
        long[] lArray = new long[]{1391637038144L, 17172172618072064L, 131072L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_3() {
        long[] lArray = new long[]{144678687786176512L, -8106337498171299968L, 42106883L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_4() {
        long[] lArray = new long[]{144854609646620720L, -8106337498171299968L, 42106883L, 0L, 0L, 0L};
        return lArray;
    }

    private static final long[] mk_tokenSet_5() {
        long[] lArray = new long[]{0x200000000000000L, 1116892708124762112L, 0L, 0L};
        return lArray;
    }
}

