/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.classic.ParserHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public final class QuerySplitter {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, QuerySplitter.class.getName());
    private static final Set BEFORE_CLASS_TOKENS = new HashSet();
    private static final Set NOT_AFTER_CLASS_TOKENS = new HashSet();

    private QuerySplitter() {
    }

    public static String[] concreteQueries(String string, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        String[] stringArray = StringHelper.split(" \n\r\f\t(),", string, true);
        if (stringArray.length == 0) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        StringBuilder stringBuilder = new StringBuilder(40);
        int n = QuerySplitter.getStartingPositionFor(stringArray, stringBuilder);
        int n2 = 0;
        String string2 = null;
        String string3 = stringArray[n - 1].toLowerCase();
        for (int i = n; i < stringArray.length; ++i) {
            String string4;
            String string5 = stringArray[i];
            if (ParserHelper.isWhitespace(string5)) {
                stringBuilder.append(string5);
                continue;
            }
            string2 = QuerySplitter.nextNonWhite(stringArray, i).toLowerCase();
            boolean bl = QuerySplitter.isJavaIdentifier(string5) && QuerySplitter.isPossiblyClassName(string3, string2);
            string3 = string5.toLowerCase();
            if (bl && (string4 = QuerySplitter.getImportedClass(string5, sessionFactoryImplementor)) != null) {
                String[] stringArray2 = sessionFactoryImplementor.getImplementors(string4);
                string5 = "$clazz" + n2++ + "$";
                if (stringArray2 != null) {
                    arrayList.add(string5);
                    arrayList2.add(stringArray2);
                }
            }
            stringBuilder.append(string5);
        }
        String[] stringArray3 = StringHelper.multiply(stringBuilder.toString(), arrayList.iterator(), arrayList2.iterator());
        if (stringArray3.length == 0) {
            LOG.noPersistentClassesFound(string);
        }
        return stringArray3;
    }

    private static String nextNonWhite(String[] stringArray, int n) {
        for (int i = n + 1; i < stringArray.length; ++i) {
            if (ParserHelper.isWhitespace(stringArray[i])) continue;
            return stringArray[i];
        }
        return stringArray[stringArray.length - 1];
    }

    private static int getStartingPositionFor(String[] stringArray, StringBuilder stringBuilder) {
        stringBuilder.append(stringArray[0]);
        if (!"select".equals(stringArray[0].toLowerCase())) {
            return 1;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            if ("from".equals(stringArray[i].toLowerCase())) {
                return i;
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringArray.length;
    }

    private static boolean isPossiblyClassName(String string, String string2) {
        return "class".equals(string) || BEFORE_CLASS_TOKENS.contains(string) && !NOT_AFTER_CLASS_TOKENS.contains(string2);
    }

    private static boolean isJavaIdentifier(String string) {
        return Character.isJavaIdentifierStart(string.charAt(0));
    }

    public static String getImportedClass(String string, SessionFactoryImplementor sessionFactoryImplementor) {
        return sessionFactoryImplementor.getImportedClassName(string);
    }

    static {
        BEFORE_CLASS_TOKENS.add("from");
        BEFORE_CLASS_TOKENS.add("delete");
        BEFORE_CLASS_TOKENS.add("update");
        BEFORE_CLASS_TOKENS.add(",");
        NOT_AFTER_CLASS_TOKENS.add("in");
        NOT_AFTER_CLASS_TOKENS.add("from");
        NOT_AFTER_CLASS_TOKENS.add(")");
    }
}

