/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.spi;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.spi.Configurable;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class SQLExceptionConverterFactory {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SQLExceptionConverterFactory.class.getName());

    private SQLExceptionConverterFactory() {
    }

    public static SQLExceptionConverter buildSQLExceptionConverter(Dialect dialect, Properties properties) throws HibernateException {
        SQLExceptionConverter sQLExceptionConverter = null;
        String string = (String)properties.get("hibernate.jdbc.sql_exception_converter");
        if (StringHelper.isNotEmpty(string)) {
            sQLExceptionConverter = SQLExceptionConverterFactory.constructConverter(string, dialect.getViolatedConstraintNameExtracter());
        }
        if (sQLExceptionConverter == null) {
            LOG.trace("Using dialect defined converter");
            sQLExceptionConverter = dialect.buildSQLExceptionConverter();
        }
        if (sQLExceptionConverter instanceof Configurable) {
            try {
                ((Configurable)((Object)sQLExceptionConverter)).configure(properties);
            }
            catch (HibernateException hibernateException) {
                LOG.unableToConfigureSqlExceptionConverter(hibernateException);
                throw hibernateException;
            }
        }
        return sQLExceptionConverter;
    }

    public static SQLExceptionConverter buildMinimalSQLExceptionConverter() {
        return new SQLExceptionConverter(){

            public JDBCException convert(SQLException sQLException, String string, String string2) {
                return new GenericJDBCException(string, sQLException, string2);
            }
        };
    }

    private static SQLExceptionConverter constructConverter(String string, ViolatedConstraintNameExtracter violatedConstraintNameExtracter) {
        try {
            LOG.tracev("Attempting to construct instance of specified SQLExceptionConverter [{0}]", (Object)string);
            Class clazz = ReflectHelper.classForName(string);
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                if (constructorArray[i].getParameterTypes() == null || constructorArray[i].getParameterTypes().length != 1 || !ViolatedConstraintNameExtracter.class.isAssignableFrom(constructorArray[i].getParameterTypes()[0])) continue;
                try {
                    return (SQLExceptionConverter)constructorArray[i].newInstance(violatedConstraintNameExtracter);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return (SQLExceptionConverter)clazz.newInstance();
        }
        catch (Throwable throwable) {
            LOG.unableToConstructSqlExceptionConverter(throwable);
            return null;
        }
    }
}

