/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.JDBCException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.AbstractSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.internal.util.JdbcExceptionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStateConversionDelegate
extends AbstractSQLExceptionConversionDelegate {
    private static final Set<String> SQL_GRAMMAR_CATEGORIES = SQLStateConversionDelegate.buildGrammarCategories();
    private static final Set DATA_CATEGORIES = SQLStateConversionDelegate.buildDataCategories();
    private static final Set INTEGRITY_VIOLATION_CATEGORIES = SQLStateConversionDelegate.buildContraintCategories();
    private static final Set CONNECTION_CATEGORIES = SQLStateConversionDelegate.buildConnectionCategories();

    private static Set<String> buildGrammarCategories() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList("07", "20", "2A", "37", "42", "65", "S0"));
        return Collections.unmodifiableSet(hashSet);
    }

    private static Set<String> buildDataCategories() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList("21", "22"));
        return Collections.unmodifiableSet(hashSet);
    }

    private static Set<String> buildContraintCategories() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList("23", "27", "44"));
        return Collections.unmodifiableSet(hashSet);
    }

    private static Set<String> buildConnectionCategories() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("08");
        return Collections.unmodifiableSet(hashSet);
    }

    public SQLStateConversionDelegate(ConversionContext conversionContext) {
        super(conversionContext);
    }

    @Override
    public JDBCException convert(SQLException sQLException, String string, String string2) {
        String string3 = JdbcExceptionHelper.extractSqlState(sQLException);
        int n = JdbcExceptionHelper.extractErrorCode(sQLException);
        if (string3 != null) {
            String string4 = JdbcExceptionHelper.determineSqlStateClassCode(string3);
            if (string4 != null) {
                if (SQL_GRAMMAR_CATEGORIES.contains(string4)) {
                    return new SQLGrammarException(string, sQLException, string2);
                }
                if (INTEGRITY_VIOLATION_CATEGORIES.contains(string4)) {
                    String string5 = this.getConversionContext().getViolatedConstraintNameExtracter().extractConstraintName(sQLException);
                    return new ConstraintViolationException(string, sQLException, string2, string5);
                }
                if (CONNECTION_CATEGORIES.contains(string4)) {
                    return new JDBCConnectionException(string, sQLException, string2);
                }
                if (DATA_CATEGORIES.contains(string4)) {
                    return new DataException(string, sQLException, string2);
                }
            }
            if ("40001".equals(string3)) {
                return new LockAcquisitionException(string, sQLException, string2);
            }
            if ("40XL1".equals(string3) || "40XL2".equals(string3)) {
                return new PessimisticLockException(string, sQLException, string2);
            }
            if ("70100".equals(string3) || "72000".equals(string3) && n == 1013) {
                throw new QueryTimeoutException(string, sQLException, string2);
            }
        }
        return null;
    }
}

